/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.providers;

import com.swtdesigner.ResourceManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeElement;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Stereotype;

public class ParticipantTypeLabelProvider
extends LabelProvider {
    public Image getImage(Object object) {
        if (object instanceof ParticipantTypeElement) {
            EObject eObject = ((ParticipantTypeElement)object).getElement();
            if (eObject instanceof ENamedElement) {
                String imagePath = "/icons/full/obj16/" + ((ENamedElement)eObject).getName() + ".gif";
                return ResourceManager.getPluginImage("org.eclipse.uml2.uml.edit", imagePath);
            }
            if (eObject instanceof Stereotype) {
                EList icons = StereotypeUtil.getIcons((Stereotype)((Stereotype)eObject));
                if (icons.size() > 0) {
                    org.eclipse.uml2.uml.Image icon = (org.eclipse.uml2.uml.Image)icons.get(icons.size() - 1);
                    Image image = null;
                    try {
                        image = ImageUtil.getContent((org.eclipse.uml2.uml.Image)icon);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (image == null) {
                        image = ImageUtil.getImageFromLocation((org.eclipse.uml2.uml.Image)icon);
                    }
                    if (image.getBounds().width != 16 || image.getBounds().height != 16) {
                        return this.resize(image, 16, 16);
                    }
                    return image;
                }
                LabelProviderServiceImpl service = new LabelProviderServiceImpl();
                try {
                    service.startService();
                    return service.getLabelProvider().getImage((Object)eObject);
                }
                catch (ServiceException e) {
                    Activator.log.warn(String.valueOf(Messages.FilterTypeLabelProvider_0) + eObject);
                    return null;
                }
            }
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof ParticipantTypeElement) {
            return ((ParticipantTypeElement)object).getText();
        }
        return "";
    }

    private Image resize(Image image, int width, int height) {
        double dpi = Display.getDefault().getDPI().x;
        double scale = dpi / 96.0;
        int scaledWidth = (int)((double)width * scale);
        int scaledHeight = (int)((double)height * scale);
        Image scaled = new Image((Device)Display.getDefault(), scaledWidth, scaledHeight);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, scaledWidth, scaledHeight);
        gc.dispose();
        image.dispose();
        return scaled;
    }
}

