/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.etl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.schedule.Schedule;

public class PivotModel
extends EmfModel {
    @NonNull
    private EnvironmentFactory environmentFactory;
    private boolean isASResource;
    @Nullable
    private Map<?, ?> savingOptions;

    public PivotModel(@NonNull EnvironmentFactory environmentFactory, boolean isASResource) {
        this(environmentFactory, isASResource, null);
    }

    public PivotModel(@NonNull EnvironmentFactory environmentFactory, boolean isASResource, @Nullable Map<?, ?> savingOptions) {
        this.isASResource = isASResource;
        this.environmentFactory = environmentFactory;
        this.savingOptions = savingOptions;
    }

    public void loadModelFromUri() throws EolModelLoadingException {
        ResourceSet rSet = this.isASResource ? this.environmentFactory.getMetamodelManager().getASResourceSet() : this.environmentFactory.getResourceSet();
        this.determinePackagesFrom(rSet);
        try {
            if (this.readOnLoad) {
                this.modelImpl = rSet.getResource(this.modelUri, true);
                if (this.expand) {
                    EcoreUtil.resolveAll((Resource)this.modelImpl);
                }
            } else {
                this.modelImpl = rSet.createResource(this.modelUri);
            }
        }
        catch (RuntimeException e) {
            throw new EolModelLoadingException((Exception)e, (IModel)this);
        }
    }

    protected EClass classForName(String name, EPackage.Registry registry) {
        boolean absolute = name.indexOf("::") > -1;
        EClass epClass = null;
        for (EPackage ePackage : this.packages) {
            epClass = this.classForName(name, absolute, ePackage);
            if (epClass != null) break;
        }
        return epClass;
    }

    private EClass classForName(String name, boolean absolute, EPackage pkg) {
        for (EClassifier eClassifier : EmfUtil.getAllEClassifiers((EPackage)pkg)) {
            if (!(eClassifier instanceof EClass)) continue;
            String eClassifierName = "";
            eClassifierName = absolute ? this.getFullyQualifiedName(eClassifier) : eClassifier.getName();
            if (eClassifierName.compareTo(name) != 0) continue;
            return (EClass)eClassifier;
        }
        return null;
    }

    protected void determinePackagesFrom(ResourceSet resourceSet) throws EolModelLoadingException {
        this.packages = new ArrayList();
        for (URI metamodelUri : this.metamodelUris) {
            EPackage ePackage = resourceSet.getPackageRegistry().getEPackage(metamodelUri.toString());
            if (ePackage == null) {
                throw new EolModelLoadingException((Exception)new IllegalArgumentException("Could not locate a metamodel with the URI '" + metamodelUri + "'. Please ensure that this metamodel has been registered with Epsilon."), (IModel)this);
            }
            this.packages.add(ePackage);
            EmfUtil.collectDependencies((EPackage)ePackage, (List)this.packages);
        }
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        for (EPackage ePackage : this.packages) {
            for (EClassifier classifier : EmfUtil.getAllEClassifiers((EPackage)ePackage)) {
                EEnum eEnum;
                EEnumLiteral literal;
                if (!(classifier instanceof EEnum) || !((EEnum)classifier).getName().equals(enumeration) && !this.getFullyQualifiedName(classifier).equals(enumeration) || (literal = (eEnum = (EEnum)classifier).getEEnumLiteral(label)) == null) continue;
                return literal.getInstance();
            }
        }
        throw new EolEnumerationValueNotFoundException(enumeration, label, this.getName());
    }

    protected Collection<EObject> allContentsFromModel() {
        ArrayList<EObject> allInstances = new ArrayList<EObject>();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.expand && this.modelImpl.getResourceSet() != null) {
            resources.addAll((Collection<Resource>)this.modelImpl.getResourceSet().getResources());
        } else {
            resources.add(this.modelImpl);
        }
        for (Resource resource : resources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!this.packages.contains(o.eClass().getEPackage())) continue;
                allInstances.add(o);
            }
        }
        return allInstances;
    }

    public EObject getRooteObject() {
        return (EObject)this.modelImpl.getContents().get(0);
    }

    public Transformation getTransformation() throws Exception {
        for (EObject eContent : this.modelImpl.getContents()) {
            if (!(eContent instanceof ImperativeModel)) continue;
            for (Package aPackage : ((ImperativeModel)eContent).getOwnedPackages()) {
                for (Class aClass : aPackage.getOwnedClasses()) {
                    if (!(aClass instanceof Transformation)) continue;
                    return (Transformation)aClass;
                }
            }
        }
        throw new Exception("The QVTd model does not have a Transformation element.");
    }

    public MetamodelManagerInternal getMetaModelManager() {
        return (MetamodelManagerInternal)this.environmentFactory.getMetamodelManager();
    }

    public boolean store() {
        if (this.modelImpl == null) {
            return false;
        }
        try {
            this.modelImpl.save(this.savingOptions);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Schedule getSchedule() throws Exception {
        for (EObject eContent : this.modelImpl.getContents()) {
            if (!(eContent instanceof Schedule)) continue;
            return (Schedule)eContent;
        }
        throw new Exception("The QVTs model does not have a Schedule element.");
    }
}

