/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import com.google.inject.Inject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.ui.MarkerUtil;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;
import org.eclipse.xtext.validation.Issue;

public class IssueUtil {
    private MarkerUtil markerUtil;

    @Inject
    public void setMarkerUtil(MarkerUtil markerUtil) {
        this.markerUtil = markerUtil;
    }

    public Issue createIssue(IMarker marker) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setMessage(MarkerUtilities.getMessage((IMarker)marker));
        issue.setLineNumber(Integer.valueOf(MarkerUtilities.getLineNumber((IMarker)marker) - 1));
        issue.setOffset(Integer.valueOf(MarkerUtilities.getCharStart((IMarker)marker)));
        issue.setLength(Integer.valueOf(MarkerUtilities.getCharEnd((IMarker)marker) - MarkerUtilities.getCharStart((IMarker)marker)));
        issue.setCode(this.markerUtil.getCode(marker));
        issue.setData(this.markerUtil.getIssueData(marker));
        issue.setUriToProblem(this.markerUtil.getUriToProblem(marker));
        issue.setSeverity(this.markerUtil.getSeverity(marker));
        issue.setType(MarkerTypes.toCheckType(MarkerUtilities.getMarkerType((IMarker)marker)));
        return issue;
    }

    public Issue getIssueFromAnnotation(Annotation annotation) {
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xtextAnnotation = (XtextAnnotation)annotation;
            return xtextAnnotation.getIssue();
        }
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            return this.createIssue(markerAnnotation.getMarker());
        }
        return null;
    }
}

