/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticNodeIterator
implements Iterator<Triple<INode, AbstractElement, EObject>> {
    protected Triple<INode, AbstractElement, EObject> next;

    public SemanticNodeIterator(EObject obj) {
        INode start = NodeModelUtils.findActualNodeFor(obj);
        if (start != null) {
            if (this.isEObjectNode(start)) {
                start = start.getFirstChild();
            }
            this.next = this.findNext(start, false);
        } else {
            this.next = null;
        }
    }

    public SemanticNodeIterator(INode start) {
        this.next = start != null ? this.findNext(start, true) : null;
    }

    protected Triple<INode, AbstractElement, EObject> findNext(INode node, boolean prune) {
        INode current = this.next(node, prune);
        while (current != null) {
            if (current instanceof ILeafNode && ((ILeafNode)current).isHidden()) {
                current = this.next(current, true);
                continue;
            }
            EObject ge = current.getGrammarElement();
            if (this.isEObjectNode(current)) {
                return Tuples.create((Object)current, (Object)((AbstractElement)ge), (Object)this.getEObjectNodeEObject(current));
            }
            if (GrammarUtil.isAssigned(ge) && !GrammarUtil.isEObjectRuleCall(ge)) {
                if (ge instanceof CrossReference) {
                    return Tuples.create((Object)current, (Object)((CrossReference)ge).getTerminal(), null);
                }
                return Tuples.create((Object)current, (Object)((AbstractElement)ge), null);
            }
            current = this.next(current, false);
        }
        return null;
    }

    protected EObject getEObjectNodeEObject(INode node) {
        if (node.hasDirectSemanticElement()) {
            return node.getSemanticElement();
        }
        for (INode n : node.getAsTreeIterable()) {
            if (!n.hasDirectSemanticElement()) continue;
            return n.getSemanticElement();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    protected boolean isEObjectNode(INode node) {
        if (node.getGrammarElement() instanceof AbstractRule) {
            return true;
        }
        if (node.getGrammarElement() instanceof Action) {
            return true;
        }
        if (GrammarUtil.isAssignedEObjectRuleCall(node.getGrammarElement())) {
            if (node.hasDirectSemanticElement()) {
                return true;
            }
            AbstractRule rule = ((RuleCall)node.getGrammarElement()).getRule();
            node = node.getParent();
            while (node != null) {
                if (GrammarUtil.isAssigned(node.getGrammarElement())) {
                    return true;
                }
                if (node.getGrammarElement() instanceof Action && GrammarUtil.containingRule(node.getGrammarElement()) == rule) {
                    return false;
                }
                node = node.getParent();
            }
            return true;
        }
        return false;
    }

    @Override
    public Triple<INode, AbstractElement, EObject> next() {
        Triple<INode, AbstractElement, EObject> oldNext = this.next;
        if (this.next != null) {
            this.next = this.findNext((INode)this.next.getFirst(), true);
        }
        return oldNext;
    }

    protected INode next(INode node, boolean prune) {
        INode child;
        if (!prune && node instanceof ICompositeNode && (child = ((ICompositeNode)node).getFirstChild()) != null) {
            return child;
        }
        INode n = node.getNextSibling();
        while (n == null) {
            if ((node = node.getParent()) == null || this.isEObjectNode(node)) {
                return null;
            }
            n = node.getNextSibling();
        }
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

