/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xtend2.dispatch.DispatchingSupport;
import org.eclipse.xtext.xtend2.jvmmodel.SyntheticNameClashResolver;
import org.eclipse.xtext.xtend2.jvmmodel.Xtend2CompileStrategies;
import org.eclipse.xtext.xtend2.xtend2.CreateExtensionInfo;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendConstructor;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;
import org.eclipse.xtext.xtend2.xtend2.XtendParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2JvmModelInferrer
implements IJvmModelInferrer {
    public static final String CREATE_INITIALIZER_PREFIX = "_init_";
    public static final String CREATE_CHACHE_VARIABLE_PREFIX = "_createCache_";
    @Inject
    protected TypesFactory typesFactory;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Xtend2CompileStrategies compileStrategies;
    @Inject
    private JvmTypesBuilder jvmTypesBuilder;
    @Inject
    private SyntheticNameClashResolver nameClashResolver;

    public void infer(EObject xtendFile, IAcceptor<JvmDeclaredType> acceptor, boolean prelinkingPhase) {
        if (!(xtendFile instanceof XtendFile)) {
            throw new IllegalArgumentException("expected XtendFile but was " + xtendFile);
        }
        XtendFile xtendFile2 = (XtendFile)xtendFile;
        XtendClass xtendClass = xtendFile2.getXtendClass();
        if (xtendClass == null) {
            return;
        }
        JvmGenericType inferredJvmType = this.transform(xtendClass, prelinkingPhase);
        acceptor.accept((Object)inferredJvmType);
    }

    protected JvmGenericType transform(XtendClass source, boolean prelinkingPhase) {
        JvmGenericType inferredJvmType = this.typesFactory.createJvmGenericType();
        source.eResource().getContents().add((Object)inferredJvmType);
        this.associator.associatePrimary((EObject)source, (EObject)inferredJvmType);
        inferredJvmType.setPackageName(source.getPackageName());
        inferredJvmType.setSimpleName(source.getName());
        inferredJvmType.setVisibility(JvmVisibility.PUBLIC);
        if (!prelinkingPhase) {
            JvmAnnotationType annotation = (JvmAnnotationType)this.typeReferences.findDeclaredType(SuppressWarnings.class, (EObject)source);
            if (annotation != null) {
                JvmAnnotationReference suppressWarnings = this.typesFactory.createJvmAnnotationReference();
                suppressWarnings.setAnnotation(annotation);
                JvmStringAnnotationValue annotationValue = this.typesFactory.createJvmStringAnnotationValue();
                annotationValue.getValues().add((Object)"all");
                suppressWarnings.getValues().add((Object)annotationValue);
                inferredJvmType.getAnnotations().add((Object)suppressWarnings);
            }
            this.addDefaultConstructor(source, inferredJvmType);
            if (source.getExtends() == null) {
                JvmTypeReference typeRefToObject = this.typeReferences.getTypeForName(Object.class, (EObject)source, new JvmTypeReference[0]);
                if (typeRefToObject != null) {
                    inferredJvmType.getSuperTypes().add((Object)typeRefToObject);
                }
            } else {
                inferredJvmType.getSuperTypes().add((Object)((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)source.getExtends())));
            }
            for (JvmTypeReference intf : source.getImplements()) {
                inferredJvmType.getSuperTypes().add((Object)((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)intf)));
            }
            this.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)inferredJvmType);
            for (XtendMember member : source.getMembers()) {
                if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).getName() == null) && !(member instanceof XtendConstructor)) continue;
                this.transform(member, inferredJvmType);
            }
            this.appendSyntheticDispatchMethods(source, inferredJvmType);
            this.computeInferredReturnTypes(inferredJvmType);
            this.jvmTypesBuilder.translateAnnotationsTo(source.getAnnotations(), (JvmAnnotationTarget)inferredJvmType);
            this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)inferredJvmType, this.jvmTypesBuilder.getDocumentation((EObject)source));
            this.nameClashResolver.resolveNameClashes(inferredJvmType);
        }
        return inferredJvmType;
    }

    protected void copyAndFixTypeParameters(List<JvmTypeParameter> typeParameters, JvmTypeParameterDeclarator target) {
        for (JvmTypeParameter typeParameter : typeParameters) {
            JvmTypeParameter clonedTypeParameter = (JvmTypeParameter)EcoreUtil2.cloneWithProxies((EObject)typeParameter);
            target.getTypeParameters().add((Object)clonedTypeParameter);
            boolean upperBoundSeen = false;
            for (JvmTypeConstraint constraint : clonedTypeParameter.getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                upperBoundSeen = true;
                break;
            }
            if (!upperBoundSeen) {
                JvmUpperBound upperBound = this.typesFactory.createJvmUpperBound();
                upperBound.setTypeReference(this.typeReferences.getTypeForName(Object.class, (EObject)typeParameter, new JvmTypeReference[0]));
                clonedTypeParameter.getConstraints().add((Object)upperBound);
            }
            this.associator.associate((EObject)typeParameter, (EObject)clonedTypeParameter);
        }
    }

    protected void appendSyntheticDispatchMethods(XtendClass source, JvmGenericType target) {
        Multimap<Pair<String, Integer>, JvmOperation> methods = this.dispatchingSupport.getDispatchMethods(target);
        for (Pair key : methods.keySet()) {
            Collection operations = methods.get((Object)key);
            JvmOperation operation = this.deriveGenericDispatchOperationSignature(this.dispatchingSupport.sort(operations), target);
            operation.setSimpleName((String)key.getFirst());
        }
    }

    protected JvmOperation deriveGenericDispatchOperationSignature(List<JvmOperation> sortedOperations, JvmGenericType target) {
        if (sortedOperations.isEmpty()) {
            return null;
        }
        Iterator<JvmOperation> iterator = sortedOperations.iterator();
        JvmOperation first = iterator.next();
        JvmOperation result = this.typesFactory.createJvmOperation();
        target.getMembers().add((Object)result);
        int i = 0;
        while (i < first.getParameters().size()) {
            JvmFormalParameter parameter = this.typesFactory.createJvmFormalParameter();
            result.getParameters().add((Object)parameter);
            parameter.setParameterType(this.getTypeProxy((EObject)parameter));
            JvmFormalParameter parameter2 = (JvmFormalParameter)first.getParameters().get(i);
            parameter.setName(parameter2.getName());
            ++i;
        }
        this.jvmTypesBuilder.setBody((JvmExecutable)result, this.compileStrategies.forDispatcher(result, sortedOperations));
        JvmVisibility commonVisibility = null;
        boolean isFirst = true;
        boolean allStatic = true;
        for (JvmOperation jvmOperation : sortedOperations) {
            Iterable xtendFunctions = Iterables.filter((Iterable)this.associations.getSourceElements((EObject)jvmOperation), XtendFunction.class);
            for (XtendFunction func : xtendFunctions) {
                JvmVisibility xtendVisibility;
                JvmVisibility jvmVisibility = xtendVisibility = func.eIsSet((EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__VISIBILITY) ? func.getVisibility() : null;
                if (isFirst) {
                    commonVisibility = xtendVisibility;
                    isFirst = false;
                } else if (commonVisibility != xtendVisibility) {
                    commonVisibility = null;
                }
                this.associator.associate((EObject)func, (EObject)result);
                if (func.isStatic()) continue;
                allStatic = false;
            }
        }
        if (commonVisibility == null) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(commonVisibility);
        }
        result.setStatic(allStatic);
        return result;
    }

    protected void addDefaultConstructor(XtendClass source, JvmGenericType target) {
        boolean declaredConstructor = false;
        for (XtendMember member : source.getMembers()) {
            if (!(member instanceof XtendConstructor)) continue;
            declaredConstructor = true;
            break;
        }
        if (!declaredConstructor) {
            JvmConstructor constructor = this.typesFactory.createJvmConstructor();
            target.getMembers().add((Object)constructor);
            this.associator.associatePrimary((EObject)source, (EObject)constructor);
            constructor.setSimpleName(source.getName());
            constructor.setVisibility(JvmVisibility.PUBLIC);
        }
    }

    protected void transform(XtendMember sourceMember, JvmGenericType container) {
        if (sourceMember instanceof XtendFunction) {
            this.transform((XtendFunction)sourceMember, container);
        } else if (sourceMember instanceof XtendField) {
            this.transform((XtendField)sourceMember, container);
        } else if (sourceMember instanceof XtendConstructor) {
            this.transform((XtendConstructor)sourceMember, container);
        } else {
            throw new IllegalArgumentException("Cannot transform " + Strings.notNull((Object)sourceMember) + " to a JvmMember");
        }
    }

    protected void transform(XtendFunction source, JvmGenericType container) {
        JvmOperation operation = this.typesFactory.createJvmOperation();
        container.getMembers().add((Object)operation);
        this.associator.associatePrimary((EObject)source, (EObject)operation);
        String sourceName = source.getName();
        JvmVisibility visibility = source.getVisibility();
        if (source.isDispatch()) {
            if (!source.eIsSet((EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__VISIBILITY)) {
                visibility = JvmVisibility.PROTECTED;
            }
            sourceName = "_" + sourceName;
        }
        operation.setSimpleName(sourceName);
        operation.setVisibility(visibility);
        operation.setStatic(source.isStatic());
        for (XtendParameter parameter : source.getParameters()) {
            JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
            jvmParam.setName(parameter.getName());
            jvmParam.setParameterType((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)parameter.getParameterType()));
            operation.getParameters().add((Object)jvmParam);
            this.associator.associate((EObject)parameter, (EObject)jvmParam);
        }
        JvmTypeReference returnType = null;
        returnType = source.getReturnType() != null ? (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)source.getReturnType()) : this.getTypeProxy((EObject)operation);
        operation.setReturnType(returnType);
        this.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)operation);
        for (JvmTypeReference exception : source.getExceptions()) {
            operation.getExceptions().add((Object)((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)exception)));
        }
        this.jvmTypesBuilder.translateAnnotationsTo(source.getAnnotationInfo().getAnnotations(), (JvmAnnotationTarget)operation);
        CreateExtensionInfo createExtensionInfo = source.getCreateExtensionInfo();
        if (createExtensionInfo != null) {
            JvmTypeReference arrayList = this.typeReferences.getTypeForName(ArrayList.class, (EObject)container, new JvmTypeReference[]{this.typeReferences.wildCard()});
            JvmTypeReference hashMap = this.typeReferences.getTypeForName(HashMap.class, (EObject)container, new JvmTypeReference[]{arrayList, (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)returnType)});
            JvmField cacheVar = this.jvmTypesBuilder.toField((EObject)source, CREATE_CHACHE_VARIABLE_PREFIX + source.getName(), hashMap);
            cacheVar.setFinal(true);
            this.jvmTypesBuilder.setInitializer(cacheVar, this.compileStrategies.forCacheVariable(container));
            container.getMembers().add((Object)cacheVar);
            JvmOperation initializer = this.typesFactory.createJvmOperation();
            container.getMembers().add((Object)initializer);
            initializer.setSimpleName(CREATE_INITIALIZER_PREFIX + source.getName());
            initializer.setVisibility(JvmVisibility.PRIVATE);
            initializer.setReturnType(this.typeReferences.getTypeForName(Void.TYPE, (EObject)source, new JvmTypeReference[0]));
            for (JvmTypeReference exception : source.getExceptions()) {
                initializer.getExceptions().add((Object)((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)exception)));
            }
            this.jvmTypesBuilder.setBody((JvmExecutable)operation, this.compileStrategies.forCacheMethod(createExtensionInfo, cacheVar, initializer));
            JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
            jvmParam.setName(createExtensionInfo.getName());
            jvmParam.setParameterType(this.getTypeProxy((EObject)createExtensionInfo.getCreateExpression()));
            initializer.getParameters().add((Object)jvmParam);
            this.associator.associate((EObject)createExtensionInfo, (EObject)jvmParam);
            for (XtendParameter parameter : source.getParameters()) {
                jvmParam = this.typesFactory.createJvmFormalParameter();
                jvmParam.setName(parameter.getName());
                jvmParam.setParameterType((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)parameter.getParameterType()));
                initializer.getParameters().add((Object)jvmParam);
                this.associator.associate((EObject)parameter, (EObject)jvmParam);
            }
            this.associator.associate((EObject)source, (EObject)initializer);
            this.associator.associateLogicalContainer((EObject)createExtensionInfo.getCreateExpression(), (JvmIdentifiableElement)operation);
            this.associator.associateLogicalContainer((EObject)source.getExpression(), (JvmIdentifiableElement)initializer);
        } else {
            this.associator.associateLogicalContainer((EObject)source.getExpression(), (JvmIdentifiableElement)operation);
        }
        this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)operation, this.jvmTypesBuilder.getDocumentation((EObject)source));
    }

    protected void transform(XtendConstructor source, JvmGenericType container) {
        JvmConstructor constructor = this.typesFactory.createJvmConstructor();
        container.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)source, (EObject)constructor);
        JvmVisibility visibility = source.getVisibility();
        constructor.setSimpleName(container.getSimpleName());
        constructor.setVisibility(visibility);
        for (XtendParameter parameter : source.getParameters()) {
            JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
            jvmParam.setName(parameter.getName());
            jvmParam.setParameterType((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)parameter.getParameterType()));
            constructor.getParameters().add((Object)jvmParam);
            this.associator.associate((EObject)parameter, (EObject)jvmParam);
        }
        this.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)constructor);
        for (JvmTypeReference exception : source.getExceptions()) {
            constructor.getExceptions().add((Object)((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)exception)));
        }
        this.jvmTypesBuilder.translateAnnotationsTo(source.getAnnotationInfo().getAnnotations(), (JvmAnnotationTarget)constructor);
        this.associator.associateLogicalContainer((EObject)source.getExpression(), (JvmIdentifiableElement)constructor);
        this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)constructor, this.jvmTypesBuilder.getDocumentation((EObject)source));
    }

    protected void transform(XtendField source, JvmGenericType container) {
        if ((source.isExtension() || source.getName() != null) && source.getType() != null) {
            JvmField field = this.typesFactory.createJvmField();
            field.setSimpleName(this.computeFieldName(source, container));
            container.getMembers().add((Object)field);
            this.associator.associatePrimary((EObject)source, (EObject)field);
            field.setVisibility(source.getVisibility());
            field.setStatic(source.isStatic());
            field.setType((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)source.getType()));
            this.jvmTypesBuilder.translateAnnotationsTo(source.getAnnotationInfo().getAnnotations(), (JvmAnnotationTarget)field);
            this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)field, this.jvmTypesBuilder.getDocumentation((EObject)source));
            this.jvmTypesBuilder.setInitializer(field, source.getInitialValue());
        }
    }

    protected String computeFieldName(XtendField field, JvmGenericType declaringType) {
        if (field.getName() != null) {
            return field.getName();
        }
        JvmTypeReference type = field.getType();
        String name = null;
        if (type != null) {
            List nodes;
            while (type instanceof JvmGenericArrayTypeReference) {
                type = ((JvmGenericArrayTypeReference)type).getComponentType();
            }
            if (type instanceof JvmParameterizedTypeReference && !(nodes = NodeModelUtils.findNodesForFeature((EObject)type, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)).isEmpty()) {
                String typeName = ((INode)nodes.get(0)).getText().trim();
                int lastDot = typeName.lastIndexOf(46);
                if (lastDot != -1) {
                    typeName = typeName.substring(lastDot + 1);
                }
                name = "_" + Strings.toFirstLower((String)typeName);
            }
        }
        return name;
    }

    protected void computeInferredReturnTypes(JvmGenericType inferredJvmType) {
        Iterable operations = inferredJvmType.getDeclaredOperations();
        for (JvmOperation jvmOperation : operations) {
            if (jvmOperation.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_OPERATION__RETURN_TYPE)) continue;
            jvmOperation.setReturnType(this.getTypeProxy((EObject)jvmOperation));
        }
    }

    protected JvmTypeReference getTypeProxy(EObject pointer) {
        JvmParameterizedTypeReference typeReference = this.typesFactory.createJvmParameterizedTypeReference();
        Resource eResource = pointer.eResource();
        String fragment = eResource.getURIFragment(pointer);
        URI uri = eResource.getURI();
        uri = uri.appendFragment("\u00a7lazyType$" + fragment);
        ((InternalEObject)typeReference).eSetProxyURI(uri);
        return typeReference;
    }
}

