/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.inject.Inject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;
import org.eclipse.xtext.ui.editor.model.DocumentUtil;

public abstract class AbstractTerminalsEditStrategy
extends AbstractEditStrategy {
    private String leftTerminal;
    private String rightTerminal;
    @Inject
    protected DocumentUtil util = new DocumentUtil();

    public void setDocumentUtil(DocumentUtil util) {
        this.util = util;
    }

    public AbstractTerminalsEditStrategy(String leftTerminal, String rightTerminal) {
        if (leftTerminal == null || rightTerminal == null) {
            throw new IllegalArgumentException("The terminals must not be null.");
        }
        if (!this.allowsEqualTerminals() && leftTerminal.equals(rightTerminal)) {
            throw new IllegalArgumentException("The left and right terminal have to be different.");
        }
        this.leftTerminal = leftTerminal;
        this.rightTerminal = rightTerminal;
    }

    public String getLeftTerminal() {
        return this.leftTerminal;
    }

    public String getRightTerminal() {
        return this.rightTerminal;
    }

    protected boolean allowsEqualTerminals() {
        return false;
    }

    protected DocumentUtil getDocumentUtil() {
        return this.util;
    }

    protected IRegion findStopTerminal(IDocument document, int offset) throws BadLocationException {
        int stopOffset = offset;
        int startOffset = offset;
        IRegion stop;
        while ((stop = this.util.searchInSamePartition(this.getRightTerminal(), document, stopOffset)) != null) {
            IRegion start = this.util.searchInSamePartition(this.getLeftTerminal(), document, startOffset);
            if (start == null || start.getOffset() > stop.getOffset()) {
                return stop;
            }
            stopOffset = this.util.findNextOffSetInPartition(document, stopOffset, stop.getOffset() + stop.getLength());
            startOffset = this.util.findNextOffSetInPartition(document, startOffset, start.getOffset() + start.getLength());
        }
        return null;
    }

    protected IRegion findStartTerminal(IDocument document, int offset) throws BadLocationException {
        int stopOffset = offset;
        int startOffset = offset;
        IRegion start;
        while ((start = this.util.searchBackwardsInSamePartition(this.getLeftTerminal(), document, startOffset)) != null) {
            IRegion stop = this.util.searchBackwardsInSamePartition(this.getRightTerminal(), document, stopOffset);
            if (stop == null || stop.getOffset() < start.getOffset()) {
                return start;
            }
            stopOffset = stop.getOffset();
            startOffset = start.getOffset();
        }
        return null;
    }
}

