/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.inject.Inject;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedNameValueConverter
extends AbstractValueConverter<String> {
    @Inject
    protected IValueConverterService valueConverterService;
    protected String fullWildcardLiteral = null;

    @Deprecated
    protected String getNamespaceDelimiter() {
        return ".";
    }

    protected String getStringNamespaceDelimiter() {
        return this.getNamespaceDelimiter();
    }

    protected String getValueNamespaceDelimiter() {
        return this.getNamespaceDelimiter();
    }

    protected String getWildcardLiteral() {
        return "*";
    }

    protected String getDelegateRuleName() {
        return "ID";
    }

    @Override
    public String toString(String value) {
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        String[] stringArray = value.split(Pattern.quote(this.getValueNamespaceDelimiter()));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!isFirst) {
                buffer.append(this.getStringNamespaceDelimiter());
            }
            isFirst = false;
            if (this.getWildcardLiteral().equals(segment)) {
                buffer.append(this.getWildcardLiteral());
            } else {
                buffer.append(this.delegateToString(segment));
            }
            ++n2;
        }
        return buffer.toString();
    }

    @Override
    public String toValue(String string, INode node) throws ValueConverterException {
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                EObject grammarElement = leafNode.getGrammarElement();
                if (!this.isDelegateRuleCall(grammarElement) && !this.isWildcardLiteral(grammarElement)) continue;
                if (!isFirst) {
                    buffer.append(this.getValueNamespaceDelimiter());
                }
                isFirst = false;
                if (this.isDelegateRuleCall(grammarElement)) {
                    buffer.append(this.delegateToValue(leafNode));
                    continue;
                }
                buffer.append(this.getWildcardLiteral());
            }
        } else {
            String[] stringArray = string.split(Pattern.quote(this.getStringNamespaceDelimiter()));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (!isFirst) {
                    buffer.append(this.getValueNamespaceDelimiter());
                }
                isFirst = false;
                if (this.getWildcardLiteral().equals(segment)) {
                    buffer.append(this.getWildcardLiteral());
                } else {
                    buffer.append(this.delegateToString(segment));
                }
                ++n2;
            }
        }
        return buffer.toString();
    }

    protected boolean isDelegateRuleCall(EObject grammarElement) {
        return grammarElement instanceof RuleCall && this.getDelegateRuleName().equals(((RuleCall)grammarElement).getRule().getName());
    }

    protected boolean isWildcardLiteral(EObject grammarElement) {
        if (grammarElement instanceof Keyword) {
            String keyword = ((Keyword)grammarElement).getValue();
            return this.getWildcardLiteral().equals(keyword) || this.getFullWildcardLiteral().equals(keyword);
        }
        return false;
    }

    protected String getFullWildcardLiteral() {
        if (this.fullWildcardLiteral == null) {
            this.fullWildcardLiteral = String.valueOf(this.getStringNamespaceDelimiter()) + this.getWildcardLiteral();
        }
        return this.fullWildcardLiteral;
    }

    protected String delegateToString(String segment) {
        return this.valueConverterService.toString(segment, this.getDelegateRuleName());
    }

    protected String delegateToValue(ILeafNode leafNode) {
        return (String)this.valueConverterService.toValue(leafNode.getText(), this.getDelegateRuleName(), leafNode);
    }
}

