/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.IRenameSupport;
import org.eclipse.xtext.ui.refactoring.ui.LinkedEditingUndoSupport;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringType;
import org.eclipse.xtext.ui.refactoring.ui.RenameLinkedMode;
import org.eclipse.xtext.ui.refactoring.ui.ViewFreezer;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

@Singleton
public class RenameRefactoringController {
    @Inject(optional=true)
    private IWorkbench workbench;
    @Inject
    private Provider<RenameLinkedMode> renameLinkedModeProvider;
    @Inject
    private IRenameSupport.Factory renameSupportFactory;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    private RenameLinkedMode activeLinkedMode;
    private IRenameElementContext renameElementContext;
    private LinkedEditingUndoSupport undoSupport;
    private String newName;

    public void initialize(IRenameElementContext renameElementContext) {
        this.renameElementContext = renameElementContext;
        this.newName = null;
    }

    public void startRefactoring(RefactoringType refactoringType) {
        ViewFreezer freezer = null;
        try {
            if (refactoringType == RefactoringType.LINKED_EDITING) {
                this.startLinkedEditing();
                return;
            }
            try {
                if (this.activeLinkedMode != null) {
                    this.newName = this.activeLinkedMode.getCurrentName();
                }
                freezer = new ViewFreezer(this.getXtextEditor().getInternalSourceViewer());
                freezer.freeze();
                if (this.undoSupport != null) {
                    this.undoSupport.undoDocumentChanges();
                    this.undoSupport = null;
                }
                this.cancelLinkedMode();
                switch (refactoringType) {
                    case REFACTORING_DIRECT: {
                        this.startDirectRefactoring();
                        break;
                    }
                    case REFACTORING_DIALOG: {
                        this.startRefactoringWithDialog(false);
                        break;
                    }
                    case REFACTORING_PREVIEW: {
                        this.startRefactoringWithDialog(true);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid refactoring type " + refactoringType.toString());
                    }
                }
            }
            catch (InterruptedException exc) {
                this.restoreOriginalSelection();
            }
        }
        finally {
            if (freezer != null) {
                freezer.release();
            }
        }
    }

    protected void startLinkedEditing() {
        if (this.activeLinkedMode != null) {
            if (this.activeLinkedMode.isSameRenameElementContext(this.renameElementContext)) {
                this.startRefactoring(RefactoringType.REFACTORING_DIALOG);
                return;
            }
            this.cancelLinkedMode();
        }
        try {
            final XtextEditor xtextEditor = this.getXtextEditor();
            if (xtextEditor != null) {
                this.workbench.getProgressService().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        RenameLinkedMode newLinkedMode = (RenameLinkedMode)RenameRefactoringController.this.renameLinkedModeProvider.get();
                        if (newLinkedMode.start(RenameRefactoringController.this.renameElementContext, monitor)) {
                            RenameRefactoringController.this.activeLinkedMode = newLinkedMode;
                            RenameRefactoringController.this.undoSupport = new LinkedEditingUndoSupport(xtextEditor);
                        }
                    }
                });
                if (this.activeLinkedMode == null) {
                    this.startRefactoring(RefactoringType.REFACTORING_DIALOG);
                }
            }
        }
        catch (Exception exc) {
            if (exc.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exc.getCause();
            }
            if (exc instanceof RuntimeException) {
                throw (RuntimeException)exc;
            }
            throw new WrappedException(exc);
        }
    }

    public RenameLinkedMode getActiveLinkedMode() {
        return this.activeLinkedMode;
    }

    public void cancelLinkedMode() {
        if (this.activeLinkedMode != null) {
            this.activeLinkedMode.linkedModeLeft();
            this.activeLinkedMode = null;
        }
    }

    protected void startDirectRefactoring() throws InterruptedException {
        if (Strings.isEmpty((String)this.newName)) {
            this.restoreOriginalSelection();
        } else {
            this.createRenameSupport(this.renameElementContext, this.newName).startDirectRefactoring();
        }
    }

    protected void startRefactoringWithDialog(boolean previewOnly) throws InterruptedException {
        if (Strings.isEmpty((String)this.newName)) {
            this.newName = this.getOriginalName(this.getXtextEditor());
        }
        if (Strings.isEmpty((String)this.newName)) {
            this.restoreOriginalSelection();
        } else {
            this.createRenameSupport(this.renameElementContext, this.newName).startRefactoringWithDialog(previewOnly);
        }
    }

    protected String getOriginalName(XtextEditor xtextEditor) {
        return (String)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource state) throws Exception {
                IRenameStrategy strategy;
                EObject targetElement = state.getResourceSet().getEObject(RenameRefactoringController.this.renameElementContext.getTargetElementURI(), false);
                IRenameStrategy.Provider strategyProvider = (IRenameStrategy.Provider)RenameRefactoringController.this.globalServiceProvider.findService(targetElement, IRenameStrategy.Provider.class);
                if (strategyProvider != null && (strategy = strategyProvider.get(targetElement, RenameRefactoringController.this.renameElementContext)) != null) {
                    return strategy.getOriginalName();
                }
                return null;
            }
        });
    }

    protected IRenameSupport createRenameSupport(IRenameElementContext context, String name) {
        return this.renameSupportFactory.create(context, this.newName);
    }

    protected void restoreOriginalSelection() {
        ISelection originalSelection = this.renameElementContext.getTriggeringEditorSelection();
        if (originalSelection instanceof ITextSelection) {
            this.getXtextEditor().getInternalSourceViewer().setSelectedRange(((ITextSelection)originalSelection).getOffset(), ((ITextSelection)originalSelection).getLength());
        }
    }

    protected XtextEditor getXtextEditor() {
        IEditorPart part = this.renameElementContext.getTriggeringEditor();
        if (part instanceof XtextEditor) {
            return (XtextEditor)part;
        }
        return null;
    }
}

