/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.codebuilder;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.xtend.ide.codebuilder.ICodeBuilder;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractCodeBuilder
implements ICodeBuilder {
    @Accessors
    private Object ownerSource;
    @Accessors
    private JvmDeclaredType owner;
    @Accessors
    private JvmVisibility visibility;
    @Accessors
    private EObject context;
    @Inject
    @Extension
    private IJavaElementFinder _iJavaElementFinder;
    @Inject
    private CommonTypeComputationServices services;

    @Override
    public boolean isValid() {
        IJavaElement javaElement = this._iJavaElementFinder.findElementFor((JvmIdentifiableElement)this.owner);
        return (javaElement == null || !javaElement.isReadOnly()) && this.ownerSource != null && this.owner != null && this.context != null;
    }

    @Override
    public String getPreview() {
        String _xblockexpression = null;
        StringBuilderBasedAppendable appendable = new StringBuilderBasedAppendable();
        this.build((ISourceAppender)appendable.append((CharSequence)"...").newLine()).newLine().append((CharSequence)"...");
        _xblockexpression = appendable.toString();
        return _xblockexpression;
    }

    protected ISourceAppender appendVisibility(ISourceAppender appendable, JvmVisibility visibility, JvmVisibility skippableDefault) {
        String _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)visibility, (Object)skippableDefault)) {
            _matched = true;
            _switchResult = "";
        }
        if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PRIVATE)) {
            _matched = true;
            _switchResult = "private ";
        }
        if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PROTECTED)) {
            _matched = true;
            _switchResult = "protected ";
        }
        if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PUBLIC)) {
            _matched = true;
            _switchResult = "public ";
        }
        if (!_matched) {
            _switchResult = "";
        }
        return appendable.append((CharSequence)_switchResult);
    }

    protected <T extends EObject> T findByFragment(XtextResource resource, T object) {
        EObject _eObject;
        Resource myResource = object.eResource();
        boolean _equals = Objects.equal((Object)myResource, (Object)resource);
        if (_equals) {
            return object;
        }
        String fragment = myResource.getURIFragment(object);
        EObject result = _eObject = resource.getEObject(fragment);
        return (T)result;
    }

    protected ISourceAppender appendType(ISourceAppender appendable, LightweightTypeReference typeRef, String surrogate) {
        ISourceAppender _xblockexpression = null;
        if (typeRef == null) {
            appendable.append((CharSequence)surrogate);
        } else {
            appendable.append(typeRef);
        }
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    protected ISourceAppender appendTypeParameters(ISourceAppender appendable, List<JvmTypeParameter> typeParameters) {
        ISourceAppender _xblockexpression = null;
        Iterator<JvmTypeParameter> iterator = typeParameters.iterator();
        boolean _hasNext = iterator.hasNext();
        if (_hasNext) {
            appendable.append((CharSequence)"<");
            do {
                boolean _hasNext_1;
                boolean _not;
                JvmTypeParameter typeParameter = iterator.next();
                appendable.append((CharSequence)typeParameter.getName());
                Functions.Function1 _function = it -> {
                    String _identifier = it.getTypeReference().getIdentifier();
                    return !Objects.equal((Object)_identifier, (Object)"java.lang.Object");
                };
                Iterable upperBounds = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)typeParameter.getConstraints(), JvmUpperBound.class), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)upperBounds);
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    appendable.append((CharSequence)" extends ");
                    boolean isFirst = true;
                    StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, this.context);
                    for (JvmUpperBound upperBound : upperBounds) {
                        if (!isFirst) {
                            appendable.append((CharSequence)" & ");
                        }
                        isFirst = false;
                        this.appendType(appendable, owner.toLightweightTypeReference(upperBound.getTypeReference()), "Object");
                    }
                }
                if (!(_hasNext_1 = iterator.hasNext())) continue;
                appendable.append((CharSequence)",");
            } while (iterator.hasNext());
            appendable.append((CharSequence)"> ");
        }
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    protected String getIdentifierOrObject(JvmTypeReference typeReference) {
        String _switchResult = null;
        boolean _matched = false;
        if (typeReference instanceof JvmUnknownTypeReference) {
            _matched = true;
            _switchResult = "java.lang.Object";
        }
        if (!_matched) {
            _switchResult = typeReference.getIdentifier();
        }
        return _switchResult;
    }

    protected boolean isInterface(JvmType t) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (t instanceof JvmGenericType) {
            _matched = true;
            _switchResult = ((JvmGenericType)t).isInterface();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    @Override
    @Pure
    public Object getOwnerSource() {
        return this.ownerSource;
    }

    public void setOwnerSource(Object ownerSource) {
        this.ownerSource = ownerSource;
    }

    @Override
    @Pure
    public JvmDeclaredType getOwner() {
        return this.owner;
    }

    public void setOwner(JvmDeclaredType owner) {
        this.owner = owner;
    }

    @Override
    @Pure
    public JvmVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(JvmVisibility visibility) {
        this.visibility = visibility;
    }

    @Pure
    public EObject getContext() {
        return this.context;
    }

    public void setContext(EObject context) {
        this.context = context;
    }
}

