/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.smoketest.internal;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.junit4.GlobalRegistries;
import org.eclipse.xtext.junit4.IInjectorProvider;
import org.eclipse.xtext.junit4.IRegistryConfigurator;
import org.eclipse.xtext.junit4.smoketest.internal.TestDataProvider;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class WrappingInjectorProvider
implements IInjectorProvider,
IRegistryConfigurator {
    private final IInjectorProvider delegate;
    private final Injector injector;
    private GlobalRegistries.GlobalStateMemento stateBeforeInjectorCreation;
    private final GlobalRegistries.GlobalStateMemento stateAfterInjectorCreation;

    public WrappingInjectorProvider(IInjectorProvider delegate) {
        this.delegate = delegate;
        this.stateBeforeInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        this.injector = this.createInjector();
        this.registerFactory(this.injector);
        this.stateAfterInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        this.stateBeforeInjectorCreation.restoreGlobalState();
    }

    private void registerFactory(Injector injector) {
        IResourceFactory factory = (IResourceFactory)injector.getInstance(IResourceFactory.class);
        IResourceServiceProvider serviceProvider = (IResourceServiceProvider)injector.getInstance(IResourceServiceProvider.class);
        FileExtensionProvider fileExtensionProvider = (FileExtensionProvider)injector.getInstance(FileExtensionProvider.class);
        for (String ext : fileExtensionProvider.getFileExtensions()) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(ext, factory);
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().put(ext, serviceProvider);
        }
    }

    protected Injector createInjector() {
        Injector delegateInjector = this.delegate.getInjector();
        final Map bindings = delegateInjector.getBindings();
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                for (Binding binding : bindings.values()) {
                    Type typeLiteral = binding.getKey().getTypeLiteral().getType();
                    if (Injector.class.equals((Object)typeLiteral) || Logger.class.equals((Object)typeLiteral)) continue;
                    binding.applyTo(binder);
                }
            }
        }}).with(new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.bind(IParser.class).toInstance((Object)new TestDataProvider());
            }
        }})});
        return injector;
    }

    public IInjectorProvider getDelegate() {
        return this.delegate;
    }

    @Override
    public void restoreRegistry() {
        this.stateBeforeInjectorCreation.restoreGlobalState();
        this.stateBeforeInjectorCreation = null;
    }

    @Override
    public void setupRegistry() {
        this.stateBeforeInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        this.stateAfterInjectorCreation.restoreGlobalState();
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }
}

