/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.List;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.SimpleIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.computation.IApplicableCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;

public class ExpressionAwareStackedResolvedTypes
extends StackedResolvedTypes {
    private final XExpression expression;

    protected ExpressionAwareStackedResolvedTypes(ResolvedTypes parent, XExpression expression) {
        super(parent);
        this.expression = expression;
    }

    protected XExpression expression() {
        return this.expression;
    }

    @Override
    protected void prepareMergeIntoParent() {
        this.tryResolveUnboundReferences();
        this.mergeLocalTypes();
    }

    protected void mergeLocalTypes() {
        List<TypeData> result = this.basicGetExpressionTypes().get(this.expression);
        if (result != null && !result.isEmpty()) {
            TypeData returnTypeData = this.mergeTypeData(this.expression, result, true, true);
            TypeData actualTypeData = this.mergeTypeData(this.expression, result, false, true);
            result.clear();
            if (returnTypeData != null) {
                result.add(returnTypeData);
            }
            if (actualTypeData != null) {
                result.add(actualTypeData);
            }
        }
    }

    protected void tryResolveUnboundReferences() {
        for (UnboundTypeReference unbound : this.basicGetTypeParameters().values()) {
            if (unbound.getExpression() != this.expression) continue;
            unbound.tryResolve(false);
        }
    }

    @Override
    protected void performMergeIntoParent() {
        IApplicableCandidate candidate;
        if (this.canBeForwardResolved() && (candidate = this.basicGetLinkingMap().get(this.expression)) instanceof AbstractPendingLinkingCandidate) {
            AbstractPendingLinkingCandidate casted = (AbstractPendingLinkingCandidate)candidate;
            if (casted.description instanceof BucketedEObjectDescription || casted.description instanceof SimpleIdentifiableElementDescription) {
                this.forwardLinking().put((XAbstractFeatureCall)this.expression, casted);
            }
        }
        super.performMergeIntoParent();
    }

    protected boolean canBeForwardResolved() {
        IFeatureLinkingCandidate candidate;
        return this.expression instanceof XAbstractFeatureCall && this.basicGetTypeParameters().isEmpty() && this.basicGetTypeParameterHints().isEmpty() && this.basicGetDeclardTypeParameters() == null && this.basicGetReassignedTypes().isEmpty() && this.basicGetPropagatedTypes().isEmpty() && this.basicGetRefinedTypes().isEmpty() && this.basicGetTypes().isEmpty() && (candidate = this.getFeature((XAbstractFeatureCall)this.expression)) != null && candidate.getTypeArguments().isEmpty();
    }
}

