/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescriptionProvider;

public class ResolvedResourceDescription
extends AbstractResourceDescription {
    private static final Logger LOG = Logger.getLogger(ResolvedResourceDescription.class);
    private URI uri;
    private ImmutableList<IEObjectDescription> exported;

    public ResolvedResourceDescription(IResourceDescription original) {
        this.uri = original.getURI();
        this.exported = FluentIterable.from(original.getExportedObjects()).transform(from -> {
            String[] userDataKeys;
            if (from instanceof SerializableEObjectDescriptionProvider) {
                return ((SerializableEObjectDescriptionProvider)((Object)from)).toSerializableEObjectDescription();
            }
            if (from.getEObjectOrProxy().eIsProxy()) {
                return from;
            }
            InternalEObject result = (InternalEObject)EcoreUtil.create((EClass)from.getEClass());
            result.eSetProxyURI(from.getEObjectURI());
            HashMap userData = null;
            String[] stringArray = userDataKeys = from.getUserDataKeys();
            int n = userDataKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (userData == null) {
                    userData = Maps.newHashMapWithExpectedSize((int)userDataKeys.length);
                }
                userData.put(key, from.getUserData(key));
                ++n2;
            }
            return EObjectDescription.create(from.getName(), (EObject)result, userData);
        }).toList();
    }

    @Override
    protected List<IEObjectDescription> computeExportedObjects() {
        return this.exported;
    }

    @Override
    public Iterable<QualifiedName> getImportedNames() {
        IllegalStateException exception = new IllegalStateException("getImportedNames: " + this.getURI());
        LOG.error((Object)exception.getMessage(), (Throwable)exception);
        return Collections.emptyList();
    }

    @Override
    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        IllegalStateException exception = new IllegalStateException("getReferenceDescriptions: " + this.getURI());
        LOG.error((Object)exception.getMessage(), (Throwable)exception);
        return Collections.emptyList();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }
}

