/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildContext;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.BuildManagerAccess;
import org.eclipse.xtext.builder.impl.ClosedProjectsQueue;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.RegistryBuilderParticipant;
import org.eclipse.xtext.builder.impl.SetWithProjectNames;
import org.eclipse.xtext.builder.impl.SourceLevelURICache;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.osgi.framework.Version;

public class XtextBuilder
extends IncrementalProjectBuilder {
    private static final Version VERSION_3_17_0 = new Version(3, 17, 0);
    private static final Logger log = Logger.getLogger(XtextBuilder.class);
    public static final String BUILDER_ID = "org.eclipse.xtext.ui.shared.xtextBuilder";
    private static final String EXTERNAL_PROJECT_NAME = ".org.eclipse.jdt.core.external.folders";
    @Inject
    private ToBeBuiltComputer toBeBuiltComputer;
    @Inject
    private IBuilderState builderState;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProvideRegistry;
    @Inject
    private RegistryBuilderParticipant participant;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private IBuildLogger buildLogger;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private ClosedProjectsQueue closedProjectsQueue;
    private Set<IProject> interestingProjects = Collections.emptySet();
    @Inject
    private BuilderPreferences preferences;
    private static final Field callOnEmptyData;
    private boolean nextBuildIsFullBuild = false;
    private boolean allowRequestFullBuild = true;
    private final Object requestFullBuildLock = new Object();
    @Deprecated
    private static Boolean mustCallDeprecatedDoBuild;
    @Deprecated
    private static boolean wasDeprecationWarningLoggedForBuild;
    @Deprecated
    private static Boolean mustCallDeprecatedDoClean;
    @Deprecated
    private static boolean wasDeprecationWarningLoggedForClean;
    private Method requestProjectRebuildMethod;
    private Method requestProjectsRebuildMethod;
    private static Version installedCoreResourcesVersion;

    static {
        try {
            Field fld = InternalBuilder.class.getDeclaredField("callOnEmptyDelta");
            fld.setAccessible(true);
            callOnEmptyData = fld;
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        mustCallDeprecatedDoBuild = null;
        wasDeprecationWarningLoggedForBuild = false;
        mustCallDeprecatedDoClean = null;
        wasDeprecationWarningLoggedForClean = false;
    }

    @Inject
    private void injectClosedProjectsQueue(ISharedStateContributionRegistry sharedState) {
        this.closedProjectsQueue = (ClosedProjectsQueue)sharedState.getSingleContributedInstance(ClosedProjectsQueue.class);
    }

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFullBuild(boolean force) {
        Object object = this.requestFullBuildLock;
        synchronized (object) {
            if (this.allowRequestFullBuild || force) {
                this.allowRequestFullBuild = false;
                this.nextBuildIsFullBuild = true;
                try {
                    callOnEmptyData.set((Object)this, true);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                BuildManagerAccess.scheduleAutoBuild();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wasFullBuildRequested() {
        Object object = this.requestFullBuildLock;
        synchronized (object) {
            return this.nextBuildIsFullBuild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetWasFullBuildRequested(boolean wasFullBuildRequested) {
        Object object = this.requestFullBuildLock;
        synchronized (object) {
            if (this.nextBuildIsFullBuild && !wasFullBuildRequested) {
                return;
            }
            this.allowRequestFullBuild = false;
            this.nextBuildIsFullBuild = false;
            try {
                callOnEmptyData.set((Object)this, false);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void ensureBuilderStateLoaded() {
        this.builderState.isEmpty();
    }

    /*
     * Loose catch block
     */
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        block19: {
            Stopwatches.StoppedTask task;
            long startTime;
            block21: {
                this.ensureBuilderStateLoaded();
                boolean wasFullBuildRequested = this.wasFullBuildRequested();
                if (!wasFullBuildRequested && IBuildFlag.FORGET_BUILD_STATE_ONLY.isSet(args)) {
                    this.forgetLastBuiltState();
                    return this.getReferencedProjects();
                }
                final int effectiveKind = wasFullBuildRequested ? 6 : kind;
                startTime = System.currentTimeMillis();
                task = Stopwatches.forTask((String)String.format("XtextBuilder.build[%s]", this.getKindAsString(effectiveKind)));
                try {
                    this.queuedBuildData.createCheckpoint();
                    if (this.shouldCancelBuild(effectiveKind)) {
                        this.buildLogger.log("interrupted");
                        throw new OperationCanceledException("Build has been interrupted");
                    }
                    task.start();
                    if (monitor /* !! */  != null) {
                        final String taskName = String.valueOf(Messages.XtextBuilder_Building) + this.getProject().getName() + ": ";
                        monitor /* !! */  = new ProgressMonitorWrapper(monitor /* !! */ ){

                            public void subTask(String name) {
                                super.subTask(String.valueOf(taskName) + name);
                            }

                            public boolean isCanceled() {
                                boolean shouldCancelBuild = XtextBuilder.this.shouldCancelBuild(effectiveKind);
                                if (shouldCancelBuild) {
                                    XtextBuilder.this.buildLogger.log("interrupted");
                                }
                                return shouldCancelBuild || super.isCanceled();
                            }
                        };
                    }
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor /* !! */ , (int)1);
                    if (effectiveKind == 6) {
                        this.fullBuild((IProgressMonitor)progress.split(1), !wasFullBuildRequested && IBuildFlag.RECOVERY_BUILD.isSet(args));
                    } else {
                        IResourceDelta delta = this.getDelta(this.getProject());
                        if (delta == null || this.isOpened(delta)) {
                            this.fullBuild((IProgressMonitor)progress.split(1), IBuildFlag.RECOVERY_BUILD.isSet(args));
                        } else {
                            this.incrementalBuild(delta, (IProgressMonitor)progress.split(1));
                        }
                    }
                    this.unsetWasFullBuildRequested(wasFullBuildRequested);
                }
                catch (CoreException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (OperationCanceledException e) {
                    this.handleCanceled(e);
                    this.queuedBuildData.discardCheckpoint();
                    if (monitor /* !! */  != null) {
                        monitor /* !! */ .done();
                    }
                    String message = "Built " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
                    log.info((Object)message);
                    this.buildLogger.log(message);
                    task.stop();
                    break block19;
                }
                catch (OperationCanceledError err) {
                    this.handleCanceled(err);
                    break block19;
                }
                catch (Exception e) {
                    block20: {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        this.buildLogger.log(String.valueOf(e.getClass().getSimpleName()) + " while building " + this.getProject().getName() + ": " + e.getMessage() + " (see logs for details)");
                        this.forgetLastBuiltState();
                        this.queuedBuildData.discardCheckpoint();
                        if (monitor /* !! */  == null) break block20;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor /* !! */ .done();
                    }
                    String message = "Built " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
                    log.info((Object)message);
                    this.buildLogger.log(message);
                    task.stop();
                    break block19;
                }
                {
                    finally {
                        this.queuedBuildData.discardCheckpoint();
                        if (monitor /* !! */  != null) {
                            monitor /* !! */ .done();
                        }
                        String message = "Built " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
                        log.info((Object)message);
                        this.buildLogger.log(message);
                        task.stop();
                    }
                }
                this.queuedBuildData.discardCheckpoint();
                if (monitor /* !! */  == null) break block21;
                monitor /* !! */ .done();
            }
            String message = "Built " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
            log.info((Object)message);
            this.buildLogger.log(message);
            task.stop();
        }
        return this.getReferencedProjects();
    }

    protected IProject[] getReferencedProjects() throws CoreException {
        this.interestingProjects = this.toBeBuiltComputer.getInterestingProjects(this.getProject());
        return this.interestingProjects.toArray(new IProject[0]);
    }

    protected final Set<IProject> getInternalInterestingProjects() {
        return this.interestingProjects;
    }

    private boolean shouldCancelBuild(int buildKind) {
        return buildKind == 9 && this.isInterrupted();
    }

    private void handleCanceled(Throwable t) {
        if (!this.isInterrupted()) {
            this.operationCanceledManager.propagateIfCancelException(t);
        }
        this.buildLogger.log("Build interrupted.");
        this.queuedBuildData.rollback();
        this.rememberLastBuiltState();
    }

    private String getKindAsString(int kind) {
        if (kind == 6) {
            return "FULL";
        }
        if (kind == 15) {
            return "CLEAN";
        }
        if (kind == 10) {
            return "INCREMENTAL";
        }
        if (kind == 9) {
            return "AUTO";
        }
        return "UNKOWN:" + kind;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.XtextBuilder_CollectingResources, (int)10);
        progress.subTask(Messages.XtextBuilder_CollectingResources);
        this.pollQueuedBuildData();
        ToBeBuilt toBeBuilt = new ToBeBuilt();
        IResourceDeltaVisitor visitor = this.createDeltaVisitor(this.toBeBuiltComputer, toBeBuilt, progress);
        delta.accept(visitor);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.worked(2);
        ClosedProjectsQueue.Task task = this.closedProjectsQueue.exhaust();
        try {
            this.addInfosFromTaskAndBuild(task, toBeBuilt, IXtextBuilderParticipant.BuildType.INCREMENTAL, (IProgressMonitor)progress.split(8));
        }
        catch (Exception e) {
            task.reschedule();
            throw e;
        }
    }

    protected void addInfosFromTaskAndBuild(ClosedProjectsQueue.Task task, ToBeBuilt toBeBuilt, IXtextBuilderParticipant.BuildType buildType, IProgressMonitor monitor) throws CoreException {
        this.addInfosFromTask(task, toBeBuilt);
        if (XtextBuilder.class.equals(((Object)((Object)this)).getClass())) {
            this.doBuild(toBeBuilt, (Set<String>)task.getProjectNames(), monitor, buildType);
        } else {
            if (mustCallDeprecatedDoBuild == null && (mustCallDeprecatedDoBuild = Boolean.valueOf(this.isDoBuildSpecialized(((Object)((Object)this)).getClass()))).booleanValue() && !wasDeprecationWarningLoggedForBuild) {
                log.warn((Object)"XtextBuilder is specialized and overrides the deprecated method doBuild(..). The implementation should be adjusted.");
                wasDeprecationWarningLoggedForBuild = true;
            }
            if (mustCallDeprecatedDoBuild.booleanValue()) {
                this.doBuild(toBeBuilt, monitor, buildType);
            } else {
                this.doBuild(toBeBuilt, (Set<String>)task.getProjectNames(), monitor, buildType);
            }
        }
    }

    @Deprecated
    protected boolean isDoBuildSpecialized(Class<?> c) {
        return this.isMethodSpecialized(c, "doBuild", ToBeBuilt.class, IProgressMonitor.class, IXtextBuilderParticipant.BuildType.class);
    }

    protected void addInfosFromTask(ClosedProjectsQueue.Task task, ToBeBuilt toBeBuilt) {
        toBeBuilt.getToBeDeleted().addAll(task.getToBeBuilt().getToBeDeleted());
        toBeBuilt.getToBeUpdated().addAll(task.getToBeBuilt().getToBeUpdated());
    }

    @Deprecated
    protected void doBuild(ToBeBuilt toBeBuilt, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) throws CoreException {
        this.doBuild(toBeBuilt, (Set<String>)ImmutableSet.of(), monitor, type);
    }

    protected void doBuild(ToBeBuilt toBeBuilt, Set<String> removedProjects, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) throws CoreException {
        boolean indexingOnly;
        this.buildLogger.log("Building " + this.getProject().getName());
        boolean bl = indexingOnly = type == IXtextBuilderParticipant.BuildType.RECOVERY;
        if (new BuildData(this.getProject().getName(), null, toBeBuilt, this.queuedBuildData, indexingOnly, this::triggerRequestProjectRebuild, removedProjects).isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ResourceSet resourceSet = this.getResourceSetProvider().get(this.getProject());
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        BuildData buildData = new BuildData(this.getProject().getName(), resourceSet, toBeBuilt, this.queuedBuildData, indexingOnly, this::triggerRequestProjectRebuild, removedProjects);
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.update(buildData, (IProgressMonitor)progress.split(1));
        if (this.participant != null && !indexingOnly) {
            SourceLevelURICache sourceLevelURIs = buildData.getSourceLevelURICache();
            Set<URI> sources = sourceLevelURIs.getSources();
            this.participant.build(new BuildContext(this, resourceSet, (List<IResourceDescription.Delta>)deltas, sources, type), (IProgressMonitor)progress.split(1));
            try {
                this.getProject().getWorkspace().checkpoint(false);
            }
            catch (NoClassDefFoundError e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            progress.worked(1);
        }
        resourceSet.eSetDeliver(false);
        for (Resource resource : resourceSet.getResources()) {
            resource.eSetDeliver(false);
        }
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    protected void fullBuild(IProgressMonitor monitor, boolean isRecoveryBuild) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        this.pollQueuedBuildData();
        IProject project = this.getProject();
        ToBeBuilt toBeBuilt = isRecoveryBuild ? this.toBeBuiltComputer.updateProjectNewResourcesOnly(project, (IProgressMonitor)progress.split(2)) : this.toBeBuiltComputer.updateProject(project, (IProgressMonitor)progress.split(2));
        ClosedProjectsQueue.Task task = this.closedProjectsQueue.exhaust();
        try {
            this.addInfosFromTaskAndBuild(task, toBeBuilt, isRecoveryBuild ? IXtextBuilderParticipant.BuildType.RECOVERY : IXtextBuilderParticipant.BuildType.FULL, (IProgressMonitor)progress.split(8));
        }
        catch (Exception e) {
            task.reschedule();
            throw e;
        }
    }

    protected IResourceDeltaVisitor createDeltaVisitor(final ToBeBuiltComputer toBeBuiltComputer, final ToBeBuilt toBeBuilt, final SubMonitor progress) {
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (delta.getResource() instanceof IProject) {
                    return true;
                }
                if (delta.getResource() instanceof IStorage) {
                    if (delta.getKind() == 2) {
                        return toBeBuiltComputer.removeStorage(null, toBeBuilt, (IStorage)delta.getResource());
                    }
                    if (delta.getKind() == 1 || delta.getKind() == 4) {
                        return toBeBuiltComputer.updateStorage(null, toBeBuilt, (IStorage)delta.getResource());
                    }
                }
                return true;
            }
        };
        return visitor;
    }

    protected boolean isOpened(IResourceDelta delta) {
        return delta.getResource() instanceof IProject && (delta.getFlags() & 0x4000) != 0 && ((IProject)delta.getResource()).isOpen();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            ToBeBuilt toBeBuilt = this.toBeBuiltComputer.removeProject(this.getProject(), (IProgressMonitor)progress.split(2));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ClosedProjectsQueue.Task task = this.closedProjectsQueue.exhaust();
            try {
                this.addInfosFromTaskAndClean(toBeBuilt, task, (IProgressMonitor)progress.split(8));
            }
            catch (Exception e) {
                task.reschedule();
                throw e;
            }
            this.unsetWasFullBuildRequested(true);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void addInfosFromTaskAndClean(ToBeBuilt toBeBuilt, ClosedProjectsQueue.Task task, IProgressMonitor monitor) throws CoreException {
        this.addInfosFromTask(task, toBeBuilt);
        if (XtextBuilder.class.equals(((Object)((Object)this)).getClass())) {
            this.doClean(toBeBuilt, (Set<String>)task.getProjectNames(), monitor);
        } else {
            if (mustCallDeprecatedDoClean == null && (mustCallDeprecatedDoClean = Boolean.valueOf(this.isDoCleanSpecialized(((Object)((Object)this)).getClass()))).booleanValue() && !wasDeprecationWarningLoggedForClean) {
                log.warn((Object)"XtextBuilder is specialized and overrides the deprecated method doClean(..). The implementation should be adjusted.");
                wasDeprecationWarningLoggedForClean = true;
            }
            if (mustCallDeprecatedDoClean.booleanValue()) {
                this.doClean(toBeBuilt, monitor);
            } else {
                this.doClean(toBeBuilt, (Set<String>)task.getProjectNames(), monitor);
            }
        }
    }

    protected void pollQueuedBuildData() {
        if (this.pollQueuedBuildData(this.getProject())) {
            this.triggerRequestProjectRebuild();
        }
        for (IProject project : this.interestingProjects) {
            if (XtextProjectHelper.hasNature((IProject)project) || !this.pollQueuedBuildData(project)) continue;
            this.triggerRequestProjectsRebuild(project);
        }
    }

    protected boolean pollQueuedBuildData(IProject project) {
        return this.queuedBuildData.needRebuild(project);
    }

    @Deprecated
    protected boolean isDoCleanSpecialized(Class<?> c) {
        return this.isMethodSpecialized(c, "doClean", ToBeBuilt.class, IProgressMonitor.class);
    }

    private boolean isMethodSpecialized(Class<?> subclassOfBuilder, String name, Class<?> ... parameterTypes) {
        try {
            subclassOfBuilder.getDeclaredMethod(name, parameterTypes);
            return !XtextBuilder.class.equals(subclassOfBuilder);
        }
        catch (Exception e) {
            Class<?> superclass = subclassOfBuilder.getSuperclass();
            if (superclass == null) {
                return false;
            }
            return this.isDoCleanSpecialized(superclass);
        }
    }

    @Deprecated
    protected void doClean(ToBeBuilt toBeBuilt, IProgressMonitor monitor) throws CoreException {
        this.doClean(toBeBuilt, (Set<String>)ImmutableSet.of(), monitor);
    }

    protected void doClean(ToBeBuilt toBeBuilt, Set<String> removedProjects, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SetWithProjectNames toBeDeletedAndProjects = new SetWithProjectNames(toBeBuilt.getToBeDeleted(), this.getProject().getName(), removedProjects);
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.clean((Set<URI>)((Object)toBeDeletedAndProjects), (IProgressMonitor)progress.split(1));
        if (this.participant != null) {
            Set<URI> sourceURIs = new SourceLevelURICache().getSourcesFrom(toBeBuilt.getToBeDeleted(), this.resourceServiceProvideRegistry);
            this.participant.build(new BuildContext(this, this.getResourceSetProvider().get(this.getProject()), (List<IResourceDescription.Delta>)deltas, sourceURIs, IXtextBuilderParticipant.BuildType.CLEAN), (IProgressMonitor)progress.split(1));
        } else {
            progress.worked(1);
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        switch (this.preferences.schedulingOption) {
            case NULL: {
                return null;
            }
            case WORKSPACE: {
                return this.getProject().getWorkspace().getRoot();
            }
            case PROJECT: {
                return this.getProject();
            }
            case ALL_XTEXT_PROJECTS: {
                return new MultiRule((ISchedulingRule[])Arrays.stream(this.getProject().getWorkspace().getRoot().getProjects()).filter(XtextProjectHelper::hasNature).toArray(ISchedulingRule[]::new));
            }
            case ALL_XTEXT_PROJECTS_AND_JDTEXTFOLDER: {
                return new MultiRule((ISchedulingRule[])Arrays.stream(this.getProject().getWorkspace().getRoot().getProjects()).filter(p -> XtextProjectHelper.hasNature((IProject)p) || EXTERNAL_PROJECT_NAME.equals(p.getName())).toArray(ISchedulingRule[]::new));
            }
        }
        throw new IllegalArgumentException();
    }

    public void triggerRequestProjectRebuild() {
        if (this.requestProjectRebuildMethod != null || XtextBuilder.isCoreResourceGreaterOrEqual(VERSION_3_17_0)) {
            try {
                if (this.requestProjectRebuildMethod == null) {
                    this.requestProjectRebuildMethod = ((Object)((Object)this)).getClass().getMethod("requestProjectRebuild", Boolean.TYPE);
                }
                this.requestProjectRebuildMethod.invoke((Object)this, true);
            }
            catch (Exception e) {
                log.error((Object)"something went wrong in triggerRequestProjectRebuild", (Throwable)e);
                this.needRebuild();
            }
        } else {
            this.needRebuild();
        }
    }

    public void triggerRequestProjectsRebuild(IProject project) {
        if (this.requestProjectsRebuildMethod != null || XtextBuilder.isCoreResourceGreaterOrEqual(VERSION_3_17_0)) {
            try {
                if (this.requestProjectsRebuildMethod == null) {
                    this.requestProjectsRebuildMethod = ((Object)((Object)this)).getClass().getMethod("requestProjectsRebuild", Collection.class);
                }
                this.requestProjectsRebuildMethod.invoke((Object)this, Collections.singletonList(project));
            }
            catch (Exception e) {
                log.error((Object)"something went wrong in triggerRequestProjectRebuild", (Throwable)e);
                this.needRebuild();
            }
        } else {
            this.needRebuild();
        }
    }

    private static boolean isCoreResourceGreaterOrEqual(Version version) {
        if (installedCoreResourcesVersion == null) {
            installedCoreResourcesVersion = ResourcesPlugin.getPlugin().getBundle().getVersion();
        }
        return installedCoreResourcesVersion.compareTo(version) >= 0;
    }

    protected ToBeBuiltComputer getToBeBuiltComputer() {
        return this.toBeBuiltComputer;
    }

    @Singleton
    @Beta
    public static class BuilderPreferences {
        public static final String PREF_SCHEDULING_RULE = "schedulingrule";
        private SchedulingOption schedulingOption;

        public BuilderPreferences() {
            ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.xtext.builder");
            String schedulingRuleName = preferenceStore.getString(PREF_SCHEDULING_RULE);
            this.schedulingOption = schedulingRuleName.isEmpty() ? SchedulingOption.WORKSPACE : SchedulingOption.valueOf(schedulingRuleName);
            preferenceStore.addPropertyChangeListener(e -> {
                if (PREF_SCHEDULING_RULE.equals(e.getProperty())) {
                    this.schedulingOption = SchedulingOption.valueOf(e.getNewValue().toString());
                }
            });
        }
    }

    public static enum SchedulingOption {
        WORKSPACE,
        ALL_XTEXT_PROJECTS,
        ALL_XTEXT_PROJECTS_AND_JDTEXTFOLDER,
        PROJECT,
        NULL;

    }
}

