/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.ExternalFoldersManager;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtext.builder.impl.IToBeBuiltComputerContribution;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.javasupport.SimpleProjectDependencyGraph;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.ui.notification.NameBasedEObjectDescription;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.util.Strings;

public class JdtToBeBuiltComputer
implements IToBeBuiltComputerContribution {
    private static final Logger log = Logger.getLogger(JdtToBeBuiltComputer.class);
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private IWorkspace workspace;
    @Inject
    private ModificationStampCache modificationStampCache;
    @Inject
    private IJdtHelper jdtHelper;
    @Inject
    private UriValidator uriValidator;
    @Inject
    private IStorage2UriMapperJdtExtensions jdtUriMapperExtension;
    @Inject
    private SimpleProjectDependencyGraph projectDependencyGraph;

    @Override
    public void removeProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) {
        if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
            return;
        }
        this.modificationStampCache.projectToModificationStamp.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.isAccessible()) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            progress.setWorkRemaining(roots.length);
            HashMap updated = Maps.newHashMap();
            IWorkspace.ProjectOrder orderedProjects = this.workspace.computeProjectOrder(this.workspace.getRoot().getProjects());
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.shouldHandle(root) && !this.isBuiltByUpstream(root, project, orderedProjects.projects)) {
                    Map rootData = this.jdtUriMapperExtension.getAllEntries(root);
                    for (Map.Entry e : rootData.entrySet()) {
                        if (!this.uriValidator.canBuild((URI)e.getKey(), (IStorage)e.getValue())) continue;
                        toBeBuilt.getToBeDeleted().add((URI)e.getKey());
                        toBeBuilt.getToBeUpdated().add((URI)e.getKey());
                    }
                }
                progress.worked(1);
                ++n2;
            }
            ModificationStampCache modificationStampCache = this.modificationStampCache;
            synchronized (modificationStampCache) {
                this.modificationStampCache.projectToModificationStamp.putAll(updated);
            }
        }
    }

    protected boolean isBuiltByUpstream(IPackageFragmentRoot root, IProject project, IProject[] projectsInCorrectBuildOrder) {
        IProject[] iProjectArray = projectsInCorrectBuildOrder;
        int n = projectsInCorrectBuildOrder.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject;
            IProject p = iProjectArray[n2];
            if (p.equals((Object)project)) {
                return false;
            }
            if (XtextProjectHelper.hasNature((IProject)p) && XtextProjectHelper.hasBuilder((IProject)p) && (javaProject = JavaCore.create((IProject)p)).exists() && javaProject.isOnClasspath((IJavaElement)root)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Build of project '" + project.getName() + "' skips indexing classpath entry '" + root.getPath() + "' because it already indexed by " + javaProject.getElementName()));
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean shouldHandle(IPackageFragmentRoot root) {
        return this.jdtUriMapperExtension.shouldHandle(root);
    }

    @Override
    public boolean removeStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        if (storage instanceof IFile && JavaCore.isJavaLikeFileName((String)storage.getName())) {
            IJavaElement element = JavaCore.create((IResource)((IFile)storage).getParent());
            String fileName = storage.getName();
            String typeName = fileName.substring(0, fileName.lastIndexOf(46));
            if (element instanceof IPackageFragmentRoot) {
                this.queueJavaChange(typeName);
                return true;
            }
            if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                this.queueJavaChange(String.valueOf(packageFragment.getElementName()) + "." + typeName);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        return false;
    }

    protected void queueJavaChange(String typeName) {
        URI typeURI = URIHelperConstants.OBJECTS_URI.appendSegment(typeName);
        QualifiedName qualifiedName = QualifiedName.create((List)Strings.split((String)typeName, (char)'.'));
        NameBasedEObjectDescription nameBasedEObjectDescription = new NameBasedEObjectDescription(qualifiedName);
        TypeResourceDescription oldDescription = new TypeResourceDescription(typeURI, Collections.singletonList(nameBasedEObjectDescription));
        ChangedResourceDescriptionDelta delta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, null);
        this.queuedBuildData.queueChange((IResourceDescription.Delta)delta);
    }

    @Override
    public boolean isPossiblyHandled(IStorage resource) {
        return resource instanceof IJarEntryResource;
    }

    @Override
    public boolean isRejected(IFolder folder) {
        boolean result = this.jdtHelper.isFromOutputPath((IResource)folder);
        return result;
    }

    @Override
    public void addInterestingProjects(IProject thisProject, Set<IProject> result) {
        IJavaProject javaProject = JavaCore.create((IProject)thisProject);
        if (javaProject instanceof JavaProject) {
            Set<IProject> requiredProjects = this.getRequiredProjects((JavaProject)javaProject, thisProject.getWorkspace().getRoot());
            this.projectDependencyGraph.putDependency(thisProject, requiredProjects);
            result.addAll(requiredProjects);
        }
    }

    protected SimpleProjectDependencyGraph getProjectDependencyGraph() {
        return this.projectDependencyGraph;
    }

    protected Set<IProject> getRequiredProjects(JavaProject javaProject, IWorkspaceRoot workspaceRoot) {
        LinkedHashSet<IProject> result = new LinkedHashSet<IProject>();
        ExternalFoldersManager externalFoldersManager = JavaModelManager.getExternalManager();
        try {
            IClasspathEntry[] entries = javaProject.getExpandedClasspath();
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!((ClasspathEntry)entry).isOptional() || JavaProject.hasJavaNature((IProject)p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        if (path.segmentCount() <= 0) break;
                        IResource resource = workspaceRoot.findMember(path.segment(0));
                        if (resource instanceof IProject) {
                            p = (IProject)resource;
                            break;
                        }
                        resource = externalFoldersManager.getFolder(path);
                        if (resource == null) break;
                        p = resource.getProject();
                    }
                }
                if (p != null) {
                    result.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            return result;
        }
        return result;
    }

    @Singleton
    public static class ModificationStampCache {
        protected Map<String, Long> projectToModificationStamp = Maps.newHashMap();
    }
}

