/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.Token;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;

@ImplementedBy(value=IDValueConverter.class)
public abstract class AbstractIDValueConverter
extends AbstractLexerBasedConverter<String> {
    @Inject
    private IGrammarAccess grammarAccess;
    private Set<String> valuesToEscape;

    protected AbstractIDValueConverter() {
    }

    protected abstract Set<String> computeValuesToEscape(Grammar var1);

    protected Set<String> getValuesToEscape() {
        if (this.valuesToEscape == null) {
            this.valuesToEscape = this.computeValuesToEscape(this.grammarAccess.getGrammar());
        }
        return this.valuesToEscape;
    }

    protected abstract boolean mustEscape(String var1);

    @Override
    protected String toEscapedString(String value) {
        if (this.mustEscape(value)) {
            return "^" + value;
        }
        return value;
    }

    @Override
    protected void assertValidValue(String value) {
        super.assertValidValue(value);
        if (value.length() == 0) {
            throw new ValueConverterException(String.valueOf(this.getRuleName()) + " may not be empty.", null, null);
        }
    }

    @Override
    protected ValueConverterException createTokenContentMismatchException(String value, String escapedString, Token token) {
        Set<Character> invalidChars = this.collectInvalidCharacters(value);
        if (invalidChars != null) {
            return new ValueConverterException(this.getInvalidCharactersMessage(value, invalidChars), null, null);
        }
        return super.createTokenContentMismatchException(value, escapedString, token);
    }

    protected String getInvalidCharactersMessage(String value, Set<Character> invalidChars) {
        String chars = Joiner.on((String)", ").join(Iterables.transform(invalidChars, (Function)new Function<Character, String>(){

            public String apply(Character from) {
                return "'" + from + "' (0x" + Integer.toHexString(from.charValue()) + ")";
            }
        }));
        return "ID '" + value + "' contains invalid characters: " + chars;
    }

    protected Set<Character> collectInvalidCharacters(String value) {
        HashSet result = null;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || i != 0 && c >= '0' && c <= '9' || c == '_')) {
                if (result == null) {
                    result = Sets.newHashSet();
                }
                result.add(Character.valueOf(c));
            }
            ++i;
        }
        return result;
    }

    @Override
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        return string.startsWith("^") ? string.substring(1) : string;
    }

    protected IGrammarAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    public void setGrammarAccess(IGrammarAccess grammarAccess) {
        this.grammarAccess = grammarAccess;
    }
}

