/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.LineAndColumn;
import org.eclipse.xtext.validation.AbstractValidationDiagnostic;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.RangeBasedDiagnostic;

public class DiagnosticConverterImpl
implements IDiagnosticConverter {
    @Override
    public void convertResourceDiagnostic(Resource.Diagnostic diagnostic, Severity severity, IAcceptor<Issue> acceptor) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setSyntaxError(diagnostic instanceof XtextSyntaxDiagnostic);
        issue.setSeverity(severity);
        issue.setLineNumber(diagnostic.getLine());
        issue.setColumn(diagnostic.getColumn());
        issue.setMessage(diagnostic.getMessage());
        if (diagnostic instanceof org.eclipse.xtext.diagnostics.Diagnostic) {
            org.eclipse.xtext.diagnostics.Diagnostic xtextDiagnostic = (org.eclipse.xtext.diagnostics.Diagnostic)diagnostic;
            issue.setOffset(xtextDiagnostic.getOffset());
            issue.setLength(xtextDiagnostic.getLength());
        }
        if (diagnostic instanceof AbstractDiagnostic) {
            AbstractDiagnostic castedDiagnostic = (AbstractDiagnostic)diagnostic;
            issue.setUriToProblem(castedDiagnostic.getUriToProblem());
            issue.setCode(castedDiagnostic.getCode());
            issue.setData(castedDiagnostic.getData());
            issue.setLineNumberEnd(castedDiagnostic.getLineEnd());
            issue.setColumnEnd(castedDiagnostic.getColumnEnd());
        }
        issue.setType(CheckType.FAST);
        acceptor.accept((Object)issue);
    }

    @Override
    public void convertValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
        EObject causer;
        Severity severity = this.getSeverity(diagnostic);
        if (severity == null) {
            return;
        }
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setSeverity(severity);
        IssueLocation locationData = this.getLocationData(diagnostic);
        if (locationData != null) {
            issue.setLineNumber(locationData.lineNumber);
            issue.setColumn(locationData.column);
            issue.setOffset(locationData.offset);
            issue.setLength(locationData.length);
            issue.setLineNumberEnd(locationData.lineNumberEnd);
            issue.setColumnEnd(locationData.columnEnd);
        }
        if ((causer = this.getCauser(diagnostic)) != null) {
            issue.setUriToProblem(EcoreUtil.getURI((EObject)causer));
        }
        issue.setCode(this.getIssueCode(diagnostic));
        issue.setType(this.getIssueType(diagnostic));
        issue.setData(this.getIssueData(diagnostic));
        issue.setMessage(diagnostic.getMessage());
        acceptor.accept((Object)issue);
    }

    protected CheckType getIssueType(Diagnostic diagnostic) {
        if (diagnostic instanceof AbstractValidationDiagnostic) {
            AbstractValidationDiagnostic diagnosticImpl = (AbstractValidationDiagnostic)diagnostic;
            return diagnosticImpl.getCheckType();
        }
        return CheckType.FAST;
    }

    protected String[] getIssueData(Diagnostic diagnostic) {
        if (diagnostic instanceof AbstractValidationDiagnostic) {
            AbstractValidationDiagnostic diagnosticImpl = (AbstractValidationDiagnostic)diagnostic;
            return diagnosticImpl.getIssueData();
        }
        EObject causer = this.getCauser(diagnostic);
        ArrayList issueData = Lists.newArrayList();
        for (Object object : diagnostic.getData()) {
            if (object != causer && object instanceof EObject) {
                EObject eObject = (EObject)object;
                issueData.add(EcoreUtil.getURI((EObject)eObject).toString());
                continue;
            }
            if (!(object instanceof String)) continue;
            issueData.add((String)object);
        }
        return issueData.toArray(new String[issueData.size()]);
    }

    protected String getIssueCode(Diagnostic diagnostic) {
        if (diagnostic instanceof AbstractValidationDiagnostic) {
            AbstractValidationDiagnostic diagnosticImpl = (AbstractValidationDiagnostic)diagnostic;
            return diagnosticImpl.getIssueCode();
        }
        return String.valueOf(diagnostic.getSource()) + "." + diagnostic.getCode();
    }

    protected Severity getSeverity(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 0) {
            return null;
        }
        switch (diagnostic.getSeverity()) {
            case 2: {
                return Severity.WARNING;
            }
            case 1: {
                return Severity.INFO;
            }
        }
        return Severity.ERROR;
    }

    protected EObject getCauser(Diagnostic diagnostic) {
        if (diagnostic.getData().isEmpty()) {
            return null;
        }
        Object causer = diagnostic.getData().get(0);
        return causer instanceof EObject ? (EObject)causer : null;
    }

    protected IssueLocation getLocationData(Diagnostic diagnostic) {
        EObject causer = this.getCauser(diagnostic);
        if (causer != null) {
            if (diagnostic instanceof RangeBasedDiagnostic) {
                RangeBasedDiagnostic castedDiagnostic = (RangeBasedDiagnostic)diagnostic;
                ICompositeNode parserNode = NodeModelUtils.getNode(causer);
                IssueLocation result = this.getLocationForNode(parserNode, castedDiagnostic.getOffset(), castedDiagnostic.getLength());
                return result;
            }
            if (diagnostic instanceof FeatureBasedDiagnostic) {
                FeatureBasedDiagnostic castedDiagnostic = (FeatureBasedDiagnostic)diagnostic;
                return this.getLocationData(causer, castedDiagnostic.getFeature(), castedDiagnostic.getIndex());
            }
            List data = diagnostic.getData();
            Object feature = data.size() > 1 ? data.get(1) : null;
            EStructuralFeature structuralFeature = this.resolveStructuralFeature(causer, feature);
            return this.getLocationData(causer, structuralFeature, 0);
        }
        return null;
    }

    protected IssueLocation getLocationData(EObject obj, EStructuralFeature structuralFeature) {
        return this.getLocationData(obj, structuralFeature, 0);
    }

    protected IssueLocation getLocationData(EObject obj, EStructuralFeature structuralFeature, int index) {
        INode parserNode = NodeModelUtils.getNode(obj);
        if (parserNode != null) {
            if (structuralFeature != null) {
                List<INode> nodes = NodeModelUtils.findNodesForFeature(obj, structuralFeature);
                if (index < 0) {
                    index = 0;
                }
                if (nodes.size() > index) {
                    parserNode = nodes.get(index);
                }
            }
            return this.getLocationForNode(parserNode);
        }
        if (obj.eContainer() != null) {
            EStructuralFeature containingFeature;
            EObject container = obj.eContainer();
            return this.getLocationData(container, containingFeature, (containingFeature = obj.eContainingFeature()).isMany() ? ((EList)container.eGet(containingFeature)).indexOf((Object)obj) : -1);
        }
        IssueLocation startOfDocumentLocation = new IssueLocation();
        startOfDocumentLocation.offset = 0;
        startOfDocumentLocation.length = 0;
        startOfDocumentLocation.lineNumber = 1;
        startOfDocumentLocation.column = 1;
        startOfDocumentLocation.lineNumberEnd = 1;
        startOfDocumentLocation.columnEnd = 1;
        return new IssueLocation();
    }

    protected IssueLocation getLocationForNode(INode node) {
        ITextRegionWithLineInformation nodeRegion = node.getTextRegionWithLineInformation();
        int offset = nodeRegion.getOffset();
        int length = nodeRegion.getLength();
        return this.getLocationForNode(node, offset, length);
    }

    protected IssueLocation getLocationForNode(INode node, int offset, int length) {
        IssueLocation result = new IssueLocation();
        result.offset = offset;
        result.length = length;
        LineAndColumn lineAndColumnStart = NodeModelUtils.getLineAndColumn(node, offset);
        result.lineNumber = lineAndColumnStart.getLine();
        result.column = lineAndColumnStart.getColumn();
        LineAndColumn lineAndColumnEnd = NodeModelUtils.getLineAndColumn(node, offset + length);
        result.lineNumberEnd = lineAndColumnEnd.getLine();
        result.columnEnd = lineAndColumnEnd.getColumn();
        return result;
    }

    protected EStructuralFeature resolveStructuralFeature(EObject ele, Object feature) {
        if (feature instanceof EStructuralFeature) {
            return (EStructuralFeature)feature;
        }
        return null;
    }

    protected static class IssueLocation {
        public Integer lineNumber = 0;
        public Integer column = 0;
        public Integer lineNumberEnd = 0;
        public Integer columnEnd = 0;
        public Integer offset = 0;
        public Integer length = 0;
    }
}

