/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.imports;

import java.util.List;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.util.ReplaceRegion;

public class ReplaceConverter {
    public TextEdit convertToTextEdit(List<ReplaceRegion> changes) {
        if (changes != null && !changes.isEmpty()) {
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            for (ReplaceRegion change : changes) {
                multiTextEdit.addChild((TextEdit)new ReplaceEdit(change.getOffset(), change.getLength(), change.getText()));
            }
            return multiTextEdit;
        }
        return null;
    }

    public int getReplaceLengthDelta(List<ReplaceRegion> changes) {
        return this.getReplaceLengthDelta(changes, 0);
    }

    public int getReplaceLengthDelta(List<ReplaceRegion> changes, int caretPosition) {
        int delta = 0;
        if (changes != null && !changes.isEmpty()) {
            for (ReplaceRegion change : changes) {
                if (change.getEndOffset() >= caretPosition) continue;
                delta += change.getText().length() - change.getLength();
            }
        }
        return delta;
    }
}

