/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.Strings;

public class EObjectDescriptionBasedStubGenerator
implements IStubGenerator {
    public String getJavaStubSource(IEObjectDescription description, IResourceDescription resourceDescription) {
        if (this.isNestedType(description) || !this.isJvmDeclaredType(description)) {
            return null;
        }
        LinkedHashMultimap owner2nested = LinkedHashMultimap.create();
        for (IEObjectDescription other : resourceDescription.getExportedObjects()) {
            if (!this.isJvmDeclaredType(other) || !this.isNestedType(other)) continue;
            owner2nested.put((Object)this.getOwnerClassName(other.getQualifiedName()), (Object)other);
        }
        StringBuilder classSignatureBuilder = new StringBuilder();
        QualifiedName qualifiedName = description.getQualifiedName();
        if (qualifiedName.getSegments().size() > 1) {
            String string = qualifiedName.toString();
            classSignatureBuilder.append("package " + string.substring(0, string.lastIndexOf(46)) + ";");
        }
        this.appendType(description, (Multimap<QualifiedName, IEObjectDescription>)owner2nested, classSignatureBuilder);
        return classSignatureBuilder.toString();
    }

    protected void appendType(IEObjectDescription description, Multimap<QualifiedName, IEObjectDescription> owner2nested, StringBuilder classSignatureBuilder) {
        classSignatureBuilder.append("\npublic ");
        if (this.isNestedType(description)) {
            classSignatureBuilder.append("static ");
        }
        if (description.getEClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            if (description.getUserData("interface") != null) {
                classSignatureBuilder.append("interface ");
            } else {
                classSignatureBuilder.append("class ");
            }
        } else if (description.getEClass() == TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            classSignatureBuilder.append("enum ");
        } else if (description.getEClass() == TypesPackage.Literals.JVM_ANNOTATION_TYPE) {
            classSignatureBuilder.append("@interface ");
        }
        String lastSegment = description.getQualifiedName().getLastSegment();
        int trimIndex = lastSegment.lastIndexOf(36);
        String simpleName = lastSegment.substring(trimIndex + 1);
        classSignatureBuilder.append(simpleName);
        String typeParameters = description.getUserData("typeParameters");
        if (typeParameters != null) {
            classSignatureBuilder.append(typeParameters);
        }
        classSignatureBuilder.append("{");
        for (IEObjectDescription nested : owner2nested.get((Object)description.getQualifiedName())) {
            this.appendType(nested, owner2nested, classSignatureBuilder);
        }
        classSignatureBuilder.append("\n}");
    }

    protected QualifiedName getOwnerClassName(QualifiedName nestedClassName) {
        String lastSegment = nestedClassName.getLastSegment();
        int trimIndex = lastSegment.lastIndexOf(36);
        if (trimIndex == -1) {
            return nestedClassName.skipLast(1);
        }
        return nestedClassName.skipLast(1).append(lastSegment.substring(0, trimIndex));
    }

    public String getJavaFileName(IEObjectDescription description) {
        if (!this.isJvmDeclaredType(description)) {
            return null;
        }
        QualifiedName typeName = description.getName();
        return String.valueOf(Strings.concat((String)"/", (List)typeName.getSegments())) + ".java";
    }

    protected boolean isNestedType(IEObjectDescription description) {
        return description.getUserData("nestedType") != null;
    }

    protected boolean isJvmDeclaredType(IEObjectDescription description) {
        EClass eClass = description.getEClass();
        return eClass == TypesPackage.Literals.JVM_GENERIC_TYPE || eClass == TypesPackage.Literals.JVM_ENUMERATION_TYPE || eClass == TypesPackage.Literals.JVM_ANNOTATION_TYPE;
    }

    @Override
    public void doGenerateStubs(IFileSystemAccess access, IResourceDescription description) {
        for (IEObjectDescription objectDesc : description.getExportedObjects()) {
            String javaStubSource = this.getJavaStubSource(objectDesc, description);
            if (javaStubSource == null) continue;
            String javaFileName = this.getJavaFileName(objectDesc);
            access.generateFile(javaFileName, (CharSequence)javaStubSource);
        }
    }
}

