/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclarator;
import org.eclipse.xtend.lib.macro.declaration.ResolvedConstructor;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public class FinalFieldsConstructorProcessor
implements TransformationParticipant<MutableTypeParameterDeclarator> {
    public void doTransform(List<? extends MutableTypeParameterDeclarator> elements, @Extension TransformationContext context) {
        Consumer<MutableTypeParameterDeclarator> _function = it -> this.transform((MutableTypeParameterDeclarator)it, context);
        elements.forEach(_function);
    }

    protected void _transform(MutableClassDeclaration it, @Extension TransformationContext context) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        AnnotationReference _findAnnotation_1 = it.findAnnotation(context.findTypeGlobally(Accessors.class));
        boolean bl2 = _tripleNotEquals_1 = _findAnnotation_1 != null;
        if (_tripleNotEquals_1) {
            return;
        }
        Util util = new Util(context);
        util.addFinalFieldsConstructor(it);
    }

    protected void _transform(MutableConstructorDeclaration it, @Extension TransformationContext context) {
        Util util = new Util(context);
        util.makeFinalFieldsConstructor(it);
    }

    public void transform(MutableTypeParameterDeclarator it, TransformationContext context) {
        if (it instanceof MutableConstructorDeclaration) {
            this._transform((MutableConstructorDeclaration)it, context);
            return;
        }
        if (it instanceof MutableClassDeclaration) {
            this._transform((MutableClassDeclaration)it, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;
        private static final Pattern EMPTY_BODY = Pattern.compile("(\\{(\\s*\\})?)?");

        public Util(TransformationContext context) {
            this.context = context;
        }

        public Iterable<? extends MutableFieldDeclaration> getFinalFields(MutableTypeDeclaration it) {
            Functions.Function1 _function = it_1 -> !it_1.isStatic() && it_1.isFinal() && it_1.getInitializer() == null && this.context.isThePrimaryGeneratedJavaElement((Element)it_1);
            return IterableExtensions.filter((Iterable)it.getDeclaredFields(), (Functions.Function1)_function);
        }

        public boolean needsFinalFieldConstructor(MutableClassDeclaration it) {
            return !this.hasFinalFieldsConstructor((MutableTypeDeclaration)it) && IterableExtensions.isEmpty((Iterable)((ClassDeclaration)this.context.getPrimarySourceElement((Element)it)).getDeclaredConstructors());
        }

        public boolean hasFinalFieldsConstructor(MutableTypeDeclaration cls) {
            boolean _xblockexpression = false;
            ArrayList<TypeReference> expectedTypes = this.getFinalFieldsConstructorArgumentTypes(cls);
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> it_1.getType();
                List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)it.getParameters(), (Functions.Function1)_function_1));
                return Objects.equals(_list, expectedTypes);
            };
            _xblockexpression = IterableExtensions.exists((Iterable)cls.getDeclaredConstructors(), (Functions.Function1)_function);
            return _xblockexpression;
        }

        public ArrayList<TypeReference> getFinalFieldsConstructorArgumentTypes(MutableTypeDeclaration cls) {
            boolean _tripleNotEquals;
            ArrayList _xblockexpression = null;
            ArrayList types = CollectionLiterals.newArrayList();
            ResolvedConstructor _superConstructor = this.getSuperConstructor((TypeDeclaration)cls);
            boolean bl = _tripleNotEquals = _superConstructor != null;
            if (_tripleNotEquals) {
                Functions.Function1 _function = it -> it.getResolvedType();
                Iterable _map = IterableExtensions.map((Iterable)this.getSuperConstructor((TypeDeclaration)cls).getResolvedParameters(), (Functions.Function1)_function);
                Iterables.addAll((Collection)types, (Iterable)_map);
            }
            Functions.Function1 _function_1 = it -> it.getType();
            Iterable _map_1 = IterableExtensions.map(this.getFinalFields(cls), (Functions.Function1)_function_1);
            Iterables.addAll((Collection)types, (Iterable)_map_1);
            _xblockexpression = types;
            return _xblockexpression;
        }

        public String getConstructorAlreadyExistsMessage(MutableTypeDeclaration it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Cannot create FinalFieldsConstructor as a constructor with the signature \"new(");
            String _join = IterableExtensions.join(this.getFinalFieldsConstructorArgumentTypes(it), (CharSequence)",");
            _builder.append(_join);
            _builder.append(")\" already exists.");
            return _builder.toString();
        }

        public void addFinalFieldsConstructor(MutableClassDeclaration it) {
            boolean _isEmpty = this.getFinalFieldsConstructorArgumentTypes((MutableTypeDeclaration)it).isEmpty();
            if (_isEmpty) {
                AnnotationReference anno = it.findAnnotation(this.context.findTypeGlobally(FinalFieldsConstructor.class));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("There are no final fields, this annotation has no effect");
                this.context.addWarning((Element)anno, _builder.toString());
                return;
            }
            boolean _hasFinalFieldsConstructor = this.hasFinalFieldsConstructor((MutableTypeDeclaration)it);
            if (_hasFinalFieldsConstructor) {
                this.context.addError((Element)it, this.getConstructorAlreadyExistsMessage((MutableTypeDeclaration)it));
                return;
            }
            Procedures.Procedure1 _function = it_1 -> {
                this.context.setPrimarySourceElement((MutableElement)it_1, this.context.getPrimarySourceElement((Element)it_1.getDeclaringType()));
                this.makeFinalFieldsConstructor((MutableConstructorDeclaration)it_1);
            };
            it.addConstructor(_function);
        }

        public void makeFinalFieldsConstructor(final MutableConstructorDeclaration it) {
            boolean _not;
            boolean _isEmpty = this.getFinalFieldsConstructorArgumentTypes(it.getDeclaringType()).isEmpty();
            if (_isEmpty) {
                AnnotationReference anno = it.findAnnotation(this.context.findTypeGlobally(FinalFieldsConstructor.class));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("There are no final fields, this annotation has no effect");
                this.context.addWarning((Element)anno, _builder.toString());
                return;
            }
            boolean _hasFinalFieldsConstructor = this.hasFinalFieldsConstructor(it.getDeclaringType());
            if (_hasFinalFieldsConstructor) {
                this.context.addError((Element)it, this.getConstructorAlreadyExistsMessage(it.getDeclaringType()));
                return;
            }
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)it.getParameters());
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                this.context.addError((Element)it, "Parameter list must be empty");
            }
            if (it.getBody() != null && !EMPTY_BODY.matcher(it.getBody().toString()).matches()) {
                this.context.addError((Element)it, "Body must be empty");
            }
            List<ResolvedParameter> _elvis = null;
            ResolvedConstructor _superConstructor = this.getSuperConstructor((TypeDeclaration)it.getDeclaringType());
            List<ResolvedParameter> _resolvedParameters = null;
            if (_superConstructor != null) {
                _resolvedParameters = _superConstructor.getResolvedParameters();
            }
            _elvis = _resolvedParameters != null ? _resolvedParameters : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            final List<ResolvedParameter> superParameters = _elvis;
            Consumer<ResolvedParameter> _function = p -> it.addParameter(p.getDeclaration().getSimpleName(), p.getResolvedType());
            superParameters.forEach(_function);
            final HashMap fieldToParameter = CollectionLiterals.newHashMap();
            Consumer<MutableFieldDeclaration> _function_1 = p -> {
                p.markAsInitializedBy((ConstructorDeclaration)it);
                MutableParameterDeclaration param = it.addParameter(p.getSimpleName(), this.orObject(p.getType()));
                fieldToParameter.put(p, param);
            };
            this.getFinalFields(it.getDeclaringType()).forEach(_function_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"super(");
                    Functions.Function1 _function = it_1 -> it_1.getDeclaration().getSimpleName();
                    String _join = IterableExtensions.join((Iterable)superParameters, (CharSequence)", ", (Functions.Function1)_function);
                    _builder.append((Object)_join);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    Iterable<? extends MutableFieldDeclaration> _finalFields = this.getFinalFields(it.getDeclaringType());
                    for (MutableFieldDeclaration mutableFieldDeclaration : _finalFields) {
                        _builder.append((Object)"this.");
                        String _simpleName = mutableFieldDeclaration.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" = ");
                        String _simpleName_1 = ((MutableParameterDeclaration)fieldToParameter.get(mutableFieldDeclaration)).getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                }
            };
            it.setBody(_client);
        }

        public ResolvedConstructor getSuperConstructor(TypeDeclaration it) {
            if (it instanceof ClassDeclaration) {
                if (Objects.equals(((ClassDeclaration)it).getExtendedClass(), this.context.getObject()) || ((ClassDeclaration)it).getExtendedClass() == null) {
                    return null;
                }
                return (ResolvedConstructor)IterableExtensions.head((Iterable)((ClassDeclaration)it).getExtendedClass().getDeclaredResolvedConstructors());
            }
            return null;
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _xifexpression = null;
            _xifexpression = ref == null ? this.context.getObject() : ref;
            return _xifexpression;
        }
    }
}

