/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.search;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.search.IXtextSearchFilter;

@ImplementedBy(value=Default.class)
public interface IXtextEObjectSearch {
    public Iterable<IEObjectDescription> findMatches(String var1, String var2);

    public static class Default
    implements IXtextEObjectSearch {
        @Inject
        private IResourceDescriptions resourceDescriptions;

        @Override
        public Iterable<IEObjectDescription> findMatches(String searchPattern, String typeSearchPattern) {
            return Iterables.filter(this.getSearchScope(), this.getSearchPredicate(searchPattern, typeSearchPattern));
        }

        protected Predicate<IEObjectDescription> getSearchPredicate(String stringPattern, String typeStringPattern) {
            final Collection<String> namespaceDelimiters = IXtextSearchFilter.Registry.allNamespaceDelimiters();
            final SearchPattern searchPattern = new SearchPattern();
            searchPattern.setPattern(stringPattern);
            final SearchPattern typeSearchPattern = new SearchPattern();
            typeSearchPattern.setPattern(typeStringPattern);
            final Collection<IXtextSearchFilter> registeredFilters = IXtextSearchFilter.Registry.allFilters();
            return new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription input) {
                    if (this.isNameMatches(searchPattern, input, namespaceDelimiters) && typeSearchPattern.matches(input.getEClass().getName())) {
                        for (IXtextSearchFilter xtextSearchFilter : registeredFilters) {
                            if (!xtextSearchFilter.reject(input)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }

        protected boolean isNameMatches(SearchPattern searchPattern, IEObjectDescription eObjectDescription, Collection<String> namespaceDelimiters) {
            String qualifiedName = eObjectDescription.getQualifiedName().toString();
            if (qualifiedName != null) {
                if (searchPattern.matches(qualifiedName)) {
                    return true;
                }
                for (String namespaceDelimiter : namespaceDelimiters) {
                    int index = qualifiedName.lastIndexOf(namespaceDelimiter);
                    if (index == -1 || !searchPattern.matches(qualifiedName.substring(index + 1))) continue;
                    return true;
                }
            }
            return false;
        }

        protected Iterable<IEObjectDescription> getSearchScope() {
            return Iterables.concat((Iterable)Iterables.transform((Iterable)this.getResourceDescriptions().getAllResourceDescriptions(), (Function)new Function<IResourceDescription, Iterable<IEObjectDescription>>(){

                public Iterable<IEObjectDescription> apply(IResourceDescription from) {
                    return from.getExportedObjects();
                }
            }));
        }

        public void setResourceDescriptions(IResourceDescriptions resourceDescriptions) {
            this.resourceDescriptions = resourceDescriptions;
        }

        public IResourceDescriptions getResourceDescriptions() {
            return this.resourceDescriptions;
        }
    }
}

