/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;

public class XtendExpressionUtil
extends ExpressionUtil {
    @Inject
    private XtendGrammarAccess grammarAccess;

    protected INode nextNodeForFindSelectedExpression(EObject element, INode node, ITextSelection selection) {
        if (element.eContainer() instanceof RichString && node.getEndOffset() - selection.getOffset() > 0 && !this.isRichTextEnd(element, node)) {
            Object nextNode = NodeModelUtils.findLeafNodeAtOffset((INode)node.getRootNode(), (int)node.getEndOffset());
            while (nextNode != null && nextNode.isHidden()) {
                INode nextSibling = nextNode.getNextSibling();
                nextNode = nextSibling instanceof ILeafNode ? (ILeafNode)nextSibling : null;
            }
            if (this.isRichStringPart((ILeafNode)nextNode)) {
                return nextNode;
            }
        }
        return super.nextNodeForFindSelectedExpression(element, node, selection);
    }

    protected boolean isRichStringPart(ILeafNode nextNode) {
        if (nextNode == null) {
            return false;
        }
        if (this.grammarAccess.getRichStringForLoopAccess().getENDFORKeyword_9() == nextNode.getGrammarElement()) {
            return false;
        }
        return this.grammarAccess.getRichStringIfAccess().getENDIFKeyword_6() != nextNode.getGrammarElement();
    }

    protected boolean isRichTextEnd(EObject element, INode node) {
        if (!(element instanceof RichStringLiteral)) {
            return false;
        }
        for (ILeafNode leafNode : node.getLeafNodes()) {
            EObject grammarElement = leafNode.getGrammarElement();
            if (!(grammarElement instanceof RuleCall)) continue;
            RuleCall ruleCall = (RuleCall)grammarElement;
            if (this.grammarAccess.getRICH_TEXT_ENDRule() != ruleCall.getRule()) continue;
            return true;
        }
        return false;
    }

    protected ITextRegion getTotalTextRegion(EObject element, INode node) {
        if (element.eContainer() instanceof RichString) {
            return this.getRichStringPartTextRegion(element);
        }
        return super.getTotalTextRegion(element, node);
    }

    public ITextRegion getTextRegion(EObject element) {
        if (element.eContainer() instanceof RichString) {
            return this.getRichStringPartTextRegion(element);
        }
        return super.getTextRegion(element);
    }

    protected ITextRegion getRichStringPartTextRegion(EObject element) {
        if (element instanceof RichStringLiteral) {
            return this.locationInFileProvider.getSignificantTextRegion(element);
        }
        ICompositeNode elementNode = NodeModelUtils.getNode((EObject)element);
        ITextRegion totalTextRegion = elementNode.getTotalTextRegion();
        int offset = totalTextRegion.getOffset() - 1;
        int length = totalTextRegion.getLength() + 2;
        Object nextNode = NodeModelUtils.findLeafNodeAtOffset((INode)elementNode.getRootNode(), (int)elementNode.getEndOffset());
        while (nextNode != null && nextNode.isHidden()) {
            length += nextNode.getLength();
            INode nextSibling = nextNode.getNextSibling();
            nextNode = nextSibling instanceof ILeafNode ? (ILeafNode)nextSibling : null;
        }
        return new TextRegion(offset, length);
    }
}

