/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.impl;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;

public class PartialParsingPointers {
    private ICompositeNode rootNode;
    private int length;
    private int offset;
    private final List<ICompositeNode> validReplaceRootNodes;
    private final List<ICompositeNode> nodesEnclosingRegion;

    public PartialParsingPointers(ICompositeNode rootNode, int offset, int length, List<ICompositeNode> validReplaceRootNodes, List<ICompositeNode> nodesEnclosingRegion) {
        if (validReplaceRootNodes == null || validReplaceRootNodes.isEmpty()) {
            throw new IllegalArgumentException("validReplaceRootNodes cannot be empty");
        }
        this.rootNode = rootNode;
        this.offset = offset;
        this.length = length;
        this.validReplaceRootNodes = validReplaceRootNodes;
        this.nodesEnclosingRegion = nodesEnclosingRegion;
    }

    public EObject findEntryRuleOrRuleCall(ICompositeNode replaceRootNode) {
        EObject grammarElement = replaceRootNode.getGrammarElement();
        if (grammarElement instanceof CrossReference) {
            grammarElement = ((CrossReference)grammarElement).getTerminal();
        }
        if (GrammarUtil.isParserRuleCall(grammarElement)) {
            return grammarElement;
        }
        if (grammarElement instanceof ParserRule) {
            return grammarElement;
        }
        if (grammarElement instanceof Action) {
            for (INode next : replaceRootNode.getChildren()) {
                if (!(next instanceof ICompositeNode)) continue;
                return this.findEntryRuleOrRuleCall((ICompositeNode)next);
            }
            throw new IllegalArgumentException("Invalid parsetree: Action node does not have a Composite child");
        }
        throw new IllegalArgumentException("Entry rule can only be resolved for parser rules, rule calls, cross-references or actions, but tried to resolve for: " + replaceRootNode.getGrammarElement().eClass().getName());
    }

    public List<ICompositeNode> getValidReplaceRootNodes() {
        return this.validReplaceRootNodes;
    }

    public List<ICompositeNode> getNodesEnclosingRegion() {
        return this.nodesEnclosingRegion;
    }

    public ICompositeNode getDefaultReplaceRootNode() {
        return this.validReplaceRootNodes.get(this.validReplaceRootNodes.size() - 1);
    }

    public ICompositeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ICompositeNode rootNode) {
        this.rootNode = rootNode;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

