/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.ui.refactoring.JdtRefactoringContextFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.CombinedJvmJdtRenameContext;

public class CombinedJvmJdtRenameContextFactory
extends JdtRefactoringContextFactory {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private OverrideHelper overrideHelper;

    public IRenameElementContext createLocalRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
        EObject sourceParameter;
        EObject declarationTarget = this.getDeclarationTarget(targetElement);
        Set<EObject> jvmElements = this.filterJvmElements(this.associations.getJvmElements(declarationTarget));
        if (!jvmElements.isEmpty()) {
            LinkedHashMap jvm2javaElement = Maps.newLinkedHashMap();
            for (JvmIdentifiableElement jvmElement : Iterables.filter(jvmElements, JvmIdentifiableElement.class)) {
                JvmIdentifiableElement jvmElementToBeRenamed = jvmElement instanceof JvmConstructor ? ((JvmConstructor)jvmElement).getDeclaringType() : jvmElement;
                IJavaElement javaElement = this.getJavaElementFinder().findExactElementFor(jvmElementToBeRenamed);
                if (javaElement == null) continue;
                if (javaElement instanceof IMethod) {
                    this.addDeclaringMethod(jvmElementToBeRenamed, javaElement, jvm2javaElement);
                    continue;
                }
                jvm2javaElement.put(EcoreUtil.getURI((EObject)jvmElementToBeRenamed), javaElement);
            }
            if (!jvm2javaElement.isEmpty()) {
                return new CombinedJvmJdtRenameContext(declarationTarget, jvm2javaElement, editor, selection, resource);
            }
        }
        if ((targetElement instanceof JvmFormalParameter || targetElement instanceof JvmTypeParameter) && (sourceParameter = this.associations.getPrimarySourceElement(targetElement)) != null) {
            return super.createLocalRenameElementContext(sourceParameter, editor, selection, resource);
        }
        return super.createLocalRenameElementContext(targetElement, editor, selection, resource);
    }

    protected EObject getDeclarationTarget(EObject targetElement) {
        Object target = targetElement instanceof JvmConstructor ? ((JvmConstructor)targetElement).getDeclaringType() : targetElement;
        EObject declarationTarget = this.associations.getPrimarySourceElement(target);
        return declarationTarget != null ? declarationTarget : target;
    }

    protected void addDeclaringMethod(JvmIdentifiableElement jvmElement, IJavaElement javaElement, Map<URI, IJavaElement> jvm2javaElement) {
        try {
            IType declaringType = ((IMethod)javaElement).getDeclaringType();
            ITypeHierarchy typeHierarchy = declaringType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            MethodOverrideTester methodOverrideTester = new MethodOverrideTester(declaringType, typeHierarchy);
            IMethod declaringMethod = methodOverrideTester.findDeclaringMethod((IMethod)javaElement, true);
            if (declaringMethod != null) {
                jvm2javaElement.put(EcoreUtil.getURI((EObject)jvmElement), (IJavaElement)declaringMethod);
            } else {
                jvm2javaElement.put(EcoreUtil.getURI((EObject)jvmElement), javaElement);
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<EObject> filterJvmElements(Set<EObject> unfiltered) {
        LinkedHashSet filtered = Sets.newLinkedHashSet();
        for (EObject element : unfiltered) {
            if (!this.isAcceptedElement(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    protected boolean isAcceptedElement(EObject jvmElement) {
        JvmOperation op;
        return !(jvmElement instanceof JvmOperation) || this.associations.isPrimaryJvmElement((EObject)(op = (JvmOperation)jvmElement)) || this.overrideHelper.findOverriddenOperation(op) == null;
    }
}

