/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.util.SimpleCache;

public class SimpleAttributeResolver<K extends EObject, T>
implements Function<K, T> {
    public static final SimpleAttributeResolver<EObject, String> NAME_RESOLVER = SimpleAttributeResolver.newResolver(String.class, "name");
    private final SimpleCache<EClass, EAttribute> attributeCache;
    private final SimpleCache<EObject, T> valueCache;
    private final String attributeName;
    private final Adapter discardingAdapter;

    public static <K extends EObject, T> SimpleAttributeResolver<K, T> newResolver(Class<T> type, String attributeName) {
        return new SimpleAttributeResolver<K, T>(type, attributeName);
    }

    public EAttribute getAttribute(EObject object) {
        return this.attributeCache.get(object.eClass());
    }

    protected SimpleAttributeResolver(final Class<T> type, final String attributeName) {
        this.attributeName = attributeName;
        this.discardingAdapter = new DiscardingAdapter(this);
        this.attributeCache = new SimpleCache<EClass, EAttribute>(new Function<EClass, EAttribute>(){

            public EAttribute apply(EClass param) {
                EStructuralFeature structuralFeature = param.getEStructuralFeature(attributeName);
                if (structuralFeature != null && structuralFeature instanceof EAttribute && !structuralFeature.isMany() && type.isAssignableFrom(structuralFeature.getEType().getInstanceClass())) {
                    return (EAttribute)structuralFeature;
                }
                return null;
            }
        });
        this.valueCache = new SimpleCache(new Function<EObject, T>(){

            public T apply(EObject param) {
                EStructuralFeature feature = (EStructuralFeature)SimpleAttributeResolver.this.attributeCache.get(param.eClass());
                if (feature != null) {
                    param.eAdapters().add((Object)SimpleAttributeResolver.this.discardingAdapter);
                }
                return feature != null ? param.eGet(feature) : null;
            }
        });
    }

    public T getValue(K object) {
        return object != null ? (T)this.valueCache.get((EObject)object) : null;
    }

    public Iterable<K> getMatches(Iterable<K> candidates, final T value) {
        return Iterables.filter(candidates, (Predicate)new Predicate<K>(){

            public boolean apply(K param) {
                Object candidateValue = SimpleAttributeResolver.this.getValue(param);
                return value.equals(candidateValue);
            }
        });
    }

    public T apply(K from) {
        return this.getValue(from);
    }

    private static class DiscardingAdapter
    implements Adapter {
        private SimpleAttributeResolver<?, ?> resolver;

        private DiscardingAdapter(SimpleAttributeResolver<?, ?> resolver) {
            this.resolver = resolver;
        }

        public Notifier getTarget() {
            return null;
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof DiscardingAdapter;
        }

        public void notifyChanged(Notification notification) {
            Object feature;
            if (!notification.isTouch() && 1 == notification.getEventType() && (feature = notification.getFeature()) != null && this.resolver.attributeName.equals(((ENamedElement)feature).getName())) {
                this.resolver.valueCache.discard((EObject)notification.getNotifier());
                ((EObject)notification.getNotifier()).eAdapters().remove((Object)this);
            }
        }

        public void setTarget(Notifier newTarget) {
        }
    }
}

