/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.util.ProjectFactory;

@Deprecated
public class FeatureProjectFactory
extends ProjectFactory {
    private static String MANIFEST_FILENAME = "feature.xml";
    private static String CATEGORY_FILE_NAME = "category.xml";
    private static String BUILD_PROPS_FILE_NAME = "build.properties";
    private static String SOURCE_FEAT_ENDING = ".source";
    private static String FEAT_ENDING = ".feature";
    private List<String> containedBundles = new ArrayList<String>();
    private List<String> includedFeatures = new ArrayList<String>();
    private String mainCategoryName;
    private String featureLabel;

    public void setFeatureLabel(String label) {
        this.featureLabel = label;
    }

    public FeatureProjectFactory addBundle(String bundleId) {
        this.containedBundles.add(bundleId);
        return this;
    }

    public FeatureProjectFactory addFeature(String featureId) {
        this.includedFeatures.add(featureId);
        return this;
    }

    public FeatureProjectFactory withCategoryFile(String mainCategoryName) {
        this.mainCategoryName = mainCategoryName;
        return this;
    }

    @Override
    protected void enhanceProject(IProject project, SubMonitor subMonitor, Shell shell) throws CoreException {
        super.enhanceProject(project, subMonitor, shell);
        this.createManifest(project, (IProgressMonitor)subMonitor.newChild(1));
        this.createBuildProperties(project, (IProgressMonitor)subMonitor.newChild(1));
        if (!Strings.isNullOrEmpty((String)this.mainCategoryName)) {
            this.createCategoryFile(project, this.mainCategoryName, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) {
        StringConcatenation content = new StringConcatenation();
        content.append("bin.includes =");
        content.append(MANIFEST_FILENAME);
        content.newLineIfNotEmpty();
        this.writeToFile((CharSequence)content, BUILD_PROPS_FILE_NAME, project, monitor);
    }

    private void createManifest(IProject project, IProgressMonitor monitor) {
        StringConcatenation content = new StringConcatenation();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        content.newLine();
        content.append("<feature id=\"");
        content.append(this.projectName);
        content.append("\"");
        content.newLineIfNotEmpty();
        content.append("\t");
        content.append("label=\"");
        Object label = null;
        label = !Strings.isNullOrEmpty((String)this.featureLabel) ? this.featureLabel : this.projectName + " Feature";
        content.append((String)label, "\t");
        content.append("\"");
        content.newLineIfNotEmpty();
        content.append("\t");
        content.append("version=\"1.0.0.qualifier\">");
        content.newLine();
        for (String includedFeature : this.includedFeatures) {
            content.append("\t");
            content.append("<includes");
            content.newLine();
            content.append("\t");
            content.append("\t");
            content.append("id=\"");
            content.append(includedFeature, "\t\t");
            content.append("\"");
            content.newLineIfNotEmpty();
            content.append("\t");
            content.append("\t");
            content.append("version=\"0.0.0\"/>");
            content.newLine();
        }
        for (String containedBundle : this.containedBundles) {
            content.append("\t");
            content.append("<plugin");
            content.newLine();
            content.append("\t");
            content.append("\t\t");
            content.append("id=\"");
            content.append(containedBundle, "\t\t\t");
            content.append("\"");
            content.newLineIfNotEmpty();
            content.append("\t");
            content.append("\t\t");
            content.append("download-size=\"0\"");
            content.newLine();
            content.append("\t");
            content.append("\t\t");
            content.append("install-size=\"0\"");
            content.newLine();
            content.append("\t");
            content.append("\t\t");
            content.append("version=\"0.0.0\"");
            content.newLine();
            content.append("\t");
            content.append("\t\t");
            content.append("unpack=\"false\"/>");
            content.newLine();
        }
        content.append("</feature>");
        content.newLine();
        this.writeToFile((CharSequence)content, MANIFEST_FILENAME, project, monitor);
    }

    private void createCategoryFile(IProject project, String categoryName, IProgressMonitor monitor) {
        StringConcatenation content = new StringConcatenation();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        content.newLine();
        content.append("<site>");
        content.newLine();
        for (String includedFeature : this.includedFeatures) {
            content.append("\t");
            content.append("<feature id=\"");
            content.append(includedFeature, "\t");
            content.append("\" version=\"0.0.0\">");
            content.newLineIfNotEmpty();
            content.append("\t");
            content.append("\t");
            content.append("<category name=\"main\"/>");
            content.newLine();
            content.append("\t");
            content.append("</feature>");
            content.newLine();
            content.append("\t");
            content.append("<feature id=\"");
            String sourceFeatureName = null;
            if (includedFeature != null) {
                sourceFeatureName = this.sourceFeatureName(includedFeature);
            }
            content.append(sourceFeatureName, "\t");
            content.append("\" version=\"0.0.0\">");
            content.newLineIfNotEmpty();
            content.append("\t");
            content.append("\t");
            content.append("<category name=\"main.source\"/>");
            content.newLine();
            content.append("\t");
            content.append("</feature>");
            content.newLine();
        }
        content.append("   ");
        content.append("<category-def name=\"main\" label=\"");
        content.append(categoryName, "   ");
        content.append("\"/>");
        content.newLineIfNotEmpty();
        content.append("   ");
        content.append("<category-def name=\"main.source\" label=\"Source for ");
        content.append(categoryName, "   ");
        content.append("\"/>");
        content.newLineIfNotEmpty();
        content.append("</site>");
        content.newLine();
        this.writeToFile((CharSequence)content, CATEGORY_FILE_NAME, project, monitor);
    }

    private String sourceFeatureName(String featureId) {
        if (featureId.endsWith(FEAT_ENDING)) {
            return featureId.replaceAll("\\" + FEAT_ENDING + "$", SOURCE_FEAT_ENDING + FEAT_ENDING);
        }
        return featureId + SOURCE_FEAT_ENDING;
    }
}

