/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class OnChangeEvictingCache
implements IResourceScopeCache {
    private static final Logger log = Logger.getLogger(OnChangeEvictingCache.class);

    @Override
    public void clear(Resource resource) {
        this.getOrCreate(resource).clearValues();
    }

    @Override
    public <T> T get(Object key, Resource resource, Provider<T> provider) {
        if (resource == null) {
            return (T)provider.get();
        }
        CacheAdapter adapter = this.getOrCreate(resource);
        Object element = adapter.internalGet(key);
        if (element == null) {
            element = provider.get();
            this.cacheMiss(adapter);
            adapter.set(key, element);
        } else {
            this.cacheHit(adapter);
        }
        if (element == CacheAdapter.NULL) {
            return null;
        }
        return (T)element;
    }

    protected void cacheMiss(CacheAdapter adapter) {
        adapter.cacheMiss();
    }

    protected void cacheHit(CacheAdapter adapter) {
        adapter.cacheHit();
    }

    public CacheAdapter getOrCreate(Resource resource) {
        CacheAdapter adapter = (CacheAdapter)EcoreUtil.getAdapter((List)resource.eAdapters(), CacheAdapter.class);
        if (adapter == null) {
            adapter = new CacheAdapter();
            resource.eAdapters().add((Object)adapter);
            adapter.setResource(resource);
        }
        return adapter;
    }

    public <Result, Param extends Resource> Result execWithoutCacheClear(Param resource, IUnitOfWork<Result, Param> transaction) throws WrappedException {
        CacheAdapter cacheAdapter = this.getOrCreate(resource);
        try {
            cacheAdapter.ignoreNotifications();
            Result Result = transaction.exec(resource);
            return Result;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            cacheAdapter.listenToNotifications();
        }
    }

    public <Result, Param extends Resource> Result execWithTemporaryCaching(Param resource, IUnitOfWork<Result, Param> transaction) throws WrappedException {
        CacheAdapter cacheAdapter = this.getOrCreate(resource);
        IgnoreValuesMemento memento = cacheAdapter.ignoreNewValues();
        try {
            Result Result = transaction.exec(resource);
            return Result;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            memento.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheAdapter
    extends EContentAdapter {
        private static final Object NULL = new Object();
        private final Map<Object, Object> values = new ConcurrentHashMap<Object, Object>(500);
        private final Collection<Listener> listeners = Sets.newLinkedHashSet();
        @Deprecated
        private volatile boolean ignoreNotifications = false;
        private final AtomicInteger ignoreNotificationCounter = new AtomicInteger(0);
        private volatile boolean empty = true;
        private volatile IgnoreValuesMemento ignoreValuesMemento = null;
        private Resource resource;
        private int misses = 0;
        private int hits = 0;

        public void set(Object name, Object value) {
            this.empty = false;
            if (value != null) {
                this.values.put(name, value);
            } else {
                this.values.put(name, NULL);
            }
            IgnoreValuesMemento ignoreValuesMemento = this.ignoreValuesMemento;
            if (ignoreValuesMemento != null) {
                ignoreValuesMemento.storeKey(name);
            }
        }

        public void listenToNotifications() {
            if (this.ignoreNotificationCounter.decrementAndGet() < 0) {
                throw new IllegalStateException("ignoreNotificationCounter may not be less than zero");
            }
        }

        public void ignoreNotifications() {
            this.ignoreNotificationCounter.incrementAndGet();
        }

        protected void cacheMiss() {
            ++this.misses;
        }

        protected void cacheHit() {
            ++this.hits;
        }

        private <T> T internalGet(Object name) {
            if (this.empty) {
                return null;
            }
            return (T)this.values.get(name);
        }

        public <T> T get(Object name) {
            T result = this.internalGet(name);
            if (result != NULL) {
                return result;
            }
            return null;
        }

        public void addCacheListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void removeCacheListener(Listener listener) {
            this.listeners.remove(listener);
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (this.ignoreNotificationCounter.get() == 0 && !this.ignoreNotifications && this.isSemanticStateChange(notification)) {
                this.clearValues();
                Iterator<Listener> iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    Listener next = iter.next();
                    iter.remove();
                    next.onEvict(this);
                }
            }
        }

        public void clearValues() {
            if (!this.empty) {
                if (log.isDebugEnabled()) {
                    String lastSegment = this.resource != null && this.resource.getURI() != null ? this.resource.getURI().lastSegment() : "null";
                    log.debug((Object)String.format("Clear %d cache entries for resource %s after %d hits and %d misses (quota: %d%%)", this.values.size(), lastSegment, this.hits, this.misses, this.hits + this.misses != 0 ? this.hits * 100 / (this.hits + this.misses) : 0));
                }
                this.values.clear();
                this.empty = true;
                this.misses = 0;
                this.hits = 0;
            }
        }

        private boolean isSemanticStateChange(Notification notification) {
            return !notification.isTouch() && !(notification.getNewValue() instanceof Resource.Diagnostic) && !(notification.getOldValue() instanceof Resource.Diagnostic);
        }

        public boolean isAdapterForType(Object type) {
            return type == ((Object)((Object)this)).getClass();
        }

        @Deprecated
        public void setIgnoreNotifications(boolean ignoreNotifications) {
            this.ignoreNotifications = ignoreNotifications;
        }

        public boolean isIgnoreNotifications() {
            return this.ignoreNotificationCounter.get() > 0 || this.ignoreNotifications;
        }

        private IgnoreValuesMemento ignoreNewValues() {
            return new IgnoreValuesMemento(this.ignoreValuesMemento, this);
        }

        protected boolean resolve() {
            return false;
        }

        protected Resource getResource() {
            return this.resource;
        }

        protected void setResource(Resource resource) {
            this.resource = resource;
        }
    }

    private static class IgnoreValuesMemento {
        private final List<Object> keys = Lists.newArrayList();
        private final IgnoreValuesMemento previous;
        private final CacheAdapter adapter;

        private IgnoreValuesMemento(IgnoreValuesMemento previous, CacheAdapter adapter) {
            this.previous = previous;
            this.adapter = adapter;
            this.adapter.ignoreValuesMemento = this;
        }

        private void done() {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Discarding %d temporary cache entries", this.keys.size()));
            }
            this.adapter.values.keySet().removeAll(this.keys);
            this.adapter.ignoreValuesMemento = this.previous;
        }

        private void storeKey(Object name) {
            this.keys.add(name);
        }
    }

    public static interface Listener {
        public void onEvict(CacheAdapter var1);
    }
}

