/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdaListFormatter<STATE, STACKITEM>
implements Function<Pda<STATE, STACKITEM>, String> {
    protected Function<? super STACKITEM, String> stackitemFormatter = new ObjToStrFunction<STACKITEM>();
    protected Function<? super STATE, String> stateFormatter = new ObjToStrFunction<STATE>();
    protected boolean sortFollowers = false;

    public PdaListFormatter<STATE, STACKITEM> sortFollowers() {
        this.sortFollowers = true;
        return this;
    }

    public String apply(Pda<STATE, STACKITEM> pda) {
        return this.format(pda);
    }

    public String format(Pda<STATE, STACKITEM> pda) {
        Object start = pda.getStart();
        ArrayList result = Lists.newArrayList();
        for (Object s : new NfaUtil().collect(pda)) {
            String str;
            if (s == start || (str = this.format(pda, s)) == null) continue;
            result.add(str);
        }
        Collections.sort(result);
        String startstring = this.format(pda, start);
        if (startstring != null) {
            result.add(0, startstring);
        }
        return Joiner.on((char)'\n').join((Iterable)result);
    }

    protected String title(Pda<STATE, STACKITEM> pda, STATE state) {
        STACKITEM push = pda.getPush(state);
        STACKITEM pop = pda.getPop(state);
        StringBuilder result = new StringBuilder();
        if (push != null) {
            result.append(">>");
            result.append((String)this.stackitemFormatter.apply(push));
        }
        if (pop != null) {
            result.append("<<");
            result.append((String)this.stackitemFormatter.apply(pop));
        }
        if (result.length() == 0) {
            result.append((String)this.stateFormatter.apply(state));
        }
        return result.toString();
    }

    public String format(Pda<STATE, STACKITEM> pda, STATE state) {
        Iterable<STATE> followers2 = pda.getFollowers(state);
        if (!followers2.iterator().hasNext()) {
            return null;
        }
        ArrayList followers = Lists.newArrayList();
        for (STATE f : followers2) {
            followers.add(this.title(pda, f));
        }
        if (this.sortFollowers) {
            Collections.sort(followers);
        }
        return String.valueOf(this.title(pda, state)) + " -> " + Joiner.on((String)", ").join((Iterable)followers);
    }

    public Function<? super STACKITEM, String> getStackitemFormatter() {
        return this.stackitemFormatter;
    }

    public Function<? super STATE, String> getStateFormatter() {
        return this.stateFormatter;
    }

    public PdaListFormatter<STATE, STACKITEM> setStackitemFormatter(Function<? super STACKITEM, String> stackitemFormatter) {
        this.stackitemFormatter = stackitemFormatter;
        return this;
    }

    public PdaListFormatter<STATE, STACKITEM> setStateFormatter(Function<? super STATE, String> stateFormatter) {
        this.stateFormatter = stateFormatter;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObjToStrFunction<OBJ>
    implements Function<OBJ, String> {
        protected ObjToStrFunction() {
        }

        public String apply(OBJ from) {
            return from == null ? "null" : from.toString();
        }
    }
}

