/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.builder.trace.LocationInResource;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractTrace
implements ITrace,
ITrace.Internal {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceRegistry;
    @Inject
    private IStorage2UriMapper storage2uriMapper;
    @Inject
    private IWorkspace workspace;
    @Inject
    private ITraceURIConverter traceURIConverter;
    private AbstractTraceRegion rootTraceRegion;
    private ITraceRegionProvider traceRegionProvider;

    protected IStorage2UriMapper getStorage2uriMapper() {
        return this.storage2uriMapper;
    }

    @Nullable
    public final AbstractTraceRegion getRootTraceRegion() {
        if (this.rootTraceRegion == null) {
            this.rootTraceRegion = this.doGetRootTraceRegion();
        }
        return this.rootTraceRegion;
    }

    @Nullable
    protected AbstractTraceRegion doGetRootTraceRegion() {
        try {
            return this.traceRegionProvider.getTraceRegion();
        }
        catch (TraceNotFoundException noTraceFound) {
            return null;
        }
    }

    protected void setTraceRegionProvider(ITraceRegionProvider traceRegionProvider) {
        this.traceRegionProvider = traceRegionProvider;
    }

    protected ITraceRegionProvider getTraceRegionProvider() {
        return this.traceRegionProvider;
    }

    @Nullable
    public ILocationInResource getBestAssociatedLocation(ITextRegion region) {
        AbstractTraceRegion right = this.findTraceRegionAtRightOffset(region.getOffset() + region.getLength());
        if (right != null && this.encloses(right, region.getOffset(), true) && right.getMyOffset() + right.getMyLength() == region.getOffset() + region.getLength()) {
            return this.getMergedLocationInResource(right);
        }
        AbstractTraceRegion left = this.findTraceRegionAtLeftOffset(region.getOffset());
        return this.mergeRegions(left, right);
    }

    @Nullable
    protected ILocationInResource mergeRegions(@Nullable AbstractTraceRegion left, @Nullable AbstractTraceRegion right) {
        if (left == null) {
            if (right != null) {
                return this.getMergedLocationInResource(right);
            }
            return null;
        }
        if (right == null || left.equals((Object)right)) {
            return this.getMergedLocationInResource(left);
        }
        URI leftToPath = left.getAssociatedPath();
        URI rightToPath = right.getAssociatedPath();
        if (leftToPath != null && leftToPath.equals(rightToPath) || leftToPath == rightToPath) {
            ITextRegionWithLineInformation rightRegion;
            ITextRegionWithLineInformation leftRegion = left.getMyRegion();
            if (leftRegion.contains((ITextRegion)(rightRegion = right.getMyRegion()))) {
                return this.getMergedLocationInResource(left);
            }
            if (rightRegion.contains((ITextRegion)leftRegion)) {
                return this.getMergedLocationInResource(right);
            }
            AbstractTraceRegion parent = left.getParent();
            AbstractTraceRegion leftChild = left;
            while (parent != null) {
                if (parent.getMyRegion().contains((ITextRegion)rightRegion)) break;
                leftChild = parent;
                parent = parent.getParent();
            }
            if (parent != null) {
                ILocationData merged;
                AbstractTraceRegion rightChild = right;
                while (!parent.equals((Object)rightChild.getParent())) {
                    if ((rightChild = rightChild.getParent()) != null) continue;
                    return this.getMergedLocationInResource(leftChild);
                }
                URI path = leftToPath;
                if (path == null) {
                    path = leftChild.getAssociatedPath();
                }
                if ((merged = parent.getMergedAssociatedLocation()) != null) {
                    return new LocationInResource(merged.getOffset(), merged.getLength(), merged.getLineNumber(), merged.getEndLineNumber(), path, this);
                }
            }
        }
        return null;
    }

    @Nullable
    protected ILocationInResource getMergedLocationInResource(AbstractTraceRegion region) {
        ILocationData locationData = region.getMergedAssociatedLocation();
        if (locationData != null) {
            return this.createLocationInResourceFor(locationData, region);
        }
        return null;
    }

    @Nullable
    protected ILocationInResource createLocationInResourceFor(ILocationData location, AbstractTraceRegion traceRegion) {
        URI path = location.getPath();
        if (path == null) {
            path = traceRegion.getAssociatedPath();
        }
        if (path == null) {
            return null;
        }
        return new LocationInResource(location.getOffset(), location.getLength(), location.getLineNumber(), location.getEndLineNumber(), path, this);
    }

    protected URI resolvePath(URI path) {
        return path;
    }

    @Nullable
    public AbstractTraceRegion findTraceRegionAtRightOffset(int offset) {
        return this.findTraceRegionAt(offset, true);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected AbstractTraceRegion findTraceRegionAt(int offset, boolean includeRegionEnd) {
        candidate = this.getRootTraceRegion();
        if (candidate != null && this.encloses(candidate, offset, includeRegionEnd)) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            children = candidate.getNestedRegions();
            if (children.isEmpty()) {
                return candidate;
            }
            for (AbstractTraceRegion child : children) {
                if (this.encloses(child, offset, includeRegionEnd)) {
                    candidate = child;
                    continue block0;
                }
                if (child.getMyOffset() <= offset) continue;
                return candidate;
            }
            return candidate;
lbl14:
            // 2 sources

            ** while (candidate != null)
        }
lbl15:
        // 1 sources

        return null;
    }

    @Nullable
    public AbstractTraceRegion findTraceRegionAtLeftOffset(int offset) {
        return this.findTraceRegionAt(offset, false);
    }

    public boolean encloses(AbstractTraceRegion region, int offset, boolean includeRegionEnd) {
        return this.encloses(region.getMyOffset(), region.getMyLength(), offset, includeRegionEnd);
    }

    public boolean encloses(int regionOffset, int regionLength, int offset, boolean includeRegionEnd) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset may not be negative");
        }
        int relativeOffset = offset - regionOffset;
        boolean result = relativeOffset == 0 || relativeOffset > 0 && !(includeRegionEnd ? relativeOffset > regionLength : relativeOffset >= regionLength);
        return result;
    }

    public Iterable<ILocationInResource> getAllAssociatedLocations(ITextRegion localRegion) {
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions(localRegion);
        return this.toLocations(allTraceRegions);
    }

    @Nullable
    public ILocationInResource getBestAssociatedLocation(ITextRegion region, IStorage storage) {
        URI uri = this.getURIForStorage(storage);
        AbstractTraceRegion left = this.findTraceRegionAtLeftOffset(region.getOffset());
        left = this.findParentByURI(left, uri);
        AbstractTraceRegion right = this.findTraceRegionAtRightOffset(region.getOffset() + region.getLength());
        right = this.findParentByURI(right, uri);
        return this.mergeRegions(left, right);
    }

    protected boolean isAssociatedWith(AbstractTraceRegion region, URI uri) {
        URI convertedUri = this.traceURIConverter.getURIForTrace(uri);
        return convertedUri.equals(region.getAssociatedPath());
    }

    @Nullable
    protected AbstractTraceRegion findParentByURI(@Nullable AbstractTraceRegion region, URI uri) {
        while (region != null && !this.isAssociatedWith(region, uri)) {
            region = region.getParent();
        }
        return region;
    }

    public Iterable<ILocationInResource> getAllAssociatedLocations(ITextRegion region, IStorage storage) {
        URI uri = this.getURIForStorage(storage);
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions(region);
        TraceRegionsByURI filteredByURI = new TraceRegionsByURI(allTraceRegions, uri);
        return this.toLocations(filteredByURI);
    }

    public Iterable<ILocationInResource> getAllAssociatedLocations(IStorage storage) {
        URI uri = this.getURIForStorage(storage);
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions();
        TraceRegionsByURI filteredByURI = new TraceRegionsByURI(allTraceRegions, uri);
        return this.toLocations(filteredByURI);
    }

    @Nullable
    public LanguageInfo getLanguage() {
        return this.findLanguage(this.getLocalURI());
    }

    public abstract URI getLocalURI();

    protected URI getURIForStorage(IStorage storage) {
        URI uri = this.storage2uriMapper.getUri(storage);
        if (uri != null) {
            return uri;
        }
        return URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
    }

    public abstract IProject getLocalProject();

    protected Iterable<ILocationInResource> toLocations(Iterable<AbstractTraceRegion> allTraceRegions) {
        ArrayList result = Lists.newArrayList();
        for (AbstractTraceRegion region : allTraceRegions) {
            for (ILocationData locationData : region.getAssociatedLocations()) {
                ILocationInResource locationInResource = this.createLocationInResourceFor(locationData, region);
                if (locationInResource == null) continue;
                result.add(locationInResource);
            }
        }
        return result;
    }

    protected Iterable<AbstractTraceRegion> getAllTraceRegions(ITextRegion localRegion) {
        final AbstractTraceRegion left = this.findTraceRegionAtLeftOffset(localRegion.getOffset());
        final int end = localRegion.getOffset() + localRegion.getLength();
        if (left == null) {
            return Collections.emptyList();
        }
        return new Iterable<AbstractTraceRegion>(){

            @Override
            public Iterator<AbstractTraceRegion> iterator() {
                AbstractTraceRegion root = AbstractTrace.this.getRootTraceRegion();
                if (root == null) {
                    return Iterators.emptyIterator();
                }
                final Iterator allLeafs = root.leafIterator();
                AbstractIterator<AbstractTraceRegion> result = new AbstractIterator<AbstractTraceRegion>(left){
                    AbstractTraceRegion first;
                    {
                        while (this.first == null && iterator.hasNext()) {
                            AbstractTraceRegion next = (AbstractTraceRegion)iterator.next();
                            if (next.getMyOffset() != abstractTraceRegion.getMyOffset()) continue;
                            this.first = next;
                            break;
                        }
                    }

                    protected AbstractTraceRegion computeNext() {
                        if (this.first != null) {
                            AbstractTraceRegion result = this.first;
                            this.first = null;
                            return result;
                        }
                        if (!allLeafs.hasNext()) {
                            return (AbstractTraceRegion)this.endOfData();
                        }
                        AbstractTraceRegion candidate = (AbstractTraceRegion)allLeafs.next();
                        if (candidate.getMyOffset() >= end) {
                            return (AbstractTraceRegion)this.endOfData();
                        }
                        return candidate;
                    }
                };
                return result;
            }
        };
    }

    public Iterable<ILocationInResource> getAllAssociatedLocations() {
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions();
        return this.toLocations(allTraceRegions);
    }

    protected Iterable<AbstractTraceRegion> getAllTraceRegions() {
        return new Iterable<AbstractTraceRegion>(){

            @Override
            public Iterator<AbstractTraceRegion> iterator() {
                AbstractTraceRegion root = AbstractTrace.this.getRootTraceRegion();
                if (root == null) {
                    return Iterators.emptyIterator();
                }
                Iterator result = root.leafIterator();
                return result;
            }
        };
    }

    @Nullable
    protected Resource getResource(URI uri, IProject project) {
        IResourceSetProvider resourceSetProvider = this.getService(uri, IResourceSetProvider.class);
        if (resourceSetProvider != null) {
            ResourceSet resourceSet = resourceSetProvider.get(project);
            try {
                Resource result = resourceSet.getResource(uri, true);
                return result;
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }

    protected abstract IStorage findStorage(URI var1, IProject var2);

    protected abstract InputStream getContents(URI var1, IProject var2) throws CoreException;

    protected IProject findProject(String projectName) {
        IProject result = this.workspace.getRoot().getProject(projectName);
        return result;
    }

    protected IWorkspace getWorkspace() {
        return this.workspace;
    }

    @Nullable
    protected LanguageInfo findLanguage(@Nullable URI uri) {
        return this.getService(uri, LanguageInfo.class);
    }

    @Nullable
    protected <T> T getService(@Nullable URI uri, Class<T> type) {
        if (uri == null) {
            return null;
        }
        IResourceServiceProvider serviceProvider = this.resourceServiceRegistry.getResourceServiceProvider(uri);
        if (serviceProvider != null) {
            return (T)serviceProvider.get(type);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TraceRegionsByURI
    implements Iterable<AbstractTraceRegion> {
        private final Iterable<AbstractTraceRegion> allTraceRegions;
        private final URI uri;

        protected TraceRegionsByURI(Iterable<AbstractTraceRegion> allTraceRegions, URI uri) {
            this.allTraceRegions = allTraceRegions;
            this.uri = uri;
        }

        @Override
        public Iterator<AbstractTraceRegion> iterator() {
            Iterator<AbstractTraceRegion> result = this.allTraceRegions.iterator();
            Iterator languageSpecificWithDuplicates = Iterators.transform(result, (Function)new Function<AbstractTraceRegion, AbstractTraceRegion>(){

                @Nullable
                public AbstractTraceRegion apply(@Nullable AbstractTraceRegion input) {
                    return AbstractTrace.this.findParentByURI(input, TraceRegionsByURI.this.uri);
                }
            });
            UnmodifiableIterator withoutDuplicates = Iterators.filter((Iterator)languageSpecificWithDuplicates, (Predicate)new Predicate<AbstractTraceRegion>(){
                private AbstractTraceRegion previous = null;

                public boolean apply(@Nullable AbstractTraceRegion input) {
                    if (input == null || input.equals((Object)this.previous)) {
                        return false;
                    }
                    this.previous = input;
                    return true;
                }
            });
            return withoutDuplicates;
        }
    }
}

