/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IWorkingCopyOwnerProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;

public class WorkingCopyOwnerProvider
implements IWorkingCopyOwnerProvider {
    @Inject
    private ResourceDescriptionsProvider descriptionsProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    public WorkingCopyOwner getWorkingCopyOwner(final IJavaProject javaProject, final ResourceSet resourceset) {
        return new WorkingCopyOwner(){

            public String findSource(String typeName, String packageName) {
                if (packageName.startsWith("java")) {
                    return super.findSource(typeName, packageName);
                }
                QualifiedName qn = WorkingCopyOwnerProvider.this.toQualifiedName(packageName, typeName);
                IResourceDescriptions descriptions = WorkingCopyOwnerProvider.this.descriptionsProvider.getResourceDescriptions(resourceset);
                for (IEObjectDescription candidate : descriptions.getExportedObjects(TypesPackage.Literals.JVM_DECLARED_TYPE, qn, false)) {
                    Iterator storage = WorkingCopyOwnerProvider.this.storage2UriMapper.getStorages(candidate.getEObjectURI().trimFragment()).iterator();
                    while (storage.hasNext()) {
                        IStorage next = (IStorage)((Pair)storage.next()).getFirst();
                        if (!WorkingCopyOwnerProvider.this.isOnClassPath(javaProject, next)) continue;
                        return WorkingCopyOwnerProvider.this.getSource(typeName, packageName, candidate, resourceset);
                    }
                }
                return super.findSource(typeName, packageName);
            }

            public boolean isPackage(String[] pkg) {
                return super.isPackage(pkg);
            }
        };
    }

    protected boolean isOnClassPath(IJavaProject javaProject, IStorage storage) {
        if (storage instanceof IJarEntryResource) {
            javaProject.isOnClasspath((IJavaElement)((IJarEntryResource)storage).getPackageFragmentRoot());
        }
        if (storage instanceof IResource) {
            return javaProject.isOnClasspath((IResource)storage);
        }
        return false;
    }

    protected String getSource(String typeName, String packageName, IEObjectDescription next, ResourceSet resourceset) {
        StringBuilder result = new StringBuilder();
        if (packageName != null) {
            result.append("package ").append(packageName).append("; public ");
        }
        if (next.getEClass() == TypesPackage.Literals.JVM_ANNOTATION_TYPE) {
            result.append("@interface ");
        } else if (next.getEClass() == TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            result.append("enum ");
        } else if (next.getUserData("interface") != null) {
            result.append("interface ");
        } else {
            result.append("class ");
        }
        result.append(typeName);
        String typeParameters = next.getUserData("typeParameters");
        if (typeParameters != null) {
            result.append(typeParameters);
        }
        result.append("{}");
        return result.toString();
    }

    protected QualifiedName toQualifiedName(String packageName, String typeName) {
        List splitPackage = Strings.split((String)packageName, (char)'.');
        splitPackage.add(typeName);
        QualifiedName qn = QualifiedName.create((List)splitPackage);
        return qn;
    }
}

