/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveShadowedResourceDescriptions
extends ResourceSetBasedResourceDescriptions {
    @Inject
    private ResourceSetBasedResourceDescriptions localDescriptions;
    @Inject
    private IResourceDescriptions globalDescriptions;

    @Override
    public void setContext(Notifier ctx) {
        this.localDescriptions.setContext(ctx);
        if (this.globalDescriptions instanceof IResourceDescriptions.IContextAware) {
            ((IResourceDescriptions.IContextAware)this.globalDescriptions).setContext(ctx);
        }
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        IResourceDescription result = this.localDescriptions.getResourceDescription(uri);
        if (result == null && !this.isExistingOrRenamedResourceURI(uri)) {
            result = this.globalDescriptions.getResourceDescription(uri);
        }
        return result;
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        Iterable notInLiveResourceSet = Iterables.filter(this.globalDescriptions.getAllResourceDescriptions(), (Predicate)new Predicate<IResourceDescription>(){

            public boolean apply(IResourceDescription input) {
                return !LiveShadowedResourceDescriptions.this.isExistingOrRenamedResourceURI(input.getURI());
            }
        });
        Iterable result = Iterables.concat(this.localDescriptions.getAllResourceDescriptions(), (Iterable)notInLiveResourceSet);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.globalDescriptions.isEmpty() && this.localDescriptions.isEmpty();
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.localDescriptions.getResourceSet();
    }

    @Override
    protected boolean hasDescription(URI uri) {
        boolean result = this.localDescriptions.hasDescription(uri);
        if (!result) {
            result = this.isExistingOrRenamedResourceURI(uri) ? false : this.globalDescriptions.getResourceDescription(uri) != null;
        }
        return result;
    }

    protected boolean isExistingOrRenamedResourceURI(URI uri) {
        ResourceSet resourceSet = this.localDescriptions.getResourceSet();
        if (resourceSet instanceof ResourceSetImpl) {
            Map map = ((ResourceSetImpl)resourceSet).getURIResourceMap();
            boolean result = map.containsKey(uri.trimFragment());
            return result;
        }
        throw new IllegalStateException("ResourceSet is not a ResourceSetImpl");
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        return Iterables.concat((Iterable)Iterables.transform(this.getAllResourceDescriptions(), (Function)new Function<ISelectable, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(ISelectable from) {
                if (from != null) {
                    return from.getExportedObjects();
                }
                return ImmutableSet.of();
            }
        }));
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        Iterable<IEObjectDescription> liveDescriptions = this.localDescriptions.getExportedObjects(type, name, ignoreCase);
        Iterable<IEObjectDescription> persistentDescriptions = this.globalDescriptions.getExportedObjects(type, name, ignoreCase);
        return this.joinIterables(liveDescriptions, persistentDescriptions);
    }

    protected Iterable<IEObjectDescription> joinIterables(Iterable<IEObjectDescription> liveDescriptions, Iterable<IEObjectDescription> persistentDescriptions) {
        Iterable filteredPersistent = Iterables.filter(persistentDescriptions, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                URI resourceURI = input.getEObjectURI().trimFragment();
                return !LiveShadowedResourceDescriptions.this.isExistingOrRenamedResourceURI(resourceURI);
            }
        });
        return Iterables.concat(liveDescriptions, (Iterable)filteredPersistent);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        Iterable<IEObjectDescription> liveDescriptions = this.localDescriptions.getExportedObjectsByType(type);
        Iterable<IEObjectDescription> persistentDescriptions = this.globalDescriptions.getExportedObjectsByType(type);
        return this.joinIterables(liveDescriptions, persistentDescriptions);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        URI resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI(object).trimFragment();
        if (this.localDescriptions.hasDescription(resourceURI)) {
            return this.localDescriptions.getExportedObjectsByObject(object);
        }
        return this.globalDescriptions.getExportedObjectsByObject(object);
    }
}

