/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XtextMetamodelReferenceHelper {
    XtextMetamodelReferenceHelper() {
    }

    static List<EObject> findBestMetamodelForType(TypeRef context, String alias, String typeName, IScope scope) {
        ArrayList<AbstractMetamodelDeclaration> generatedMetamodels = new ArrayList<AbstractMetamodelDeclaration>();
        ArrayList<AbstractMetamodelDeclaration> importedMetamodels = new ArrayList<AbstractMetamodelDeclaration>();
        XtextMetamodelReferenceHelper.filterMetamodelsInScope(alias, scope, generatedMetamodels, importedMetamodels);
        ArrayList<AbstractMetamodelDeclaration> exactMatches = new ArrayList<AbstractMetamodelDeclaration>();
        XtextMetamodelReferenceHelper.filterExactMatches(alias, importedMetamodels, exactMatches);
        List<EObject> result = XtextMetamodelReferenceHelper.findReferencedMetamodelWithType(typeName, exactMatches);
        if (result != null) {
            return result;
        }
        result = XtextMetamodelReferenceHelper.findReferencedMetamodelWithType(typeName, importedMetamodels);
        if (result != null) {
            return result;
        }
        result = XtextMetamodelReferenceHelper.findSingleElementInCollections(alias, generatedMetamodels);
        if (result != null) {
            return result;
        }
        result = XtextMetamodelReferenceHelper.findSingleElementInCollections(alias, importedMetamodels);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private static List<EObject> findSingleElementInCollections(String alias, List<AbstractMetamodelDeclaration> candidates) {
        ArrayList<AbstractMetamodelDeclaration> exactMatches = new ArrayList<AbstractMetamodelDeclaration>();
        XtextMetamodelReferenceHelper.filterExactMatches(alias, candidates, exactMatches);
        if (exactMatches.size() == 1) {
            return Collections.singletonList((EObject)exactMatches.get(0));
        }
        if (candidates.size() == 1) {
            return Collections.singletonList((EObject)candidates.get(0));
        }
        return null;
    }

    private static List<EObject> findReferencedMetamodelWithType(String typeName, List<AbstractMetamodelDeclaration> candidates) {
        AbstractMetamodelDeclaration result = null;
        for (AbstractMetamodelDeclaration metamodel : candidates) {
            EClassifier classifier;
            EPackage pack;
            if (!(metamodel instanceof ReferencedMetamodel) || (pack = metamodel.getEPackage()) == null || (classifier = pack.getEClassifier(typeName)) == null) continue;
            if (result == null) {
                result = metamodel;
                continue;
            }
            return Collections.emptyList();
        }
        if (result != null) {
            return Collections.singletonList(result);
        }
        return null;
    }

    private static void filterExactMatches(final String alias, List<AbstractMetamodelDeclaration> importedMetamodels, List<AbstractMetamodelDeclaration> exactMatches) {
        Iterables.addAll(exactMatches, (Iterable)Iterables.filter(importedMetamodels, (Predicate)new Predicate<AbstractMetamodelDeclaration>(){

            public boolean apply(AbstractMetamodelDeclaration param) {
                return alias.equals(param.getAlias());
            }
        }));
    }

    private static void filterMetamodelsInScope(final String alias, IScope scope, List<AbstractMetamodelDeclaration> generatedMetamodels, List<AbstractMetamodelDeclaration> importedMetamodels) {
        Iterable all = Iterables.filter((Iterable)Iterables.transform(scope.getAllElements(), (Function)new Function<IEObjectDescription, AbstractMetamodelDeclaration>(){

            public AbstractMetamodelDeclaration apply(IEObjectDescription param) {
                return (AbstractMetamodelDeclaration)param.getEObjectOrProxy();
            }
        }), (Predicate)new Predicate<AbstractMetamodelDeclaration>(){

            public boolean apply(AbstractMetamodelDeclaration param) {
                return XtextMetamodelReferenceHelper.metamodelAliasMatches(param, alias);
            }
        });
        for (AbstractMetamodelDeclaration decl : all) {
            if (decl instanceof GeneratedMetamodel) {
                generatedMetamodels.add(decl);
                continue;
            }
            importedMetamodels.add(decl);
        }
    }

    private static boolean metamodelAliasMatches(AbstractMetamodelDeclaration metamodelDeclaration, String text) {
        return text.equals(Strings.emptyIfNull((String)metamodelDeclaration.getAlias()));
    }
}

