/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirtyStateManager
extends AbstractResourceDescriptionChangeEventSource
implements IDirtyStateManager {
    private ConcurrentMap<URI, IDirtyResource> managedResources = new MapMaker().makeMap();

    @Override
    public void announceDirtyStateChanged(IDirtyResource dirtyResource) {
        this.managedResources.put(dirtyResource.getURI(), dirtyResource);
        this.notifyListeners(dirtyResource, true);
    }

    @Override
    public void discardDirtyState(IDirtyResource dirtyResource) {
        if (this.managedResources.remove(dirtyResource.getURI(), dirtyResource)) {
            this.notifyListeners(dirtyResource, false);
        }
    }

    protected void notifyListeners(final IDirtyResource dirtyResource, boolean managed) {
        if (managed) {
            IResourceDescription.Delta delta = new IResourceDescription.Delta(){

                public boolean haveEObjectDescriptionsChanged() {
                    return true;
                }

                public IResourceDescription getOld() {
                    return null;
                }

                public IResourceDescription getNew() {
                    return dirtyResource.getDescription();
                }

                public URI getUri() {
                    return dirtyResource.getURI();
                }
            };
            this.notifyListeners((IResourceDescription.Event)new Event(Collections.singletonList(delta), this));
        } else {
            IResourceDescription.Delta delta = new IResourceDescription.Delta(){

                public boolean haveEObjectDescriptionsChanged() {
                    return true;
                }

                public IResourceDescription getOld() {
                    return dirtyResource.getDescription();
                }

                public IResourceDescription getNew() {
                    return null;
                }

                public URI getUri() {
                    return dirtyResource.getURI();
                }
            };
            this.notifyListeners((IResourceDescription.Event)new Event(Collections.singletonList(delta), this));
        }
    }

    @Override
    public boolean manageDirtyState(IDirtyResource dirtyResource) {
        IDirtyResource prevValue = this.managedResources.putIfAbsent(dirtyResource.getURI(), dirtyResource);
        return prevValue == null || prevValue == dirtyResource;
    }

    public IDirtyResource getDirtyResource(URI uri) {
        return (IDirtyResource)this.managedResources.get(uri);
    }

    @Override
    public IResourceDescription getDirtyResourceDescription(URI uri) {
        IDirtyResource dirtyResource = this.getDirtyResource(uri);
        if (dirtyResource != null) {
            return dirtyResource.getDescription();
        }
        return null;
    }

    public String getContent(URI uri) {
        IDirtyResource dirtyResource = this.findDirtyResourcebyURIorNormalizedURI(uri);
        if (dirtyResource != null) {
            return dirtyResource.getContents();
        }
        return null;
    }

    protected IDirtyResource findDirtyResourcebyURIorNormalizedURI(URI uri) {
        IDirtyResource dirtyResource = (IDirtyResource)this.managedResources.get(uri);
        if (dirtyResource == null) {
            Iterator iterator = this.managedResources.values().iterator();
            while (dirtyResource == null && iterator.hasNext()) {
                URI normalizedURI;
                IDirtyResource res = (IDirtyResource)iterator.next();
                if (!(res instanceof IDirtyResource.NormalizedURISupportExtension) || !(normalizedURI = ((IDirtyResource.NormalizedURISupportExtension)res).getNormalizedURI()).equals(uri)) continue;
                dirtyResource = res;
            }
        }
        return dirtyResource;
    }

    public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
        return new IExternalContentSupport.IExternalContentProvider(){

            public boolean hasContent(URI uri) {
                return DirtyStateManager.this.hasContent(uri);
            }

            public String getContent(URI uri) {
                IDirtyResource dirtyResource = DirtyStateManager.this.findDirtyResourcebyURIorNormalizedURI(uri);
                if (dirtyResource != null) {
                    return dirtyResource.getActualContents();
                }
                return null;
            }

            public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
                return this;
            }
        };
    }

    public boolean hasContent(URI uri) {
        return this.findDirtyResourcebyURIorNormalizedURI(uri) != null;
    }

    public boolean isEmpty() {
        return this.managedResources.isEmpty();
    }

    public Iterable<IEObjectDescription> getExportedObjects() {
        return Iterables.concat((Iterable)Iterables.transform(this.managedResources.values(), (Function)new Function<IDirtyResource, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IDirtyResource from) {
                if (from != null) {
                    return from.getDescription().getExportedObjects();
                }
                return Collections.emptyList();
            }
        }));
    }

    public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName name, final boolean ignoreCase) {
        return Iterables.concat((Iterable)Iterables.transform(this.managedResources.values(), (Function)new Function<IDirtyResource, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IDirtyResource from) {
                if (from != null) {
                    return from.getDescription().getExportedObjects(type, name, ignoreCase);
                }
                return Collections.emptyList();
            }
        }));
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        URI resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)object).trimFragment();
        IDirtyResource dirtyResource = this.getDirtyResource(resourceURI);
        if (dirtyResource != null) {
            return dirtyResource.getDescription().getExportedObjectsByObject(object);
        }
        return Collections.emptyList();
    }

    public Iterable<IEObjectDescription> getExportedObjectsByType(final EClass type) {
        return Iterables.concat((Iterable)Iterables.transform(this.managedResources.values(), (Function)new Function<IDirtyResource, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IDirtyResource from) {
                if (from != null) {
                    return from.getDescription().getExportedObjectsByType(type);
                }
                return Collections.emptyList();
            }
        }));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Event
    extends ResourceDescriptionChangeEvent {
        public Event(Collection<IResourceDescription.Delta> delta, IResourceDescription.Event.Source sender) {
            super(delta, sender);
        }

        public IDirtyStateManager getSender() {
            return (IDirtyStateManager)super.getSender();
        }
    }
}

