/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.util.IssueUtil;

public class XtextResourceMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    private final IssueResolutionProvider issueResolutionProvider;
    private final IssueUtil issueUtil;
    private boolean connected;

    public XtextResourceMarkerAnnotationModel(IFile file, IssueResolutionProvider issueResolutionProvider, IssueUtil markerUtil) {
        super((IResource)file);
        this.issueResolutionProvider = issueResolutionProvider;
        this.issueUtil = markerUtil;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        MarkerAnnotation annotation = super.createMarkerAnnotation(marker);
        String issueCode = this.issueUtil.getCode((Annotation)annotation);
        annotation.setQuickFixable(this.issueResolutionProvider.hasResolutionFor(issueCode));
        return annotation;
    }

    public void fireAnnotationChangedEvent(Annotation annotation) {
        this.queueAnnotationChanged(annotation);
        this.fireQueuedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAnnotationChanged(Annotation annotation) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.getAnnotationModelEvent().annotationChanged(annotation);
        }
    }

    public void fireQueuedEvents() {
        this.fireModelChanged();
    }

    protected void connected() {
        super.connected();
        this.connected = true;
    }

    public void updateMarkers(IDocument document) throws CoreException {
        if (!this.connected) {
            return;
        }
        super.updateMarkers(document);
    }
}

