/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.reconciler.ReconcilerReplaceRegion;
import org.eclipse.xtext.ui.editor.reconciler.XtextSpellingReconcileStrategy;

public class XtextDocumentReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ISourceViewerAware {
    private static final Logger log = Logger.getLogger(XtextDocumentReconcileStrategy.class);
    @Inject
    private XtextSpellingReconcileStrategy.Factory spellingReconcileStrategyFactory;
    private XtextSpellingReconcileStrategy spellingReconcileStrategy;
    private XtextResource resource;

    public void reconcile(IRegion region) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("reconcile region: " + region));
        }
        this.doReconcile(region);
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.reconcile(region);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void setDocument(IDocument document) {
        if (!(document instanceof XtextDocument)) {
            throw new IllegalArgumentException("Document must be an " + XtextDocument.class.getSimpleName());
        }
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.setDocument(document);
        }
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.spellingReconcileStrategy = this.spellingReconcileStrategyFactory.create(sourceViewer);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.initialReconcile();
        }
    }

    public void setResource(XtextResource resource) {
        this.resource = resource;
    }

    protected void doReconcile(IRegion region) {
        if (this.resource == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resource is null in XtextReconcilerUnitOfWork.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        try {
            if (!(region instanceof ReconcilerReplaceRegion)) {
                throw new IllegalArgumentException("Region to be reconciled must be a ReplaceRegion");
            }
            ReconcilerReplaceRegion replaceRegionToBeProcessed = (ReconcilerReplaceRegion)region;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Parsing replace region '" + (Object)((Object)replaceRegionToBeProcessed) + "'."));
            }
            this.resource.update(replaceRegionToBeProcessed.getOffset(), replaceRegionToBeProcessed.getLength(), replaceRegionToBeProcessed.getText());
            this.resource.setModificationStamp(replaceRegionToBeProcessed.getModificationStamp());
        }
        catch (RuntimeException exc) {
            log.error((Object)"Parsing in reconciler failed.", (Throwable)exc);
            throw exc;
        }
    }
}

