/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.inject.Inject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class IssueUtil {
    @Inject(optional=true)
    private MarkerTypeProvider markerTypeProvider;

    public Issue createIssue(IMarker marker) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setMessage(MarkerUtilities.getMessage((IMarker)marker));
        issue.setLineNumber(Integer.valueOf(MarkerUtilities.getLineNumber((IMarker)marker) - 1));
        issue.setOffset(Integer.valueOf(MarkerUtilities.getCharStart((IMarker)marker)));
        issue.setLength(Integer.valueOf(MarkerUtilities.getCharEnd((IMarker)marker) - MarkerUtilities.getCharStart((IMarker)marker)));
        issue.setCode(this.getCode(marker));
        issue.setData(this.getIssueData(marker));
        issue.setUriToProblem(this.getUriToProblem(marker));
        issue.setSeverity(this.getSeverity(marker));
        issue.setType(this.getCheckType(marker));
        return issue;
    }

    protected CheckType getCheckType(IMarker marker) {
        String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
        if (this.markerTypeProvider != null) {
            return this.markerTypeProvider.getCheckType(markerType);
        }
        return MarkerTypes.toCheckType(markerType);
    }

    public Issue getIssueFromAnnotation(Annotation annotation) {
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xtextAnnotation = (XtextAnnotation)annotation;
            return xtextAnnotation.getIssue();
        }
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            return this.createIssue(markerAnnotation.getMarker());
        }
        return null;
    }

    public String getCode(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getCode(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getIssueCode();
        }
        return null;
    }

    public String getCode(IMarker marker) {
        return marker.getAttribute("CODE_KEY", null);
    }

    public String[] getIssueData(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getIssueData(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getIssueData();
        }
        return null;
    }

    public String[] getIssueData(IMarker marker) {
        return Strings.unpack((String)marker.getAttribute("DATA_KEY", null));
    }

    public URI getUriToProblem(IMarker marker) {
        String uri = marker.getAttribute("URI_KEY", null);
        return uri != null ? URI.createURI((String)uri) : null;
    }

    public URI getUriToProblem(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getUriToProblem(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getUriToProblem();
        }
        return null;
    }

    public Severity getSeverity(IMarker marker) {
        switch (marker.getAttribute("severity", 0)) {
            case 2: {
                return Severity.ERROR;
            }
            case 1: {
                return Severity.WARNING;
            }
            case 0: {
                return Severity.INFO;
            }
        }
        throw new IllegalArgumentException(marker.toString());
    }

    public boolean refersToSameIssue(IMarker marker, Annotation annotation) {
        URI markerURI = this.getUriToProblem(marker);
        String markerIssue = this.getCode(marker);
        if (markerURI == null || markerIssue == null) {
            return false;
        }
        return markerURI.equals(this.getUriToProblem(annotation)) && markerIssue.equals(this.getCode(annotation));
    }
}

