/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupMultiColumnReorderCommandHandler
extends AbstractLayerCommandHandler<MultiColumnReorderCommand> {
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;

    public GroupMultiColumnReorderCommandHandler(ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(MultiColumnReorderCommand command) {
        SelectionLayer.MoveDirectionEnum moveDirection;
        boolean reorderToLeftEdge;
        List<Integer> fromColumnPositions = command.getFromColumnPositions();
        int toColumnPosition = command.getToColumnPosition();
        if (!ColumnGroupUtils.isBetweenTwoGroups(this.columnGroupHeaderLayer, toColumnPosition, reorderToLeftEdge = command.isReorderToLeftEdge(), moveDirection = PositionUtil.getHorizontalMoveDirection(fromColumnPositions.get(0), toColumnPosition))) {
            for (int fromColumnPosition : fromColumnPositions) {
                if (ColumnGroupUtils.isReorderValid(this.columnGroupHeaderLayer, fromColumnPosition, toColumnPosition, reorderToLeftEdge)) continue;
                return true;
            }
        }
        int level = 0;
        while (level < this.columnGroupHeaderLayer.getLevelCount()) {
            GroupModel.Group toGroup;
            int toPositionToCheck = toColumnPosition;
            if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToLeftEdge) {
                --toPositionToCheck;
            }
            if ((toGroup = this.columnGroupHeaderLayer.getGroupByPosition(level, toPositionToCheck)) != null && SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                command.toggleCoordinateByEdge();
            }
            ++level;
        }
        return false;
    }

    @Override
    public Class<MultiColumnReorderCommand> getCommandClass() {
        return MultiColumnReorderCommand.class;
    }
}

