/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultRowHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class RowHeaderLayer
extends DimensionallyDependentLayer {
    private final SelectionLayer[] selectionLayer;

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer) {
        this(baseLayer, verticalLayerDependency, selectionLayer, true);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer ... selectionLayer) {
        this(baseLayer, verticalLayerDependency, selectionLayer, true);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(baseLayer, verticalLayerDependency, selectionLayer, useDefaultConfiguration, null);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer[] selectionLayer, boolean useDefaultConfiguration) {
        this(baseLayer, verticalLayerDependency, selectionLayer, useDefaultConfiguration, null);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        SelectionLayer[] selectionLayerArray;
        if (selectionLayer != null) {
            SelectionLayer[] selectionLayerArray2 = new SelectionLayer[1];
            selectionLayerArray = selectionLayerArray2;
            selectionLayerArray2[0] = selectionLayer;
        } else {
            selectionLayerArray = new SelectionLayer[]{};
        }
        this(baseLayer, verticalLayerDependency, selectionLayerArray, useDefaultConfiguration, layerPainter);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer[] selectionLayer, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        super(baseLayer, baseLayer, verticalLayerDependency);
        this.selectionLayer = selectionLayer == null ? new SelectionLayer[0] : selectionLayer;
        this.layerPainter = layerPainter;
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultRowHeaderLayerConfiguration());
        }
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowPositionHideCommand) {
            RowPositionHideCommand cmd = (RowPositionHideCommand)command;
            return this.getVerticalLayerDependency().doCommand(new RowHideCommand(cmd.getLayer(), cmd.getRowPosition()));
        }
        return super.doCommand(command);
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        String displayMode = super.getDisplayModeByPosition(columnPosition, rowPosition);
        if (this.selectionLayer.length > 0) {
            int selectionLayerRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.selectionLayer[0]);
            SelectionLayer[] selectionLayerArray = this.selectionLayer;
            int n = this.selectionLayer.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionLayer sl = selectionLayerArray[n2];
                if (sl.isRowPositionSelected(selectionLayerRowPosition)) {
                    if ("HOVER".equals(displayMode)) {
                        return "SELECT_HOVER";
                    }
                    return "SELECT";
                }
                ++n2;
            }
        }
        return displayMode;
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.selectionLayer.length > 0) {
            int selectionLayerRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.selectionLayer[0]);
            boolean fullySelected = true;
            SelectionLayer[] selectionLayerArray = this.selectionLayer;
            int n = this.selectionLayer.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionLayer sl = selectionLayerArray[n2];
                if (!sl.isRowPositionFullySelected(selectionLayerRowPosition)) {
                    fullySelected = false;
                    break;
                }
                ++n2;
            }
            if (fullySelected) {
                labelStack.addLabel("ROW_HEADER_FULL");
            }
        }
        return labelStack;
    }
}

