/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree;

import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;

public class GlazedListTreeData<T>
implements ITreeData<T> {
    private final TreeList<T> treeList;

    public GlazedListTreeData(TreeList<T> treeList) {
        this.treeList = treeList;
    }

    public T getDataAtIndex(int index) {
        if (!this.isValidIndex(index)) {
            return null;
        }
        return (T)this.treeList.get(index);
    }

    public int getDepthOfData(T object) {
        return this.getDepthOfData(this.indexOf(object));
    }

    public int getDepthOfData(int index) {
        if (!this.isValidIndex(index)) {
            return 0;
        }
        return this.treeList.depth(index);
    }

    public int indexOf(T object) {
        return this.treeList.indexOf(object);
    }

    public boolean hasChildren(T object) {
        return this.hasChildren(this.indexOf(object));
    }

    public boolean hasChildren(int index) {
        if (!this.isValidIndex(index)) {
            return false;
        }
        return this.treeList.hasChildren(index);
    }

    public List<T> getChildren(T object) {
        return this.getChildren(this.indexOf(object));
    }

    private List<T> getNodeChildren(TreeList.Node<T> treeNode) {
        ArrayList<Object> children = new ArrayList<Object>();
        for (TreeList.Node child : treeNode.getChildren()) {
            children.add(child.getElement());
            children.addAll(this.getNodeChildren(child));
        }
        return children;
    }

    public List<T> getChildren(T object, boolean fullDepth) {
        if (!fullDepth) {
            return this.getChildren(object);
        }
        int index = this.indexOf(object);
        if (index >= 0) {
            TreeList.Node treeNode = this.treeList.getTreeNode(index);
            return this.getNodeChildren(treeNode);
        }
        return Collections.emptyList();
    }

    public List<T> getChildren(int index) {
        TreeList.Node treeNode;
        if (!this.isValidIndex(index)) {
            return new ArrayList();
        }
        ArrayList<Object> children = null;
        if (index >= 0 && (treeNode = this.treeList.getTreeNode(index)) != null) {
            List childrenNodes = treeNode.getChildren();
            children = new ArrayList(childrenNodes.size());
            for (TreeList.Node node : childrenNodes) {
                children.add(node.getElement());
            }
        }
        return children != null ? children : new ArrayList<Object>();
    }

    public int getElementCount() {
        return this.treeList.size();
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.treeList.size();
    }

    public TreeList<T> getTreeList() {
        return this.treeList;
    }
}

