/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.markers.QuickFixWizard;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class QuickFixHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final MarkerSupportView view = this.getView(event);
        if (view == null) {
            return this;
        }
        final LinkedHashMap resolutionsMap = new LinkedHashMap();
        final IMarker[] selectedMarkers = view.getSelectedMarkers();
        final IMarker firstSelectedMarker = selectedMarkers[0];
        IRunnableWithProgress resolutionsRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(MarkerMessages.resolveMarkerAction_computationManyAction, 100);
                IMarker[] allMarkers = view.getAllMarkers();
                monitor.worked(20);
                IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(firstSelectedMarker);
                int progressCount = 80;
                if (resolutions.length > 1) {
                    progressCount /= resolutions.length;
                }
                int i = 0;
                while (i < resolutions.length) {
                    IMarkerResolution markerResolution = resolutions[i];
                    if (markerResolution instanceof WorkbenchMarkerResolution) {
                        Object[] other = ((WorkbenchMarkerResolution)markerResolution).findOtherMarkers(allMarkers);
                        if (QuickFixHandler.containsAllButFirst(other, selectedMarkers)) {
                            ArrayList<Object> markers = new ArrayList<Object>(other.length + 1);
                            markers.add(firstSelectedMarker);
                            markers.addAll(Arrays.asList(other));
                            resolutionsMap.put(markerResolution, markers);
                        }
                    } else if (selectedMarkers.length == 1) {
                        ArrayList<IMarker> markers = new ArrayList<IMarker>(1);
                        markers.add(firstSelectedMarker);
                        resolutionsMap.put(markerResolution, markers);
                    }
                    monitor.worked(progressCount);
                    ++i;
                }
                monitor.done();
            }
        };
        Object service = view.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        ProgressMonitorDialog context = new ProgressMonitorDialog(view.getSite().getShell());
        try {
            if (service == null) {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, resolutionsRunnable, null);
            } else {
                ((IWorkbenchSiteProgressService)service).runInUI((IRunnableContext)context, resolutionsRunnable, null);
            }
        }
        catch (InvocationTargetException exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        catch (InterruptedException exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        String markerDescription = firstSelectedMarker.getAttribute("message", "");
        if (resolutionsMap.isEmpty()) {
            if (selectedMarkers.length == 1) {
                MessageDialog.openInformation((Shell)view.getSite().getShell(), (String)MarkerMessages.resolveMarkerAction_dialogTitle, (String)NLS.bind((String)MarkerMessages.MarkerResolutionDialog_NoResolutionsFound, (Object[])new Object[]{markerDescription}));
            } else {
                MessageDialog.openInformation((Shell)view.getSite().getShell(), (String)MarkerMessages.resolveMarkerAction_dialogTitle, (String)MarkerMessages.MarkerResolutionDialog_NoResolutionsFoundForMultiSelection);
            }
        } else {
            String description = NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)markerDescription);
            QuickFixWizard wizard = new QuickFixWizard(description, selectedMarkers, resolutionsMap, view.getSite());
            wizard.setWindowTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
            QuickFixWizardDialog dialog = new QuickFixWizardDialog(view.getSite().getShell(), (IWizard)wizard);
            dialog.open();
        }
        return this;
    }

    private static boolean containsAllButFirst(Object[] extent, Object[] members) {
        int i = 1;
        while (i < members.length) {
            block3: {
                int j = 0;
                while (j < extent.length) {
                    if (members[i] != extent[j]) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private class QuickFixWizardDialog
    extends WizardDialog {
        public QuickFixWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
            this.setShellStyle(0xC70 | QuickFixWizardDialog.getDefaultOrientation());
        }
    }
}

