/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class UIUtil {
    public static final IWorkbench WORKBENCH;
    private static Image ERROR_IMAGE;
    private static Image WARNING_IMAGE;
    private static Image INFO_IMAGE;

    static {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Throwable throwable) {}
        WORKBENCH = workbench;
    }

    private UIUtil() {
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (Throwable throwable) {}
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    public static Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                Shell[] shells;
                shell[0] = display.getActiveShell();
                if (shell[0] == null) {
                    try {
                        IWorkbenchWindow[] windows;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length != 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            shell[0] = window.getShell();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                if (shell[0] == null && (shells = display.getShells()).length > 0) {
                    shell[0] = shells[0];
                }
            }
        });
        return shell[0];
    }

    public static GridData applyGridData(Control control) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        control.setLayoutData((Object)data);
        return data;
    }

    public static GridData grabVertical(GridData data) {
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        return data;
    }

    public static void runInProgressDialog(Shell shell, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        block3: {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                protected Point getInitialSize() {
                    Point calculatedSize = super.getInitialSize();
                    if (calculatedSize.x < 800) {
                        calculatedSize.x = 800;
                    }
                    return calculatedSize;
                }
            };
            try {
                dialog.run(true, true, runnable);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof OperationCanceledException) break block3;
                throw ex;
            }
        }
    }

    public static void handleException(Throwable ex) {
        UIPlugin.INSTANCE.log(ex);
        ErrorDialog.open(ex);
    }

    public static Image getStatusImage(int severity) {
        if (severity == 4) {
            if (ERROR_IMAGE == null) {
                ERROR_IMAGE = UIPlugin.INSTANCE.getSWTImage("error");
            }
            return ERROR_IMAGE;
        }
        if (severity == 2) {
            if (WARNING_IMAGE == null) {
                WARNING_IMAGE = UIPlugin.INSTANCE.getSWTImage("warning");
            }
            return WARNING_IMAGE;
        }
        if (INFO_IMAGE == null) {
            INFO_IMAGE = UIPlugin.INSTANCE.getSWTImage("info");
        }
        return INFO_IMAGE;
    }

    public static void exec(Display display, boolean async, Runnable runnable) {
        if (async) {
            UIUtil.asyncExec(display, runnable);
        } else {
            UIUtil.syncExec(display, runnable);
        }
    }

    public static void asyncExec(Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (display != null) {
            UIUtil.asyncExec(display, runnable);
        }
    }

    public static void asyncExec(final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void syncExec(Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (Display.getCurrent() == display || display == null) {
            runnable.run();
        } else {
            UIUtil.syncExec(display, runnable);
        }
    }

    public static void syncExec(final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.syncExec(new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void timerExec(int milliseconds, Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (display != null) {
            UIUtil.timerExec(milliseconds, display, runnable);
        }
    }

    public static void timerExec(int milliseconds, final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.timerExec(milliseconds, new Runnable(){

                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static IDialogSettings getOrCreateSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public static void dispose(Resource ... resources) {
        int i = 0;
        while (i < resources.length) {
            Resource resource = resources[i];
            if (resource != null && !resource.isDisposed()) {
                resource.dispose();
            }
            ++i;
        }
    }
}

