/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.RecorderPoliciesComposite;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderPoliciesDialog
extends AbstractSetupDialog {
    private final RecorderTransaction transaction;
    private final Map<URI, String> preferences;
    private boolean enablePreferenceRecorder = true;
    private RecorderPoliciesComposite recorderPoliciesComposite;
    private Text valueText;

    public RecorderPoliciesDialog(Shell parentShell, RecorderTransaction transaction, Map<URI, String> preferences) {
        super(parentShell, "Preference Recorder", 600, 400, SetupUIPlugin.INSTANCE, false);
        this.transaction = transaction;
        this.preferences = preferences;
    }

    public boolean isEnablePreferenceRecorder() {
        return this.enablePreferenceRecorder;
    }

    public void setEnablePreferenceRecorder(boolean enablePreferenceRecorder) {
        this.enablePreferenceRecorder = enablePreferenceRecorder;
    }

    @Override
    protected String getShellText() {
        return "Oomph Preference Recorder";
    }

    protected String getDefaultMessage() {
        return "Define whether to record preference tasks for the listed preferences from now on.";
    }

    protected void createUI(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.recorderPoliciesComposite = new RecorderPoliciesComposite((Composite)sashForm, 65536, this.transaction, false);
        this.recorderPoliciesComposite.setFocus();
        this.recorderPoliciesComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RecorderPoliciesDialog.this.updateValue((IStructuredSelection)event.getSelection());
            }
        });
        this.valueText = new Text((Composite)sashForm, 776);
        this.valueText.setBackground(this.getShell().getDisplay().getSystemColor(1));
        Listener scrollBarListener = new Listener(){
            protected boolean changing;

            public void handleEvent(Event event) {
                if (!this.changing) {
                    this.changing = true;
                    Rectangle clientArea = RecorderPoliciesDialog.this.valueText.getClientArea();
                    Rectangle trimArea = RecorderPoliciesDialog.this.valueText.computeTrim(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                    Point size = RecorderPoliciesDialog.this.valueText.computeSize(-1, -1, true);
                    RecorderPoliciesDialog.this.valueText.getHorizontalBar().setVisible(trimArea.width <= size.x);
                    RecorderPoliciesDialog.this.valueText.getVerticalBar().setVisible(trimArea.height <= size.y);
                    this.changing = false;
                }
            }
        };
        this.valueText.addListener(11, scrollBarListener);
        this.valueText.addListener(24, scrollBarListener);
        sashForm.setWeights(new int[]{4, 1});
        Dialog.applyDialogFont((Control)sashForm);
        this.updateValue(this.recorderPoliciesComposite.getSelection());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        final Button enableButton = this.createCheckbox(parent, "Recorder enabled");
        enableButton.setToolTipText("The enablement can be changed later on the preference page Oomph | Setup | Preference Recorder");
        enableButton.setSelection(this.enablePreferenceRecorder);
        enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecorderPoliciesDialog.this.enablePreferenceRecorder = enableButton.getSelection();
                RecorderPoliciesDialog.this.recorderPoliciesComposite.setEnabled(RecorderPoliciesDialog.this.enablePreferenceRecorder);
                RecorderPoliciesDialog.this.valueText.setVisible(RecorderPoliciesDialog.this.enablePreferenceRecorder);
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    private void updateValue(IStructuredSelection selection) {
        String path = (String)selection.getFirstElement();
        URI uri = PreferencesFactory.eINSTANCE.createURI(path);
        String value = StringUtil.safe((String)this.preferences.get(uri));
        this.valueText.setText(value);
    }
}

