/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.lang.reflect.Method;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.HelpSupport;
import org.eclipse.oomph.ui.OomphWizardDialog;
import org.eclipse.oomph.ui.PersistentButton;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public abstract class SetupWizardPage
extends WizardPage
implements HelpSupport.HelpProvider {
    private static final String TOGGLE_COMMAND_PREFIX = "toggleCommand:";
    private Composite checkComposite;

    public SetupWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public SetupWizard getWizard() {
        return (SetupWizard)super.getWizard();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        String sectionName = this.getName();
        return UIUtil.getOrCreateSection((IDialogSettings)settings, (String)sectionName);
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.getWizard().getAdapterFactory();
    }

    public String getHelpPath() {
        String id = "Doc" + ((Object)((Object)this)).getClass().getSimpleName();
        return "/org.eclipse.oomph.setup.doc/html/user/wizard/" + id + ".html#" + id + "_1_table";
    }

    public ResourceSet getResourceSet() {
        return this.getWizard().getResourceSet();
    }

    public CatalogManager getCatalogManager() {
        return this.getWizard().getCatalogManager();
    }

    public Trigger getTrigger() {
        return this.getWizard().getTrigger();
    }

    public Installation getInstallation() {
        return this.getWizard().getInstallation();
    }

    public Workspace getWorkspace() {
        return this.getWizard().getWorkspace();
    }

    public User getUser() {
        return this.getWizard().getUser();
    }

    public SetupTaskPerformer getPerformer() {
        return this.getWizard().getPerformer();
    }

    public void setPerformer(SetupTaskPerformer performer) {
        this.getWizard().setPerformer(performer);
    }

    public boolean performCancel() {
        return true;
    }

    protected void handleInactivity(Display display, boolean inactive) {
    }

    public void enterPage(boolean forward) {
    }

    public void leavePage(boolean forward) {
    }

    public final void advanceToNextPage() {
        IWizardPage nextPage = this.getNextPage();
        this.getContainer().showPage(nextPage);
    }

    public final void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite pageControl = new Composite(parent, 0);
        pageControl.setLayout((Layout)layout);
        super.setControl((Control)pageControl);
        this.setPageComplete(false);
        Point sizeHint = this.getSizeHint();
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = sizeHint.x;
        layoutData.heightHint = sizeHint.y;
        Control ui = this.createUI(pageControl);
        ui.setLayoutData((Object)layoutData);
        this.createCheckButtons();
        this.createFooter(pageControl);
    }

    protected void createCheckButtons() {
    }

    protected final Button addCheckButton(String text, String toolTip, boolean defaultSelection, String persistenceKey) {
        Button button;
        GridLayout checkLayout;
        if (this.checkComposite == null) {
            checkLayout = new GridLayout();
            checkLayout.marginWidth = 5;
            checkLayout.marginHeight = 0;
            this.checkComposite = new Composite((Composite)this.getControl(), 0);
            this.checkComposite.setLayout((Layout)checkLayout);
            this.checkComposite.setLayoutData((Object)new GridData());
        } else {
            checkLayout = (GridLayout)this.checkComposite.getLayout();
            ++checkLayout.numColumns;
        }
        if (persistenceKey != null) {
            boolean toggleCommand = false;
            if (persistenceKey.startsWith(TOGGLE_COMMAND_PREFIX)) {
                persistenceKey = persistenceKey.substring(TOGGLE_COMMAND_PREFIX.length());
                toggleCommand = UIUtil.WORKBENCH != null;
            }
            Object persistence = toggleCommand ? new PersistentButton.ToggleCommandPersistence(persistenceKey) : new PersistentButton.DialogSettingsPersistence(this.getDialogSettings(), persistenceKey);
            button = new PersistentButton(this.checkComposite, 32, defaultSelection, (PersistentButton.Persistence)persistence);
        } else {
            button = new Button(this.checkComposite, 32);
            button.setSelection(defaultSelection);
        }
        button.setLayoutData((Object)new GridData());
        button.setText(text);
        if (!StringUtil.isEmpty((String)toolTip)) {
            button.setToolTipText(toolTip);
        }
        return button;
    }

    protected final Composite getCheckComposite() {
        return this.checkComposite;
    }

    protected final void setControl(Control newControl) {
        throw new UnsupportedOperationException();
    }

    protected Point getSizeHint() {
        return new Point(800, 500);
    }

    protected abstract Control createUI(Composite var1);

    protected void createFooter(Composite parent) {
    }

    protected final void addHelpCallout(Control control, int number) {
        IWizardContainer container = this.getContainer();
        if (container instanceof OomphWizardDialog) {
            OomphWizardDialog dialog = (OomphWizardDialog)container;
            dialog.getHelpSupport().addHelpCallout(control, number);
        }
    }

    protected void setButtonState(int buttonID, boolean enabled) {
        try {
            IWizardContainer container = this.getContainer();
            Method method = ReflectUtil.getMethod(container.getClass(), (String)"getButton", (Class[])new Class[]{Integer.TYPE});
            method.setAccessible(true);
            Button button = (Button)method.invoke((Object)container, buttonID);
            button.setEnabled(enabled);
        }
        catch (Throwable throwable) {}
    }
}

