/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.targlets.BuckminsterGenerator;
import org.eclipse.oomph.targlets.ComponentDefinition;
import org.eclipse.oomph.targlets.ComponentExtension;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.impl.ComponentGeneratorImpl;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuckminsterGeneratorImpl
extends ModelElementImpl
implements BuckminsterGenerator {
    private static final IPath CSPEC_PATH = new Path("buckminster.cspec");
    private static final IPath CSPEX_PATH = new Path("buckminster.cspex");
    protected static final boolean SAVE_AS_COMPONENT_EDEFAULT = false;
    protected boolean saveAsComponent = false;

    protected BuckminsterGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.BUCKMINSTER_GENERATOR;
    }

    @Override
    public boolean isSaveAsComponent() {
        return this.saveAsComponent;
    }

    @Override
    public void setSaveAsComponent(boolean newSaveAsComponent) {
        boolean oldSaveAsComponent = this.saveAsComponent;
        this.saveAsComponent = newSaveAsComponent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldSaveAsComponent, this.saveAsComponent));
        }
    }

    @Override
    public EList<IInstallableUnit> generateIUs(IProject project, String qualifierReplacement, Map<String, Version> iuVersions) throws Exception {
        IFile file = project.getFile(CSPEC_PATH);
        if (file.exists()) {
            InputStream inputStream = null;
            try {
                inputStream = file.getContents();
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)inputStream);
                String id = BuckminsterDependencyHandler.getP2ID(rootElement.getAttribute("name"), rootElement.getAttribute("componentType"));
                if (id == null) {
                    return null;
                }
                ComponentDefinition componentDefinition = TargletFactory.eINSTANCE.createComponentDefinition();
                componentDefinition.setID(id);
                componentDefinition.setVersion(Version.create((String)rootElement.getAttribute("version")));
                this.handleBuckminsterDependencies(rootElement, componentDefinition);
                IInstallableUnit iu = ComponentGeneratorImpl.generateIU(componentDefinition, qualifierReplacement);
                EList eList = ECollections.singletonEList((Object)iu);
                return eList;
            }
            finally {
                IOUtil.closeSilent((Closeable)inputStream);
            }
        }
        return null;
    }

    @Override
    public void modifyIU(IInstallableUnit iu, IProject project, String qualifierReplacement, Map<String, Version> iuVersions) throws Exception {
        IFile file = project.getFile(CSPEX_PATH);
        if (file.exists()) {
            InputStream inputStream = null;
            try {
                inputStream = file.getContents();
                ComponentExtension componentExtension = TargletFactory.eINSTANCE.createComponentExtension();
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)inputStream);
                this.handleBuckminsterDependencies(rootElement, componentExtension);
                ComponentGeneratorImpl.modifyIU(componentExtension, iu);
            }
            finally {
                IOUtil.closeSilent((Closeable)inputStream);
            }
        }
    }

    private void handleBuckminsterDependencies(Element rootElement, final ComponentExtension componentExtension) throws Exception {
        new BuckminsterDependencyHandler(){

            protected void handleDependency(String id, String versionDesignator) throws Exception {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement(id);
                if (versionDesignator != null) {
                    requirement.setVersionRange(new VersionRange(versionDesignator));
                }
                componentExtension.getRequirements().add((Object)requirement);
            }
        }.handleDependencies(rootElement);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.isSaveAsComponent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setSaveAsComponent((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setSaveAsComponent(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.saveAsComponent;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    return this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 2: {
                try {
                    this.modifyIU((IInstallableUnit)arguments.get(0), (IProject)arguments.get(1), (String)arguments.get(2), (Map)arguments.get(3));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (saveAsComponent: ");
        result.append(this.saveAsComponent);
        result.append(')');
        return result.toString();
    }

    private static abstract class BuckminsterDependencyHandler {
        private BuckminsterDependencyHandler() {
        }

        public void handleDependencies(Element rootElement) throws Exception {
            XMLUtil.handleElementsByTagName((Element)rootElement, (String)"cs:dependencies", (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                public void handleElement(Element dependencies) throws Exception {
                    XMLUtil.handleElementsByTagName((Element)dependencies, (String)"cs:dependency", (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                        public void handleElement(Element dependency) throws Exception {
                            String id = dependency.getAttribute("name");
                            String type = dependency.getAttribute("componentType");
                            String versionDesignator = dependency.getAttribute("versionDesignator");
                            BuckminsterDependencyHandler.this.handleDependency(id, type, versionDesignator);
                        }
                    });
                }
            });
        }

        protected void handleDependency(String id, String type, String versionDesignator) throws Exception {
            if ((id = BuckminsterDependencyHandler.getP2ID(id, type)) != null) {
                this.handleDependency(id, versionDesignator);
            }
        }

        protected void handleDependency(String id, String versionDesignator) throws Exception {
        }

        public static String getP2ID(String id, String type) {
            if (id != null && type != null) {
                if (type.equals("eclipse.feature")) {
                    return String.valueOf(id) + ".feature.group";
                }
                return id;
            }
            return null;
        }
    }
}

