/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.targlets.PluginGenerator;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.util.VersionGenerator;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginGeneratorImpl
extends ModelElementImpl
implements PluginGenerator {
    private static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");

    protected PluginGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.PLUGIN_GENERATOR;
    }

    @Override
    public EList<IInstallableUnit> generateIUs(IProject project, final String qualifierReplacement, final Map<String, Version> iuVersions) throws Exception {
        BasicEList result = new BasicEList();
        ResourcesUtil.runWithFile((IProject)project, (IPath)MANIFEST_PATH, (ResourcesUtil.RunnableWithFile)new ResourcesUtil.RunnableWithFile((EList)result){
            private final /* synthetic */ EList val$result;
            {
                this.val$result = eList;
            }

            public void run(File projectFolder, File file) throws Exception {
                BundleGeneratorAction action = new BundleGeneratorAction();
                action.generateIUs(projectFolder, qualifierReplacement, iuVersions, (EList<IInstallableUnit>)this.val$result);
            }
        });
        return result;
    }

    @Override
    public void modifyIU(IInstallableUnit iu, IProject project, String qualifierReplacement, Map<String, Version> iuVersions) throws Exception {
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    return this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 2: {
                try {
                    this.modifyIU((IInstallableUnit)arguments.get(0), (IProject)arguments.get(1), (String)arguments.get(2), (Map)arguments.get(3));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BundleGeneratorAction
    extends BundlesAction {
        public BundleGeneratorAction() {
            super(null);
            this.setPublisherInfo((IPublisherInfo)new PublisherInfo());
        }

        public void generateIUs(File projectFolder, String qualifierReplacement, Map<String, Version> ius, EList<IInstallableUnit> result) throws Exception {
            Dictionary manifest = BundleGeneratorAction.loadManifest((File)projectFolder);
            if (manifest == null) {
                return;
            }
            String version = (String)manifest.get("Bundle-Version");
            manifest.put("Bundle-Version", VersionGenerator.replaceQualifier(version, qualifierReplacement));
            BundleDescription description = BundleGeneratorAction.createBundleDescription((Dictionary)manifest, (File)projectFolder);
            if (description == null) {
                return;
            }
            this.createAdviceFileAdvice(description, this.info);
            IInstallableUnit iu = BundleGeneratorAction.createBundleIU((BundleDescription)description, null, (IPublisherInfo)this.info);
            if (iu instanceof InstallableUnit) {
                ((InstallableUnit)iu).setArtifacts(new IArtifactKey[0]);
            }
            result.add((Object)iu);
            MetadataFactory.InstallableUnitDescription[] otherDescriptions = BundleGeneratorAction.processAdditionalInstallableUnitsAdvice((IInstallableUnit)iu, (IPublisherInfo)this.info);
            if (otherDescriptions != null) {
                MetadataFactory.InstallableUnitDescription[] installableUnitDescriptionArray = otherDescriptions;
                int n = otherDescriptions.length;
                int n2 = 0;
                while (n2 < n) {
                    MetadataFactory.InstallableUnitDescription otherDescription = installableUnitDescriptionArray[n2];
                    IInstallableUnit otherIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)otherDescription);
                    result.add((Object)otherIU);
                    ++n2;
                }
            }
        }
    }
}

