/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.IOException;
import org.eclipse.oomph.util.IORuntimeException;

public final class HexUtil {
    private HexUtil() {
    }

    public static String bytesToHex(byte[] bs) {
        if (bs == null) {
            return null;
        }
        return HexUtil.bytesToHex(bs, 0, bs.length);
    }

    private static String bytesToHex(byte[] bs, int off, int length) {
        if (bs == null) {
            return null;
        }
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(length * 2);
        HexUtil.bytesToHexAppend(bs, off, length, sb);
        return sb.toString();
    }

    private static void bytesToHexAppend(byte[] bs, int off, int length, Appendable appendable) {
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        if (appendable instanceof StringBuffer) {
            StringBuffer buffer = (StringBuffer)appendable;
            buffer.ensureCapacity(buffer.length() + length * 2);
        }
        try {
            int i = off;
            while (i < off + length) {
                appendable.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
                appendable.append(Character.forDigit(bs[i] & 0xF, 16));
                ++i;
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static byte[] hexToBytes(String s) {
        return HexUtil.hexToBytes(s, 0);
    }

    private static byte[] hexToBytes(String s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        HexUtil.hexToBytes(s, bs, off);
        return bs;
    }

    private static void hexToBytes(String s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        int slen = s.length();
        if ((slen & 1) == 1) {
            s = String.valueOf('0') + s;
        }
        if (out.length < off + (slen >> 1)) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + out.length + '<' + off + (slen >> 1) + ')');
        }
        int i = 0;
        while (i < slen) {
            byte b1 = (byte)Character.digit(s.charAt(i), 16);
            byte b2 = (byte)Character.digit(s.charAt(i + 1), 16);
            if (b1 < 0 || b2 < 0) {
                throw new NumberFormatException(s);
            }
            out[off + i / 2] = (byte)(b1 << 4 | b2);
            i += 2;
        }
    }
}

