/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.ui.JREController;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.VariableType;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.Authenticator;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.util.ConcurrentArray;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyField {
    public static final int NUM_COLUMNS = 3;
    private static final String EMPTY = "";
    private static final Pattern JRE_LOCATION_VARIABLE_PATTERN = Pattern.compile("\\$\\{jre\\.location-([0-9]*)\\.([0-9]*)\\}");
    private final GridData labelGridData = new GridData(131072, 128, false, false);
    private final GridData controlGridData = new GridData(4, 128, true, false);
    private final GridData helperGridData = new GridData(4, 128, false, false);
    private final ValueListenerArray valueListeners = new ValueListenerArray();
    private String value = "";
    private String labelText;
    private String toolTip;
    private Label label;
    private Control helper;
    private boolean enabled = true;

    public static PropertyField createField(VariableTask variable) {
        PropertyField field = PropertyField.createField(variable.getType(), (List<? extends VariableChoice>)variable.getChoices());
        String label = variable.getLabel();
        if (StringUtil.isEmpty((String)label)) {
            label = variable.getName();
        }
        field.setLabelText(label);
        field.setToolTip(variable.getDescription());
        GridData gridData = field.getLabelGridData();
        gridData.widthHint = 150;
        return field;
    }

    public static PropertyField createField(VariableType type, List<? extends VariableChoice> choices) {
        switch (type) {
            case JRE: {
                if (choices.isEmpty()) {
                    JREField jREField = new JREField(new JREFilter(Integer.valueOf(1), Integer.valueOf(8), null), choices);
                    return jREField;
                }
                for (VariableChoice variableChoice : choices) {
                    Matcher matcher;
                    String value = variableChoice.getValue();
                    if (value == null || !(matcher = JRE_LOCATION_VARIABLE_PATTERN.matcher(value)).matches()) continue;
                    int major = Integer.valueOf(matcher.group(1));
                    int minor = Integer.valueOf(matcher.group(2)) - 1;
                    return new JREField(new JREFilter(Integer.valueOf(major), Integer.valueOf(minor), null), choices);
                }
                return PropertyField.createField(VariableType.FOLDER, choices);
            }
            case FOLDER: {
                FolderField folderField = new FolderField(choices);
                folderField.setDialogText("Folder Selection");
                folderField.setDialogMessage("Select a folder.");
                return folderField;
            }
            case FILE: {
                FileField fileField = new FileField(choices);
                fileField.setDialogText("File Selection");
                return fileField;
            }
            case CONTAINER: {
                ContainerField containerField = new ContainerField(choices);
                containerField.setDialogText("Container Selection");
                containerField.setDialogMessage("Select a container.");
                return containerField;
            }
            case TEXT: {
                TextField textField = new TextField((List)choices){

                    protected Text createText(Composite parent, int style) {
                        return super.createText(parent, style | 2 | 0x200);
                    }
                };
                textField.getControlGridData().heightHint = 50;
                return textField;
            }
            case PASSWORD: {
                return new AuthenticatedField();
            }
            case BOOLEAN: {
                return new CheckboxField();
            }
        }
        return new TextField(choices);
    }

    public PropertyField() {
        this(null);
    }

    public PropertyField(String labelText) {
        this.labelText = labelText;
        this.setValue(null);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[label=" + this.labelText + ", value=" + this.value + "]";
    }

    public final String getLabelText() {
        return this.labelText;
    }

    public final void setLabelText(String labelText) {
        if (labelText.endsWith(":")) {
            labelText = labelText.substring(0, labelText.length() - 1);
        }
        this.labelText = labelText.trim();
    }

    public final String getToolTip() {
        return this.toolTip;
    }

    public final void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public final String getValue() {
        return this.value;
    }

    public abstract String getDefaultValue();

    public final void setValue(String value) {
        this.setValue(value, true);
    }

    public final void setValue(String value, boolean notify) {
        this.setValue(value, notify, true);
    }

    public final void setValue(String value, boolean notify, boolean transfer) {
        String oldValue;
        if (value == null) {
            value = EMPTY;
        }
        if (!(oldValue = this.value).equals(value)) {
            String controlValue;
            this.value = value;
            if (transfer && !(controlValue = this.getControlValue()).equals(value)) {
                this.transferValueToControl(value, false);
            }
            if (notify) {
                this.notifyValueListeners(oldValue, value);
            }
        }
    }

    public final void addValueListener(ValueListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.valueListeners.add(listener);
    }

    public final void removeValueListener(ValueListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.valueListeners.remove(listener);
    }

    public final void fill(Composite parent) {
        this.checkParentLayout(parent);
        this.label = new Label(parent, 64);
        this.label.setLayoutData((Object)this.labelGridData);
        if (this.labelText != null) {
            this.label.setText(String.valueOf(this.labelText) + ":");
        }
        Control control = this.createControl(parent);
        Control mainControl = this.getMainControl();
        mainControl.setLayoutData((Object)this.controlGridData);
        if (this.toolTip != null && this.toolTip.length() != 0) {
            this.label.setToolTipText(this.toolTip);
            control.setToolTipText(this.toolTip);
            mainControl.setToolTipText(this.toolTip);
        }
        this.helper = this.createHelper(parent);
        this.helper = this.helper == null ? new Label(parent, 0) : this.getMainHelper();
        this.helper.setLayoutData((Object)this.helperGridData);
        this.setEnabled(this.enabled);
        this.transferValueToControl(this.value, true);
    }

    public final Label getLabel() {
        return this.label;
    }

    public final GridData getLabelGridData() {
        return this.labelGridData;
    }

    public final GridData getControlGridData() {
        return this.controlGridData;
    }

    public final Control getHelper() {
        return this.helper;
    }

    public final GridData getHelperGridData() {
        return this.helperGridData;
    }

    public final void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
        this.setControlEnabled(enabled);
        Control mainHelper = this.getMainHelper();
        if (mainHelper != null) {
            mainHelper.setEnabled(enabled);
        }
    }

    protected void setControlEnabled(boolean enabled) {
        Control mainControl = this.getMainControl();
        if (mainControl != null) {
            mainControl.setEnabled(enabled);
        }
    }

    protected Control getMainControl() {
        return this.getControl();
    }

    protected Control getMainHelper() {
        return this.helper;
    }

    public abstract Control getControl();

    protected abstract String getControlValue();

    protected abstract void transferValueToControl(String var1, boolean var2);

    protected abstract Control createControl(Composite var1);

    protected Control createHelper(Composite parent) {
        return null;
    }

    private void checkParentLayout(Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            if (gridLayout.numColumns == 3) {
                return;
            }
        }
        throw new IllegalArgumentException("Parent must have a GridLayout with 3 columns");
    }

    private void notifyValueListeners(String oldValue, String newValue) {
        ValueListener[] listeners = (ValueListener[])this.valueListeners.get();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                ValueListener listener = listeners[i];
                try {
                    listener.valueChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        Control mainHelper;
        Control mainControl;
        Label label = this.getLabel();
        if (label != null) {
            label.dispose();
        }
        if ((mainControl = this.getMainControl()) != null) {
            mainControl.dispose();
        }
        if ((mainHelper = this.getMainHelper()) != null) {
            mainHelper.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AuthenticatedField
    extends TextButtonField {
        private Set<Authenticator> authenticators = new LinkedHashSet<Authenticator>();

        public AuthenticatedField() {
            super(true);
            this.setButtonText("Authenticate...");
        }

        public void clear() {
            this.authenticators.clear();
            this.getHelper().setEnabled(false);
        }

        public void addAll(Set<? extends Authenticator> authenticators) {
            this.authenticators.addAll(authenticators);
            this.getHelper().setEnabled(!this.authenticators.isEmpty());
            StringBuilder toolTip = new StringBuilder();
            for (Authenticator authenticator : this.authenticators) {
                if (toolTip.length() != 0) {
                    toolTip.append("\n");
                }
                toolTip.append(authenticator.getMessage(1));
            }
            ((Button)this.getHelper()).setToolTipText(toolTip.toString());
        }

        @Override
        protected void helperButtonSelected(SelectionEvent e) {
            String pluginID = SetupCorePlugin.INSTANCE.getSymbolicName();
            MultiStatus status = new MultiStatus(pluginID, 0, "Authentication Status", null);
            for (Authenticator authenticator : this.authenticators) {
                int severity = authenticator.validate();
                status.add((IStatus)new Status(severity == 0 ? 1 : severity, pluginID, authenticator.getMessage(severity)));
            }
            MultiStatus finalStatus = status;
            switch (status.getSeverity()) {
                case 1: {
                    status = new MultiStatus(pluginID, 0, "The password is successfully authenticated", null);
                    status.addAll((IStatus)finalStatus);
                    break;
                }
                case 2: {
                    status = new MultiStatus(pluginID, 0, "The password cannot be authenticated", null);
                    status.addAll((IStatus)finalStatus);
                    break;
                }
                case 4: {
                    status = new MultiStatus(pluginID, 0, "The password is invalid", null);
                    status.addAll((IStatus)finalStatus);
                }
            }
            ErrorDialog.openError((Shell)this.getHelper().getShell(), (String)"Authentication Status", null, (IStatus)status);
        }
    }

    public static class CheckboxField
    extends PropertyField {
        private TristateCheckbox button;

        public CheckboxField() {
            this(null);
        }

        public CheckboxField(String labelText) {
            super(labelText);
        }

        public Control getControl() {
            return this.button;
        }

        public String getDefaultValue() {
            return "false";
        }

        protected String getControlValue() {
            if (this.button == null) {
                return PropertyField.EMPTY;
            }
            Boolean selection = this.button.getTristateSelection();
            if (selection == null) {
                return PropertyField.EMPTY;
            }
            return selection != false ? "true" : "false";
        }

        protected void transferValueToControl(String value, boolean force) {
            if (this.button != null) {
                Boolean selection = null;
                if (!StringUtil.isEmpty((String)value)) {
                    selection = "true".equalsIgnoreCase(value);
                }
                this.button.setTristateSelection(selection);
            }
        }

        protected Control createControl(Composite parent) {
            this.button = new TristateCheckbox(parent);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String value = CheckboxField.this.getControlValue();
                    if (!value.equals(CheckboxField.this.getValue())) {
                        CheckboxField.this.setValue(value);
                    }
                }
            });
            String toolTip = this.getToolTip();
            if (toolTip != null) {
                this.button.setToolTipText(toolTip);
            }
            return this.button;
        }

        protected String computeLinkedValue(String thisValue, String linkValue) {
            return linkValue;
        }

        private static final class TristateCheckbox
        extends Button {
            private Boolean tristateSelection;

            public TristateCheckbox(Composite parent) {
                super(parent, 32);
                this.setTristateSelection(null);
                this.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (TristateCheckbox.this.tristateSelection == null) {
                            TristateCheckbox.this.tristateSelection = true;
                        } else if (TristateCheckbox.this.tristateSelection.booleanValue()) {
                            TristateCheckbox.this.tristateSelection = false;
                        } else {
                            TristateCheckbox.this.tristateSelection = null;
                        }
                        TristateCheckbox.this.updateTristateSelection();
                    }
                });
            }

            protected void checkSubclass() {
            }

            public void setSelection(boolean selection) {
            }

            public Boolean getTristateSelection() {
                return this.tristateSelection;
            }

            public void setTristateSelection(Boolean selection) {
                this.tristateSelection = selection;
                this.updateTristateSelection();
            }

            private void updateTristateSelection() {
                this.setGrayed(this.tristateSelection == null);
                super.setSelection(!Boolean.FALSE.equals(this.tristateSelection));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerField
    extends TextButtonField {
        private String dialogText;
        private String dialogMessage;

        public ContainerField() {
            this(null, null);
        }

        public ContainerField(String labelText) {
            this(labelText, null);
        }

        public ContainerField(List<? extends VariableChoice> choices) {
            this(null, choices);
        }

        public ContainerField(String labelText, List<? extends VariableChoice> choices) {
            super(labelText, choices);
            this.setButtonText("Browse...");
        }

        public final String getDialogText() {
            return this.dialogText;
        }

        public final void setDialogText(String dialogText) {
            this.dialogText = dialogText;
        }

        public final String getDialogMessage() {
            return this.dialogMessage;
        }

        public final void setDialogMessage(String dialogMessage) {
            this.dialogMessage = dialogMessage;
        }

        @Override
        protected void helperButtonSelected(SelectionEvent e) {
            Shell shell = this.getHelper().getShell();
            Object[] initialSelection = this.getInitialSelection();
            IContainer[] folders = WorkspaceResourceDialog.openFolderSelection((Shell)shell, (String)this.getDialogText(), (String)this.getDialogMessage(), (boolean)false, (Object[])initialSelection, null);
            if (folders.length > 0) {
                this.transferValueToControl(folders[0].getFullPath().toString(), true);
            }
        }

        private Object[] getInitialSelection() {
            try {
                Path path;
                String value = this.getValue();
                if (!StringUtil.isEmpty((String)value) && !(path = new Path(value)).isEmpty()) {
                    if (path.segmentCount() == 1) {
                        return new Object[]{EcorePlugin.getWorkspaceRoot().getProject(path.segment(0))};
                    }
                    return new Object[]{EcorePlugin.getWorkspaceRoot().getFolder((IPath)path)};
                }
            }
            catch (Exception exception) {}
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileField
    extends TextButtonField {
        private String dialogText;

        public FileField() {
            this(null, null);
        }

        public FileField(String labelText) {
            this(labelText, null);
        }

        public FileField(List<? extends VariableChoice> choices) {
            this(null, choices);
        }

        public FileField(String labelText, List<? extends VariableChoice> choices) {
            super(labelText, choices);
            this.setButtonText("Browse...");
        }

        public final String getDialogText() {
            return this.dialogText;
        }

        public final void setDialogText(String dialogText) {
            this.dialogText = dialogText;
        }

        @Override
        protected void helperButtonSelected(SelectionEvent e) {
            String dir;
            String value;
            Shell shell = this.getHelper().getShell();
            FileDialog dialog = new FileDialog(shell);
            if (this.dialogText != null) {
                dialog.setText(this.dialogText);
            }
            if ((value = this.getValue()).length() != 0) {
                dialog.setFilterPath(value);
            }
            if ((dir = dialog.open()) != null) {
                this.transferValueToControl(dir, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FolderField
    extends TextButtonField {
        private String dialogText;
        private String dialogMessage;

        public FolderField() {
            this(null, null);
        }

        public FolderField(String labelText) {
            this(labelText, null);
        }

        public FolderField(List<? extends VariableChoice> choices) {
            this(null, choices);
        }

        public FolderField(String labelText, List<? extends VariableChoice> choices) {
            super(labelText, choices);
            this.setButtonText("Browse...");
        }

        public final String getDialogText() {
            return this.dialogText;
        }

        public final void setDialogText(String dialogText) {
            this.dialogText = dialogText;
        }

        public final String getDialogMessage() {
            return this.dialogMessage;
        }

        public final void setDialogMessage(String dialogMessage) {
            this.dialogMessage = dialogMessage;
        }

        @Override
        protected void helperButtonSelected(SelectionEvent e) {
            String dir;
            String value;
            Shell shell = this.getHelper().getShell();
            DirectoryDialog dialog = new DirectoryDialog(shell);
            if (this.dialogText != null) {
                dialog.setText(this.dialogText);
            }
            if (this.dialogMessage != null) {
                dialog.setMessage(this.dialogMessage);
            }
            if ((value = this.getValue()).length() != 0) {
                try {
                    File existingFolder = IOUtil.getExistingFolder((File)new File(value));
                    if (existingFolder != null) {
                        dialog.setFilterPath(existingFolder.getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex, 2);
                }
            }
            if ((dir = dialog.open()) != null) {
                this.transferValueToControl(dir, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JREField
    extends TextButtonField {
        private JREFilter jreFilter;

        public JREField(JREFilter jreFilter, List<? extends VariableChoice> choices) {
            super(null, JREField.getJREChoices(jreFilter));
            this.jreFilter = jreFilter;
            this.setButtonText("Select...");
        }

        private static List<? extends VariableChoice> getJREChoices(JREFilter jreFilter) {
            ArrayList<VariableChoice> choices = new ArrayList<VariableChoice>();
            Map jres = JREManager.INSTANCE.getJREs(jreFilter);
            for (Map.Entry entry : jres.entrySet()) {
                VariableChoice choice = SetupFactory.eINSTANCE.createVariableChoice();
                String folder = ((File)entry.getKey()).toString();
                choice.setValue(folder);
                JRE jre = (JRE)entry.getValue();
                choice.setLabel(String.valueOf(jre.isJDK() ? "JDK " : "JRE ") + jre.getMajor() + "." + jre.getMinor() + "." + jre.getMicro() + " " + jre.getBitness() + "bit -- " + folder);
                choices.add(choice);
            }
            return choices;
        }

        @Override
        protected void helperButtonSelected(SelectionEvent e) {
            JREController jreController = new JREController(null, null, null){

                protected Shell getShell() {
                    return JREField.this.getHelper().getShell();
                }

                protected JRE getDefaultSelection() {
                    String controlValue = JREField.this.getControlValue();
                    return (JRE)JREManager.INSTANCE.getJREs().get(new File(controlValue));
                }

                protected void jreChanged(JRE jre) {
                    if (jre != null && (JREField.this.jreFilter == null || jre.isMatch(JREField.this.jreFilter))) {
                        JREField.this.transferValueToControl(jre.toString(), true);
                    }
                }

                protected JREFilter createJREFilter() {
                    return JREField.this.jreFilter;
                }
            };
            jreController.refresh();
            jreController.configureJREs();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextButtonField
    extends TextField {
        private String buttonText;

        public TextButtonField() {
        }

        public TextButtonField(boolean secret) {
            super(secret);
        }

        public TextButtonField(String labelText) {
            super(labelText);
        }

        public TextButtonField(String labelText, boolean secret) {
            super(labelText, secret);
        }

        public TextButtonField(String labelText, List<? extends VariableChoice> choices) {
            super(labelText, choices);
        }

        public final String getButtonText() {
            return this.buttonText;
        }

        public final void setButtonText(String buttonText) {
            this.buttonText = buttonText;
        }

        protected Button createHelper(Composite parent) {
            Button button = new Button(parent, 0);
            if (this.buttonText != null) {
                button.setText(this.buttonText);
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextButtonField.this.helperButtonSelected(e);
                }
            });
            return button;
        }

        protected void helperButtonSelected(SelectionEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextField
    extends PropertyField {
        private final boolean secret;
        private PropertyField linkField;
        private Composite mainControl;
        private Text text;
        private ComboViewer comboViewer;
        private ToolItem linkButton;
        private boolean linked = true;
        private List<? extends VariableChoice> choices;
        private FocusHandler focusHandler;

        public TextField() {
            this(null, false);
        }

        public TextField(boolean secret) {
            this(null, secret);
        }

        public TextField(String labelText) {
            this(labelText, false);
        }

        public TextField(String labelText, boolean secret) {
            this(labelText, secret, null);
        }

        public TextField(List<? extends VariableChoice> choices) {
            this(null, choices);
        }

        public TextField(String labelText, List<? extends VariableChoice> choices) {
            this(labelText, false, choices);
        }

        private TextField(String labelText, boolean secret, List<? extends VariableChoice> choices) {
            super(labelText);
            this.secret = secret;
            this.choices = choices;
        }

        @Override
        public String getDefaultValue() {
            return this.choices == null || this.choices.isEmpty() ? PropertyField.EMPTY : this.choices.get(0).getValue();
        }

        public final PropertyField getLinkField() {
            return this.linkField;
        }

        public final void setLinkField(PropertyField field) {
            this.linkField = field;
        }

        public final boolean isLinked() {
            return this.linked;
        }

        public final void setLinked(boolean linked) {
            this.linked = linked;
            if (this.linkButton != null) {
                String path = linked ? "linked.gif" : "icons/unlinked";
                Image image = SetupUIPlugin.INSTANCE.getSWTImage(path);
                this.linkButton.setImage(image);
                this.linkButton.setSelection(linked);
                if (linked) {
                    this.setLinkedValue(this.linkField.getValue());
                }
            }
        }

        public final void setLinkedFromValue() {
            String thisValue = this.getValue();
            String linkValue = this.linkField.getValue();
            this.setLinked(thisValue.length() == 0 && linkValue.length() == 0 || thisValue.equals(this.computeLinkedValue(thisValue, linkValue)));
        }

        @Override
        protected Control getMainControl() {
            if (this.mainControl != null) {
                return this.mainControl;
            }
            return super.getMainControl();
        }

        @Override
        public Control getControl() {
            return this.text != null ? this.text : this.comboViewer.getCombo();
        }

        protected ComboViewer getComboViewer() {
            return this.comboViewer;
        }

        @Override
        protected String getControlValue() {
            return this.text != null ? (this.secret ? PreferencesUtil.encrypt((String)this.text.getText()) : this.text.getText()) : this.comboViewer.getCombo().getText();
        }

        @Override
        protected void transferValueToControl(String value, boolean force) {
            if (this.text != null) {
                String actualValue;
                String string = actualValue = this.secret ? PreferencesUtil.decrypt((String)value) : value;
                if (!force && this.text.isFocusControl()) {
                    if (this.focusHandler == null) {
                        this.focusHandler = new FocusHandler();
                        this.text.addFocusListener((FocusListener)this.focusHandler);
                    }
                    this.focusHandler.setValue(actualValue);
                } else {
                    this.text.setText(actualValue);
                }
            } else {
                this.comboViewer.getCombo().setText(value);
                this.updateToolTip(value);
            }
        }

        private void updateToolTip(String value) {
            if (!StringUtil.isEmpty((String)value)) {
                for (VariableChoice variableChoice : this.choices) {
                    if (!value.equals(variableChoice.getValue())) continue;
                    this.comboViewer.getCombo().setToolTipText(variableChoice.getLabel());
                    return;
                }
            }
            String string = this.getToolTip();
            this.comboViewer.getCombo().setToolTipText(string == null ? PropertyField.EMPTY : string);
        }

        @Override
        protected Control createControl(Composite parent) {
            if (this.linkField == null) {
                return this.createControlHelper(parent);
            }
            GridLayout mainLayout = new GridLayout(2, false);
            mainLayout.marginWidth = 0;
            mainLayout.marginHeight = 0;
            mainLayout.horizontalSpacing = 0;
            this.mainControl = new Composite(parent, 0){

                public void setEnabled(boolean enabled) {
                    if (TextField.this.text != null) {
                        TextField.this.text.setEnabled(enabled);
                    } else {
                        super.setEnabled(enabled);
                        Control[] children = this.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            Control child = children[i];
                            child.setEnabled(enabled);
                            ++i;
                        }
                    }
                }
            };
            this.mainControl.setLayout((Layout)mainLayout);
            Control control = this.createControlHelper(this.mainControl);
            control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            ToolBar toolBar = new ToolBar(this.mainControl, 0x880000);
            toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.linkButton = new ToolItem(toolBar, 8);
            this.linkButton.setToolTipText("Link with the '" + this.linkField.getLabelText() + "' field");
            this.linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextField.this.setLinked(!TextField.this.linked);
                }
            });
            this.linkField.addValueListener(new ValueListener(){

                public void valueChanged(String oldValue, String newValue) throws Exception {
                    if (TextField.this.linked) {
                        TextField.this.setLinkedValue(newValue);
                    }
                }
            });
            this.setLinkedFromValue();
            return control;
        }

        protected String computeLinkedValue(String thisValue, String linkValue) {
            return linkValue;
        }

        private void setLinkedValue(String newValue) {
            String thisValue = this.getValue();
            String value = this.computeLinkedValue(thisValue, newValue);
            this.setValue(value);
        }

        private Control createControlHelper(Composite parent) {
            return this.choices == null || this.choices.isEmpty() ? this.createText(parent) : this.createCombo(parent);
        }

        private Text createText(Composite parent) {
            int style = 2048;
            if (this.secret) {
                style |= 0x400000;
            }
            this.text = this.createText(parent, style);
            String toolTip = this.getToolTip();
            if (toolTip != null) {
                this.text.setToolTipText(toolTip);
            }
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String value = TextField.this.text.getText();
                    if (TextField.this.secret) {
                        value = PreferencesUtil.encrypt((String)value);
                    }
                    if (!value.equals(TextField.this.getValue())) {
                        TextField.this.setValue(value);
                        if (TextField.this.linkButton != null && TextField.this.linked) {
                            TextField.this.setLinkedFromValue();
                        }
                    }
                }
            });
            return this.text;
        }

        protected Text createText(Composite parent, int style) {
            return new Text(parent, style);
        }

        protected Combo createCombo(Composite parent) {
            this.comboViewer = new ComboViewer(parent, 2048);
            final LabelProvider labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    VariableChoice choice = (VariableChoice)element;
                    return choice.getLabel();
                }
            };
            this.comboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboViewer.setInput(this.choices);
            this.comboViewer.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String value = TextField.this.comboViewer.getCombo().getText();
                    TextField.this.setValue(value);
                    TextField.this.updateToolTip(value);
                }
            });
            this.comboViewer.getCombo().addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.character == '\u0000') {
                        for (VariableChoice choice : TextField.this.choices) {
                            if (!labelProvider.getText((Object)choice).equals(e.text)) continue;
                            e.text = choice.getValue();
                            break;
                        }
                    }
                }
            });
            Combo control = this.comboViewer.getCombo();
            control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            return control;
        }

        private class FocusHandler
        extends FocusAdapter {
            private String value;

            private FocusHandler() {
            }

            public void focusLost(FocusEvent e) {
                TextField.this.focusHandler = null;
                TextField.this.text.removeFocusListener((FocusListener)this);
                if (TextField.this.text.getText().length() == 0) {
                    TextField.this.text.setText(this.value);
                }
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    public static interface ValueListener {
        public void valueChanged(String var1, String var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueListenerArray
    extends ConcurrentArray<ValueListener> {
        private ValueListenerArray() {
        }

        protected ValueListener[] newArray(int length) {
            return new ValueListener[length];
        }
    }
}

