/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.graphics.FontData;
import org.osgi.framework.BundleContext;

public final class SetupInstallerPlugin
extends OomphUIPlugin {
    public static final SetupInstallerPlugin INSTANCE = new SetupInstallerPlugin();
    public static final String FONT_OPEN_SANS = "font-open-sans";
    public static final String FONT_LABEL_DEFAULT = "font-open-sans.label-default";
    private static Implementation plugin;

    public SetupInstallerPlugin() {
        super(new ResourceLocator[]{SetupUIPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            if (!PropertiesUtil.isProperty((String)"headless.startup")) {
                this.initializeFonts();
                File temporaryIconsFolder = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()) + ".oomph.icons");
                temporaryIconsFolder.mkdir();
                temporaryIconsFolder.deleteOnExit();
                ReflectUtil.setValue((String)"imageDirectory", (Object)ImageURIRegistry.INSTANCE, (Object)temporaryIconsFolder);
            }
        }

        private void initializeFonts() {
            FontData[] fontData = JFaceResources.getDefaultFont().getFontData();
            int height = fontData == null || fontData.length == 0 ? 9 : (int)fontData[0].height;
            this.loadFont("/fonts/OpenSans-Regular.ttf");
            JFaceResources.getFontRegistry().put(SetupInstallerPlugin.FONT_LABEL_DEFAULT, new FontData[]{new FontData("Open Sans", height, 1)});
        }

        private boolean loadFont(String path) {
            try {
                URL url = new URL("platform:/plugin/" + INSTANCE.getSymbolicName() + path);
                URL fileURL = FileLocator.toFileURL((URL)url);
                String filePath = fileURL.getPath();
                File file = new File(filePath);
                return UIUtil.getDisplay().loadFont(file.toString());
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
    }
}

