/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.internal.ui.ImageCheckbox;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.ui.JREController;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.setup.AttributeRule;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerUtil;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleCheckbox;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallLaunchButton;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.setup.internal.installer.SimpleMessageOverlay;
import org.eclipse.oomph.setup.internal.installer.SimpleProductPage;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.ui.JREDownloadHandler;
import org.eclipse.oomph.setup.ui.LicensePrePrompter;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.UnsignedContentDialog;
import org.eclipse.oomph.setup.ui.wizards.ProductPage;
import org.eclipse.oomph.setup.ui.wizards.ProgressPage;
import org.eclipse.oomph.ui.StackComposite;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.Request;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SimpleVariablePage
extends SimpleInstallerPage {
    public static final int PROGRESS_WATCHDOG_TIMEOUT = PropertiesUtil.getProperty((String)"oomph.progress.watchdog.timeout", (int)15);
    private static final boolean EXIT_AFTER_LAUNCH = !PropertiesUtil.isProperty((String)"oomph.no.exit.after.launch");
    private static final OomphPlugin.Preference PREF_STARTMENU_ENTRY = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("startMenuEntry");
    private static final OomphPlugin.Preference PREF_DESKTOP_SHORTCUT = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("desktopShortcut");
    private static final OomphPlugin.Preference PREF_INSTALL_ROOT = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("installRoot");
    private static final File FILE_INSTALL_ROOT = new File(SetupInstallerPlugin.INSTANCE.getUserLocation().toFile(), String.valueOf(PREF_INSTALL_ROOT.key()) + ".txt");
    private static final String TEXT_README = "show readme file";
    private static final String TEXT_KEEP = "keep installer";
    private static final String MESSAGE_SUCCESS = "Installation completed successfully.";
    private static final String MESSAGE_FAILURE = "Installation failed with an error.";
    protected static final boolean JRE_CHOICE = Boolean.valueOf(PropertiesUtil.getProperty((String)"oomph.setup.jre.choice", (String)"true"));
    private final Map<String, ProductVersion> productVersions = new HashMap<String, ProductVersion>();
    private Product product;
    private ProductVersion selectedProductVersion;
    private String readmePath;
    private Browser detailBrowser;
    private SimpleProductPage.ProductComposite detailComposite;
    private CCombo versionCombo;
    private Label versionLabel;
    private Control versionSpacer;
    private ImageCheckbox bitness32Button;
    private ImageCheckbox bitness64Button;
    private Label bitness32Spacer;
    private Label bitness64Spacer;
    private JREController javaController;
    private Label javaLabel;
    private Control javaSpacer;
    private ComboViewer javaViewer;
    private FlatButton javaButton;
    private Control javaTrailingSpacer;
    private Text folderText;
    private FlatButton folderButton;
    private String installRoot;
    private String installFolder;
    private Thread installThread;
    private StackComposite installStack;
    private SimpleInstallLaunchButton installButton;
    private String installError;
    private boolean installed;
    private SetupTaskPerformer performer;
    private SimpleProgress progress;
    private FlatButton cancelButton;
    private FlatButton showReadmeButton;
    private FlatButton keepInstallerButton;
    private Composite afterInstallComposite;
    private Composite errorComposite;
    private Composite container;
    private SimpleCheckbox createStartMenuEntryButton;
    private SimpleCheckbox createDesktopShortcutButton;

    public SimpleVariablePage(Composite parent, SimpleInstallerDialog dialog) {
        super(parent, dialog, true);
    }

    protected void createContent(Composite container) {
        this.container = container;
        container.setBackgroundMode(2);
        container.setBackground(AbstractSimpleDialog.COLOR_WHITE);
        String powerShell = KeepInstallerUtil.getPowerShell();
        GridData browserLayoutData = GridDataFactory.fillDefaults().indent(0, 13).grab(true, false).create();
        Point defaultSize = SimpleInstallerDialog.getDefaultSize((Drawable)container);
        browserLayoutData.heightHint = defaultSize.y * (powerShell != null ? 20 : 34) / 100;
        Composite detailArea = new Composite(container, 0);
        detailArea.setLayoutData((Object)browserLayoutData);
        detailArea.setLayout((Layout)new FillLayout());
        if (UIUtil.isBrowserAvailable()) {
            this.detailBrowser = new Browser(detailArea, 16);
            this.detailBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent event) {
                    String url = event.location;
                    if (!"about:blank".equals(url)) {
                        OS.INSTANCE.openSystemBrowser(url);
                        event.doit = false;
                    }
                }
            });
        } else {
            this.detailBrowser = null;
            this.detailComposite = new SimpleProductPage.ProductComposite(detailArea, null, null);
        }
        Composite variablesComposite = new Composite(container, 0);
        GridLayout variablesLayout = new GridLayout(5, false);
        variablesLayout.horizontalSpacing = 8;
        variablesLayout.verticalSpacing = 3;
        variablesLayout.marginLeft = 14;
        variablesLayout.marginRight = 30;
        variablesLayout.marginTop = 24;
        variablesLayout.marginBottom = 0;
        variablesLayout.marginHeight = 0;
        variablesComposite.setLayout((Layout)variablesLayout);
        variablesComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.versionLabel = this.createLabel(variablesComposite, "Product Version");
        this.versionSpacer = SimpleVariablePage.spacer(variablesComposite);
        this.versionSpacer.setLayoutData((Object)GridDataFactory.swtDefaults().hint(17, -1).create());
        this.versionCombo = this.createComboBox(variablesComposite, 8);
        this.versionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String label = SimpleVariablePage.this.versionCombo.getItem(SimpleVariablePage.this.versionCombo.getSelectionIndex());
                SimpleVariablePage.this.productVersionSelected((ProductVersion)SimpleVariablePage.this.productVersions.get(label));
                UIUtil.clearTextSelection((Object)SimpleVariablePage.this.versionCombo);
            }
        });
        if (JREManager.BITNESS_CHANGEABLE) {
            this.bitness32Button = new ImageCheckbox(variablesComposite, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/32bit.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/32bit_hover.png"));
            this.bitness32Button.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).indent(4, 0).hint(-1, 30).create());
            this.bitness32Button.setChecked(false);
            this.bitness32Button.setVisible(JREManager.BITNESS_CHANGEABLE);
            this.bitness32Button.setToolTipText("Create a 32 bit installation");
            this.bitness32Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleVariablePage.this.bitness32Button.setChecked(true);
                    SimpleVariablePage.this.bitness64Button.setChecked(false);
                    SimpleVariablePage.this.javaController.setBitness(32);
                }
            });
            this.bitness64Button = new ImageCheckbox(variablesComposite, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/64bit.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/64bit_hover.png"));
            this.bitness64Button.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).hint(-1, 30).create());
            this.bitness64Button.setChecked(true);
            this.bitness64Button.setVisible(JREManager.BITNESS_CHANGEABLE);
            this.bitness64Button.setToolTipText("Create a 64 bit installation");
            this.bitness64Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleVariablePage.this.bitness32Button.setChecked(false);
                    SimpleVariablePage.this.bitness64Button.setChecked(true);
                    SimpleVariablePage.this.javaController.setBitness(64);
                }
            });
        } else {
            this.bitness32Spacer = new Label(variablesComposite, 0);
            this.bitness64Spacer = new Label(variablesComposite, 0);
        }
        this.javaLabel = this.createLabel(variablesComposite, "Java VM");
        this.javaSpacer = SimpleVariablePage.spacer(variablesComposite);
        final CCombo javaCombo = this.createComboBox(variablesComposite, 8);
        this.javaViewer = new ComboViewer(javaCombo);
        this.javaViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.javaViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.javaViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UIUtil.setSelectionToEnd((Widget)javaCombo);
            }
        });
        this.javaButton = new ImageHoverButton(variablesComposite, 8, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder_hover.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder_disabled.png"));
        this.javaButton.setLayoutData((Object)GridDataFactory.swtDefaults().indent(4, 0).create());
        this.javaButton.setToolTipText("Select a Java VM");
        this.javaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleVariablePage.this.javaController.configureJREs();
            }
        });
        JREDownloadHandler downloadHandler = new JREDownloadHandler(){

            protected Product getProduct() {
                return SimpleVariablePage.this.product;
            }
        };
        this.javaController = new JREController(this.javaLabel, (StructuredViewer)this.javaViewer, (Request.Handler)downloadHandler){

            protected void modelEmpty(boolean empty) {
                super.modelEmpty(empty);
                SimpleVariablePage.this.validatePage();
            }

            protected void jreChanged(JRE jre) {
                super.jreChanged(jre);
                SimpleVariablePage.this.validatePage();
                javaCombo.setToolTipText(jre == null ? null : jre.getJavaHome().toString());
            }

            protected void setLabel(String text) {
                super.setLabel(String.valueOf(text) + " ");
            }
        };
        this.javaTrailingSpacer = SimpleVariablePage.spacer(variablesComposite);
        this.createLabel(variablesComposite, "Installation Folder");
        SimpleVariablePage.spacer(variablesComposite);
        this.folderText = this.createTextField(variablesComposite);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                final FocusListener focusSelectionAdapter = (FocusListener)SimpleVariablePage.this.folderText.getData("focusSelectionAdapter");
                UIUtil.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SimpleVariablePage.this.folderText.removeFocusListener(focusSelectionAdapter);
                    }
                });
                UIUtil.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SimpleVariablePage.this.validatePage();
                    }
                });
                UIUtil.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SimpleVariablePage.this.folderText.setFocus();
                    }
                });
                UIUtil.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SimpleVariablePage.this.folderText.addFocusListener(focusSelectionAdapter);
                    }
                });
                SimpleVariablePage.this.folderText.setToolTipText(SimpleVariablePage.this.installFolder);
            }
        });
        this.folderButton = new ImageHoverButton(variablesComposite, 8, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder_hover.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder_disabled.png"));
        this.folderButton.setLayoutData((Object)GridDataFactory.swtDefaults().indent(4, 0).create());
        this.folderButton.setToolTipText("Select an installation folder");
        this.folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog dialog = new DirectoryDialog(SimpleVariablePage.this.getShell());
                dialog.setText("Eclipse Installer");
                dialog.setMessage("Select an installation folder:");
                if (!StringUtil.isEmpty((String)SimpleVariablePage.this.installFolder)) {
                    try {
                        File existingFolder = IOUtil.getExistingFolder((File)new File(SimpleVariablePage.this.installFolder));
                        if (existingFolder != null) {
                            dialog.setFilterPath(existingFolder.getAbsolutePath());
                        }
                    }
                    catch (Exception ex) {
                        SetupInstallerPlugin.INSTANCE.log(ex, 2);
                    }
                }
                if ((dir = dialog.open()) != null) {
                    SimpleVariablePage.this.validatePage();
                    SimpleVariablePage.this.setFolderText(dir);
                }
            }
        });
        if (powerShell != null) {
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            this.createStartMenuEntryButton = this.createCheckbox(variablesComposite, "create start menu entry");
            this.createStartMenuEntryButton.setChecked(PREF_STARTMENU_ENTRY.get(true));
            this.createStartMenuEntryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PREF_STARTMENU_ENTRY.set(SimpleVariablePage.this.createStartMenuEntryButton.isChecked());
                }
            });
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            SimpleVariablePage.spacer(variablesComposite);
            this.createDesktopShortcutButton = this.createCheckbox(variablesComposite, "create desktop shortcut");
            this.createDesktopShortcutButton.setChecked(PREF_DESKTOP_SHORTCUT.get(true));
            this.createDesktopShortcutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PREF_DESKTOP_SHORTCUT.set(SimpleVariablePage.this.createDesktopShortcutButton.isChecked());
                }
            });
            SimpleVariablePage.spacer(variablesComposite);
        }
        SimpleVariablePage.spacer(variablesComposite);
        SimpleVariablePage.spacer(variablesComposite);
        SimpleVariablePage.spacer(variablesComposite);
        this.installButton = new SimpleInstallLaunchButton(variablesComposite);
        Point defaultInstallButtonSize = this.installButton.computeSize(-1, -1);
        this.installButton.setLayoutData(GridDataFactory.swtDefaults().align(4, 1).hint(-1, defaultInstallButtonSize.y + 3).indent(0, 32).create());
        this.installButton.setCurrentState(SimpleInstallLaunchButton.State.INSTALL);
        SimpleVariablePage.spacer(variablesComposite);
        SimpleVariablePage.spacer(variablesComposite);
        SimpleVariablePage.spacer(variablesComposite);
        SimpleVariablePage.spacer(variablesComposite);
        this.installStack = new StackComposite(variablesComposite, 0);
        this.installStack.setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, 72).create());
        final Composite duringInstallContainer = new Composite((Composite)this.installStack, 0);
        duringInstallContainer.setLayout((Layout)UIUtil.createGridLayout((int)1));
        this.cancelButton = this.createButton(duringInstallContainer, "Cancel Installation", "Cancel", SetupInstallerPlugin.INSTANCE.getSWTImage("simple/delete.png"));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleVariablePage.this.installCancel();
            }
        });
        GridLayout afterInstallLayout = UIUtil.createGridLayout((int)1);
        afterInstallLayout.verticalSpacing = 3;
        this.afterInstallComposite = new Composite((Composite)this.installStack, 0);
        this.afterInstallComposite.setLayout((Layout)afterInstallLayout);
        this.showReadmeButton = this.createButton(this.afterInstallComposite, TEXT_README, null, null);
        this.showReadmeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleVariablePage.this.readmePath != null) {
                    String relativeProductFolder = SimpleVariablePage.this.performer.getRelativeProductFolder();
                    java.net.URI readmeURI = new File(SimpleVariablePage.this.installFolder, String.valueOf(relativeProductFolder) + "/" + SimpleVariablePage.this.readmePath).toURI();
                    SimpleVariablePage.this.dialog.showReadme(readmeURI);
                }
            }
        });
        this.showReadmeButton.setToolTipText("Show the readme file of the installed product");
        this.keepInstallerButton = this.createButton(this.afterInstallComposite, TEXT_KEEP, null, null);
        this.keepInstallerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleVariablePage.this.dialog.showKeepInstaller();
            }
        });
        this.keepInstallerButton.setToolTipText("Copy the installer to a permanent location on your disk in order to remember your settings and support self updates");
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleVariablePage.this.installed) {
                    SimpleVariablePage.this.launchProduct();
                } else {
                    SimpleVariablePage.this.dialog.clearMessage();
                    SimpleVariablePage.this.dialog.setButtonsEnabled(false);
                    SimpleVariablePage.this.setEnabled(false);
                    SimpleVariablePage.this.installButton.setCurrentState(SimpleInstallLaunchButton.State.INSTALLING);
                    SimpleVariablePage.this.installButton.setProgress(0.0f);
                    SimpleVariablePage.this.installStack.setTopControl((Control)duringInstallContainer);
                    SimpleVariablePage.this.installStack.setVisible(true);
                    SimpleVariablePage.this.layout(true, true);
                    SimpleVariablePage.this.forceFocus();
                    SimpleVariablePage.this.install();
                }
            }
        });
        GridLayout errorLayout = UIUtil.createGridLayout((int)1);
        errorLayout.verticalSpacing = 0;
        this.errorComposite = new Composite((Composite)this.installStack, 0);
        this.errorComposite.setLayout((Layout)errorLayout);
        ArrayList<Control> tabList = new ArrayList<Control>(Arrays.asList(container.getTabList()));
        tabList.remove(detailArea);
        container.setTabList(tabList.toArray(new Control[tabList.size()]));
    }

    protected void backSelected() {
        if (this.promptLaunchProduct("You're about to install another product")) {
            super.backSelected();
        }
    }

    public boolean promptLaunchProduct(String currentAction) {
        if (this.installButton != null && this.installButton.getCurrentState() == SimpleInstallLaunchButton.State.LAUNCH) {
            MessageDialog prompt = new MessageDialog((Shell)this.dialog, "Launch Product", null, String.valueOf(currentAction) + " without having launched the installed product.\n\nDo you want to launch it now?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int result = prompt.open();
            if (result == 0) {
                this.launchProduct(false);
                return true;
            }
            return result == 1;
        }
        return true;
    }

    private FlatButton createButton(Composite parent, String text, String toolTip, Image icon) {
        FlatButton button = new FlatButton(parent, 8);
        button.setBackground(AbstractSimpleDialog.COLOR_LIGHTEST_GRAY);
        button.setText(text);
        button.setCornerWidth(10);
        button.setAlignment(0x1000000);
        button.setFont(SimpleInstallerDialog.getFont(1, "normal"));
        button.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(-1, 22).create());
        button.setForeground(AbstractSimpleDialog.COLOR_LABEL_FOREGROUND);
        if (icon != null) {
            button.setImage(icon);
        }
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
        return button;
    }

    protected void productVersionSelected(ProductVersion productVersion) {
        if (this.selectedProductVersion != productVersion) {
            this.selectedProductVersion = productVersion;
            String requiredJavaVersion = productVersion.getRequiredJavaVersion();
            this.javaController.setJavaVersion(requiredJavaVersion);
            ProductPage.saveProductVersionSelection((CatalogManager)this.installer.getCatalogManager(), (ProductVersion)this.selectedProductVersion);
            this.versionCombo.setToolTipText(ProductPage.getToolTipText((ProductVersion)this.selectedProductVersion));
        }
        this.installFolder = this.getDefaultInstallationFolder();
        this.setFolderText(this.installFolder);
    }

    public boolean setFocus() {
        boolean focused = this.folderText.setFocus();
        UIUtil.setSelectionToEnd((Widget)this.folderText);
        return focused;
    }

    public void setProduct(Product product) {
        this.product = product;
        if (this.detailBrowser != null) {
            String html = SimpleInstallerDialog.getPageTemplate();
            html = html.replace("%CONTENT%", SimpleProductPage.renderProduct(product, true));
            this.detailBrowser.setText(html, true);
        } else {
            this.detailComposite.setProduct(product);
        }
        this.productVersions.clear();
        this.versionCombo.removeAll();
        ProductVersion defaultProductVersion = ProductPage.getDefaultProductVersion((CatalogManager)this.installer.getCatalogManager(), (Product)product);
        int i = 0;
        int selection = 0;
        List validProductVersions = ProductPage.getValidProductVersions((Product)product, (Pattern)PRODUCT_VERSION_FILTER);
        for (ProductVersion productVersion : validProductVersions) {
            if (defaultProductVersion == null || !validProductVersions.contains(defaultProductVersion)) {
                defaultProductVersion = productVersion;
            }
            String label = SetupCoreUtil.getLabel((Scope)productVersion);
            this.productVersions.put(label, productVersion);
            this.versionCombo.add(label);
            if (productVersion == defaultProductVersion) {
                selection = i;
            }
            ++i;
        }
        this.versionCombo.select(selection);
        this.productVersionSelected(defaultProductVersion);
        UIUtil.setSelectionToEnd((Widget)this.versionCombo);
        this.installButton.setCurrentState(SimpleInstallLaunchButton.State.INSTALL);
        this.installStack.setVisible(false);
        this.installed = false;
        UIUtil.asyncExec((Control)this.container, (Runnable)new Runnable(){

            public void run() {
                SimpleVariablePage.this.setEnabled(true);
            }
        });
    }

    private void setVisible(Control control, boolean visible) {
        if (control != null) {
            control.setVisible(visible);
            Object layoutData = control.getLayoutData();
            if (layoutData == null) {
                layoutData = new GridData();
                control.setLayoutData(layoutData);
            }
            if (layoutData instanceof GridData) {
                GridData gridData = (GridData)layoutData;
                gridData.exclude = !visible;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.versionCombo.setEnabled(enabled);
        this.javaViewer.getControl().setEnabled(enabled);
        this.javaButton.setEnabled(enabled);
        this.folderText.setEnabled(enabled);
        this.folderButton.setEnabled(enabled);
        if (this.createStartMenuEntryButton != null) {
            this.createStartMenuEntryButton.setEnabled(enabled);
        }
        if (this.createDesktopShortcutButton != null) {
            this.createDesktopShortcutButton.setEnabled(enabled);
        }
        boolean versionVisible = this.versionCombo.getItemCount() != 1;
        this.setVisible((Control)this.versionLabel, versionVisible);
        this.setVisible(this.versionSpacer, versionVisible);
        this.setVisible((Control)this.versionCombo.getParent(), versionVisible);
        this.setVisible((Control)this.bitness32Button, versionVisible);
        this.setVisible((Control)this.bitness64Button, versionVisible);
        this.setVisible((Control)this.bitness32Spacer, versionVisible);
        this.setVisible((Control)this.bitness64Spacer, versionVisible);
        if (JREManager.BITNESS_CHANGEABLE) {
            int bitness = this.javaController.getBitness();
            this.bitness32Button.setEnabled(enabled);
            this.bitness32Button.setVisible(versionVisible && (enabled || bitness == 32));
            this.bitness64Button.setEnabled(enabled);
            this.bitness64Button.setVisible(versionVisible && (enabled || bitness == 64));
        }
        IStructuredSelection structuredSelection = this.javaViewer.getStructuredSelection();
        boolean javaVisible = JRE_CHOICE || !(structuredSelection.getFirstElement() instanceof JRE);
        this.setVisible((Control)this.javaLabel, javaVisible);
        this.setVisible(this.javaSpacer, javaVisible);
        this.setVisible((Control)this.javaViewer.getCCombo().getParent(), javaVisible);
        this.setVisible((Control)this.javaButton, javaVisible);
        this.setVisible(this.javaTrailingSpacer, javaVisible);
        this.container.layout(true, true);
    }

    public boolean refreshJREs() {
        if (this.javaController != null) {
            this.javaController.refresh();
            return true;
        }
        return false;
    }

    private String getDefaultInstallationFolder() {
        String name = this.product.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(lastDot + 1);
        }
        name = String.valueOf(name) + "-" + this.selectedProductVersion.getName().replace('.', '-');
        if (this.installRoot == null) {
            List lines;
            if (FILE_INSTALL_ROOT.isFile() && (lines = IOUtil.readLines((File)FILE_INSTALL_ROOT, (String)"UTF-8")) != null && !lines.isEmpty()) {
                this.installRoot = (String)lines.get(0);
                if (this.installRoot.length() == 0) {
                    this.installRoot = null;
                }
            }
            if (this.installRoot == null) {
                String defaultValue = PropertiesUtil.USER_HOME;
                File defaultInstallRoot = new File(defaultValue, "eclipse");
                if (!defaultInstallRoot.exists()) {
                    defaultValue = defaultInstallRoot.toString();
                } else if (defaultInstallRoot.isDirectory()) {
                    boolean isEclipseInstallation = false;
                    File[] fileArray = defaultInstallRoot.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if ("eclipse.ini".equals(file.getName())) {
                            isEclipseInstallation = true;
                        }
                        ++n2;
                    }
                    if (!isEclipseInstallation) {
                        defaultValue = defaultInstallRoot.toString();
                    }
                }
                this.installRoot = PREF_INSTALL_ROOT.get(defaultValue);
            }
        }
        int i = 1;
        while (i < 1000) {
            File folder;
            String filename = name;
            if (i != 1) {
                filename = String.valueOf(filename) + i;
            }
            if (!(folder = new File(this.installRoot, filename)).exists()) {
                return folder.getAbsolutePath();
            }
            ++i;
        }
        throw new IllegalStateException("User home is full");
    }

    private void install() {
        this.installThread = new Thread(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        this.installThread.setDaemon(true);
        this.installThread.start();
    }

    private void installPerform() throws Exception {
        if (this.dialog.getPool() != null) {
            P2Util.getAgentManager().setDefaultBundlePool(SetupUIPlugin.INSTANCE.getSymbolicName(), this.dialog.getPool());
            System.setProperty("oomph.p2.pool", this.dialog.getPool().getLocation().getAbsolutePath());
        } else {
            System.clearProperty("oomph.p2.pool");
        }
        JRE jre = this.javaController.getJRE();
        String vmPath = ProductPage.getVMOption((JRE)jre);
        ResourceSet resourceSet = this.installer.getResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        SetupContext setupContext = SetupContext.create((ResourceSet)resourceSet, (ProductVersion)this.selectedProductVersion);
        Installation installation = setupContext.getInstallation();
        final User user = setupContext.getUser();
        if (UIUtil.isBrowserAvailable()) {
            UIUtil.syncExec((Runnable)new Runnable(){

                public void run() {
                    EList licenses = LicensePrePrompter.execute((Shell)SimpleVariablePage.this.getShell(), (User)user);
                    if (licenses != null) {
                        user.getAcceptedLicenses().addAll((Collection)licenses);
                        BaseUtil.saveEObject((EObject)user);
                    }
                }
            });
        }
        UserAdjuster userAdjuster = new UserAdjuster();
        userAdjuster.adjust(user, this.installFolder);
        try {
            IOUtil.writeLines((File)FILE_INSTALL_ROOT, (String)"UTF-8", Collections.singletonList(this.installRoot));
            SimplePrompter prompter = new SimplePrompter();
            this.performer = SetupTaskPerformer.create((URIConverter)uriConverter, (SetupPrompter)prompter, (Trigger)Trigger.BOOTSTRAP, (SetupContext)setupContext, (boolean)false);
            final List<VariableTask> unresolvedVariables = prompter.getUnresolvedVariables();
            if (!unresolvedVariables.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (VariableTask variable : unresolvedVariables) {
                    if (builder.length() != 0) {
                        builder.append(", ");
                    }
                    builder.append(variable.getName());
                }
                final String variables = builder.toString();
                final boolean multi = unresolvedVariables.size() > 1;
                UIUtil.syncExec((Runnable)new Runnable(){

                    public void run() {
                        String message = "The variable" + (multi ? "s" : "") + " " + variables + " " + (multi ? "are" : "is") + " undefined. You likely declared " + (multi ? "them" : "it") + " in your 'user.setup' file without appropriate restrictions, so that you can't use the installer's simple mode anymore." + "\n\nDo you want to switch to the advanced mode now?";
                        if (MessageDialog.openQuestion((Shell)SimpleVariablePage.this.getShell(), (String)"Undefined Variables", (String)message)) {
                            unresolvedVariables.clear();
                            SimpleVariablePage.this.dialog.switchToAdvancedMode();
                        }
                    }
                });
                if (unresolvedVariables.isEmpty()) {
                    return;
                }
                throw new UnloggedException("Undefined variable" + (multi ? "s" : "") + ": " + variables);
            }
            this.performer.getUnresolvedVariables().clear();
            this.performer.put(ILicense.class, (Object)ProgressPage.LICENSE_CONFIRMER);
            this.performer.put(Certificate.class, (Object)UnsignedContentDialog.createUnsignedContentConfirmer((User)user, (boolean)false));
            this.performer.put(OS.class, (Object)OS.INSTANCE.getForBitness(this.javaController.getBitness()));
            this.performer.setOffline(false);
            this.performer.setMirrors(true);
            this.performer.setVMPath(vmPath);
            this.performer.setProgress((ProgressLog)this.progress);
            this.performer.log("Executing " + this.performer.getTrigger().toString().toLowerCase() + " tasks");
            this.performer.perform((IProgressMonitor)this.progress);
            this.performer.recordVariables(installation, null, user);
            this.performer.savePasswords();
            File configurationLocation = this.performer.getProductConfigurationLocation();
            installation.eResource().setURI(URI.createFileURI((String)new File(configurationLocation, "org.eclipse.oomph.setup/installation.setup").toString()));
            BaseUtil.saveEObject((EObject)installation);
        }
        finally {
            userAdjuster.undo();
            BaseUtil.saveEObject((EObject)user);
        }
    }

    private void installCancel() {
        if (this.progress != null) {
            this.progress.setCanceled(true);
        }
        if (this.installThread != null) {
            this.installThread.interrupt();
        }
        this.dialog.setButtonsEnabled(true);
        this.setEnabled(true);
        this.installButton.setCurrentState(SimpleInstallLaunchButton.State.INSTALL);
        this.installStack.setVisible(false);
        this.dialog.clearMessage();
    }

    private void installFinished() {
        ProductVersion productVersion;
        Installation installation;
        this.readmePath = null;
        if (this.performer != null && (installation = this.performer.getInstallation()) != null && (productVersion = installation.getProductVersion()) != null) {
            SetupCoreUtil.sendStats((Scope)productVersion, (this.installError == null ? 1 : 0) != 0);
        }
        if (this.installError == null) {
            this.installed = true;
            this.installButton.setCurrentState(SimpleInstallLaunchButton.State.LAUNCH);
            this.installButton.setToolTipText("Launch");
            this.keepInstallerButton.setVisible(KeepInstallerUtil.canKeepInstaller());
            ProductVersion scope = this.selectedProductVersion;
            while (scope != null) {
                Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                if (annotation != null) {
                    this.readmePath = (String)annotation.getDetails().get((Object)"readmePath");
                    if (this.readmePath != null) break;
                }
                scope = scope.getParentScope();
            }
            this.showReadmeButton.setVisible(this.readmePath != null);
            if (this.createStartMenuEntryButton != null || this.createDesktopShortcutButton != null) {
                String productName;
                File executable = ProgressPage.getExecutable((SetupTaskPerformer)this.performer);
                ProductCatalog productCatalog = this.product.getProductCatalog();
                String catalogName = "user.products".equals(productCatalog.getName()) ? "" : productCatalog.getLabel();
                int firstDot = catalogName.indexOf(46);
                if (firstDot != -1) {
                    catalogName = catalogName.substring(0, firstDot);
                }
                if ((productName = this.product.getName()).startsWith("epp.package.")) {
                    productName = productName.substring("epp.package.".length());
                }
                productName = productName.replace('.', ' ');
                String qualifiedProductName = String.valueOf(productName) + " " + this.selectedProductVersion.getName().replace('.', ' ');
                String shortCutName = StringUtil.capAll((String)(StringUtil.isEmpty((String)catalogName) ? qualifiedProductName : String.valueOf(catalogName) + " " + qualifiedProductName));
                if (this.createStartMenuEntryButton != null && this.createStartMenuEntryButton.isChecked()) {
                    KeepInstallerUtil.createShortCut("Programs", "Eclipse", executable.getAbsolutePath(), shortCutName);
                }
                if (this.createDesktopShortcutButton != null && this.createDesktopShortcutButton.isChecked()) {
                    KeepInstallerUtil.createShortCut("Desktop", null, executable.getAbsolutePath(), shortCutName);
                }
            }
            this.showSuccessMessage();
            this.backButton.setEnabled(true);
        } else {
            this.setEnabled(true);
            this.installButton.setCurrentState(SimpleInstallLaunchButton.State.INSTALL);
            this.showErrorMessage();
        }
        this.dialog.setButtonsEnabled(true);
    }

    private void showSuccessMessage() {
        this.dialog.showMessage(MESSAGE_SUCCESS, SimpleMessageOverlay.Type.SUCCESS, true);
        this.installStack.setTopControl((Control)this.afterInstallComposite);
        this.installStack.setVisible(true);
        this.layout(true, true);
    }

    private void showErrorMessage() {
        SimpleMessageOverlay.RunnableWithLabel action = null;
        String errorMessage = this.installError;
        if (this.isInstallLogAvailable()) {
            action = new SimpleMessageOverlay.RunnableWithLabel(){

                public void run() {
                    SimpleVariablePage.this.openInstallLog();
                }

                public String getLabel() {
                    return "Show log.";
                }
            };
        }
        this.dialog.showMessage(errorMessage, SimpleMessageOverlay.Type.ERROR, false, action);
        this.installStack.setTopControl((Control)this.errorComposite);
        this.installStack.setVisible(true);
        this.layout(true, true);
    }

    private void launchProduct() {
        this.launchProduct(EXIT_AFTER_LAUNCH);
    }

    private void launchProduct(boolean exitAfterLaunch) {
        try {
            ProgressPage.launchProduct((SetupTaskPerformer)this.performer);
        }
        catch (Exception ex) {
            SetupInstallerPlugin.INSTANCE.log(ex);
        }
        if (exitAfterLaunch) {
            this.dialog.exitQuiet();
        }
    }

    private void setFolderText(String dir) {
        this.folderText.setText(dir);
        this.folderText.setToolTipText(dir);
    }

    private void validatePage() {
        String errorMessage = null;
        errorMessage = this.validateJREs();
        if (errorMessage == null) {
            errorMessage = this.validateFolderText(this.folderText.getText());
        }
        if (this.isTop()) {
            if (errorMessage != null) {
                this.dialog.showMessage(errorMessage, SimpleMessageOverlay.Type.ERROR, false, null);
            } else {
                this.dialog.clearMessage();
            }
        }
        this.installButton.setEnabled(errorMessage == null);
    }

    public void aboutToShow() {
        super.aboutToShow();
        this.keepInstallerButton.setVisible(KeepInstallerUtil.canKeepInstaller());
        this.validatePage();
    }

    private String validateJREs() {
        Object input = this.javaViewer.getInput();
        if (input instanceof Collection && ((Collection)input).isEmpty()) {
            return "Configuration of JRE failed.";
        }
        return null;
    }

    private String validateFolderText(String dir) {
        String errorMessage;
        block5: {
            this.installFolder = dir;
            errorMessage = null;
            try {
                if (!StringUtil.isEmpty((String)this.installFolder)) break block5;
                return "Installation folder must be specified.";
            }
            catch (Exception exception) {}
        }
        File folder = new File(this.installFolder);
        File parentFolder = folder.getParentFile();
        if (!this.isValidParentFolder(parentFolder) || folder.isFile() || folder.isDirectory() && !folder.canWrite()) {
            String name = folder.getName();
            if (StringUtil.isEmpty((String)name)) {
                name = dir;
            }
            return "Folder " + name + " cannot be created.";
        }
        this.installRoot = parentFolder.getAbsolutePath();
        return errorMessage;
    }

    private boolean isValidParentFolder(File parentFolder) {
        if (parentFolder == null) {
            return false;
        }
        if (parentFolder.exists()) {
            return parentFolder.isDirectory() && parentFolder.canWrite();
        }
        return this.isValidParentFolder(parentFolder.getParentFile());
    }

    private File getLogFile() {
        String relativeProductFolder = this.performer.getRelativeProductFolder();
        return new File(this.installFolder, String.valueOf(relativeProductFolder) + "/configuration/org.eclipse.oomph.setup/setup.log");
    }

    private void openInstallLog() {
        File installationLogFile = this.getLogFile();
        this.dialog.showInstallationLog(installationLogFile);
    }

    private boolean isInstallLogAvailable() {
        return this.performer != null && this.getLogFile().exists();
    }

    private SimpleCheckbox createCheckbox(Composite parent, String text) {
        SimpleCheckbox checkbox = new SimpleCheckbox(parent);
        checkbox.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        checkbox.setText(text);
        checkbox.setChecked(true);
        return checkbox;
    }

    static /* synthetic */ void access$22(SimpleVariablePage simpleVariablePage, String string) {
        simpleVariablePage.installError = string;
    }

    static /* synthetic */ void access$23(SimpleVariablePage simpleVariablePage, SetupTaskPerformer setupTaskPerformer) {
        simpleVariablePage.performer = setupTaskPerformer;
    }

    static /* synthetic */ void access$24(SimpleVariablePage simpleVariablePage, SimpleProgress simpleProgress) {
        simpleVariablePage.progress = simpleProgress;
    }

    static /* synthetic */ SimpleProgress access$25(SimpleVariablePage simpleVariablePage) {
        return simpleVariablePage.progress;
    }

    static /* synthetic */ void access$27(SimpleVariablePage simpleVariablePage) throws Exception {
        simpleVariablePage.installPerform();
    }

    private final class SimpleProgress
    implements ProgressLog,
    IProgressMonitor,
    Runnable {
        private volatile String name;
        private volatile double totalWork;
        private volatile double work;
        private volatile double lastWork;
        private volatile long reportWarningTimeout;
        private volatile boolean canceled;
        private volatile boolean done;
        private String lastName;

        private SimpleProgress() {
        }

        public void setTerminating() {
        }

        public void log(String line) {
            this.log(line, true, ProgressLog.Severity.OK);
        }

        public void log(String line, ProgressLog.Severity severity) {
            this.log(line, true, severity);
        }

        public void log(String line, boolean filter) {
            this.log(line, filter, ProgressLog.Severity.OK);
        }

        public synchronized void log(String line, boolean filter, ProgressLog.Severity severity) {
            this.name = line;
        }

        public void log(IStatus status) {
            String string = SetupInstallerPlugin.toString((IStatus)status);
            this.log(string, false);
        }

        public void log(Throwable t) {
            String string = SetupInstallerPlugin.toString((Throwable)t);
            this.log(string, false);
        }

        public synchronized void task(SetupTask setupTask) {
            this.name = setupTask != null ? "Performing setup task " + setupTask.eClass().getName() : null;
        }

        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        public synchronized void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }

        public synchronized void beginTask(String name, int totalWork) {
            SimpleVariablePage.this.performer.log(name);
            if (this.totalWork == 0.0) {
                this.totalWork = totalWork;
                this.schedule();
            }
        }

        public synchronized void done() {
            this.work = this.totalWork;
            this.done = true;
        }

        public synchronized void setTaskName(String name) {
            SimpleVariablePage.this.performer.log(name);
        }

        public synchronized void subTask(String name) {
            SimpleVariablePage.this.performer.log(name);
        }

        public synchronized void internalWorked(double work) {
            this.work += work;
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done;
            boolean canceled;
            double work;
            double totalWork;
            String name;
            SimpleProgress simpleProgress = this;
            synchronized (simpleProgress) {
                name = this.name;
                totalWork = this.totalWork;
                work = this.work;
                canceled = this.canceled;
                done = this.done;
            }
            if (!canceled) {
                String safeName = StringUtil.safe((String)name);
                if (PROGRESS_WATCHDOG_TIMEOUT != 0) {
                    long now = System.currentTimeMillis();
                    if (this.lastWork == work) {
                        if (now >= this.reportWarningTimeout) {
                            SimpleVariablePage.this.dialog.showMessage(("The installation process is taking longer than usual: " + safeName).replace(' ', '\u00a0'), SimpleMessageOverlay.Type.WARNING, false);
                            SimpleVariablePage.this.installButton.setProgressAnimationSpeed(0.4f);
                            this.resetWatchdogTimer(now);
                        }
                    } else {
                        SimpleVariablePage.this.installButton.startProgressAnimation();
                        SimpleVariablePage.this.installButton.setProgressAnimationSpeed(1.0f);
                        SimpleVariablePage.this.dialog.clearMessage();
                        this.resetWatchdogTimer(now);
                        this.lastWork = work;
                    }
                }
                double progress = work / totalWork;
                try {
                    SimpleVariablePage.this.installButton.setProgress((float)progress);
                    if (!ObjectUtil.equals((Object)name, (Object)this.lastName)) {
                        this.lastName = name;
                        if (!done) {
                            SimpleVariablePage.this.installButton.setToolTipText(safeName);
                        }
                    }
                }
                catch (SWTException sWTException) {
                    return;
                }
                if (!done) {
                    this.schedule();
                }
            }
        }

        private void resetWatchdogTimer(long now) {
            this.reportWarningTimeout = now + (long)(PROGRESS_WATCHDOG_TIMEOUT * 1000);
        }

        private void schedule() {
            UIUtil.asyncExec((Display)SimpleVariablePage.this.getDisplay(), (Runnable)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SimplePrompter
    extends HashMap<String, String>
    implements SetupPrompter {
        private static final long serialVersionUID = 1L;
        private final List<VariableTask> unresolvedVariables = new ArrayList<VariableTask>();

        public List<VariableTask> getUnresolvedVariables() {
            return this.unresolvedVariables;
        }

        public boolean promptVariables(List<? extends SetupTaskContext> performers) {
            for (SetupTaskContext setupTaskContext : performers) {
                List unresolvedVariables = ((SetupTaskPerformer)setupTaskContext).getUnresolvedVariables();
                for (VariableTask variable : unresolvedVariables) {
                    String value = this.getValue(variable);
                    if (value != null) continue;
                    this.unresolvedVariables.add(variable);
                }
            }
            return this.unresolvedVariables.isEmpty();
        }

        public String getValue(VariableTask variable) {
            String name = variable.getName();
            return (String)this.get(name);
        }

        public UserCallback getUserCallback() {
            return null;
        }
    }

    private static final class UnloggedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnloggedException(String message) {
            super(message);
        }
    }

    private static class UserAdjuster {
        private static final URI INSTALLATION_LOCATION_ATTRIBUTE_URI = SetupTaskPerformer.getAttributeURI((EAttribute)SetupPackage.Literals.INSTALLATION_TASK__LOCATION);
        private EList<AttributeRule> attributeRules;
        private String oldValue;

        private UserAdjuster() {
        }

        private void adjust(User user, String installFolder) {
            AttributeRule attributeRule2;
            this.attributeRules = user.getAttributeRules();
            for (AttributeRule attributeRule2 : this.attributeRules) {
                if (!INSTALLATION_LOCATION_ATTRIBUTE_URI.equals(attributeRule2.getAttributeURI())) continue;
                this.oldValue = attributeRule2.getValue();
                attributeRule2.setValue(installFolder);
                return;
            }
            attributeRule2 = SetupFactory.eINSTANCE.createAttributeRule();
            attributeRule2.setAttributeURI(INSTALLATION_LOCATION_ATTRIBUTE_URI);
            attributeRule2.setValue(installFolder);
            this.attributeRules.add((Object)attributeRule2);
        }

        public void undo() {
            Iterator it = this.attributeRules.iterator();
            while (it.hasNext()) {
                AttributeRule attributeRule = (AttributeRule)it.next();
                if (!INSTALLATION_LOCATION_ATTRIBUTE_URI.equals(attributeRule.getAttributeURI())) continue;
                if (this.oldValue == null) {
                    it.remove();
                } else {
                    attributeRule.setValue(this.oldValue);
                }
                return;
            }
        }
    }
}

