/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.internal.ui.ToggleSwitchButton;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SimpleInstallerMenu
extends Shell
implements Listener {
    private static Point defaultSize;

    public SimpleInstallerMenu(Shell parent) {
        super(parent, 8);
        Point defaultSize = SimpleInstallerMenu.getDefaultSize((Drawable)parent);
        this.setSize(defaultSize.x, defaultSize.y);
        this.setBackground(SetupInstallerPlugin.getColor((int)247, (int)148, (int)31));
        this.setBackgroundMode(2);
        GridLayout layout = UIUtil.createGridLayout((int)1);
        layout.marginHeight = 19;
        layout.marginWidth = 28;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        ImageHoverButton closeButton = new ImageHoverButton((Composite)this, 8, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close_hover.png"));
        closeButton.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(0x1000008, 1).create());
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerMenu.this.close();
            }
        });
        this.hookListeners();
    }

    public InstallerMenuItem findMenuItemByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof InstallerMenuItem && name.equals(((InstallerMenuItem)child).getText())) {
                return (InstallerMenuItem)child;
            }
            ++n2;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.adjustPosition();
        }
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
            this.forceFocus();
        }
    }

    public void close() {
        this.setVisible(false);
    }

    protected void checkSubclass() {
    }

    private void hookListeners() {
        Composite parent = this.getParent();
        parent.addListener(10, (Listener)this);
        parent.addListener(11, (Listener)this);
        Display display = this.getDisplay();
        display.addFilter(16, (Listener)this);
        display.addFilter(15, (Listener)this);
        display.addFilter(3, (Listener)this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SimpleInstallerMenu.this.removeDisposeListener(this);
                SimpleInstallerMenu.this.unhookListeners();
            }
        });
    }

    private void unhookListeners() {
        Display display = this.getDisplay();
        display.removeFilter(3, (Listener)this);
        display.removeFilter(15, (Listener)this);
        display.removeFilter(16, (Listener)this);
        Composite parent = this.getParent();
        parent.removeListener(11, (Listener)this);
        parent.removeListener(10, (Listener)this);
    }

    private void adjustPosition() {
        Composite parent = this.getParent();
        Rectangle bounds = parent.getBounds();
        Point menuStartLocation = new Point(bounds.x + bounds.width, bounds.y + 75);
        parent.toDisplay(menuStartLocation);
        Point prefSize = this.computeSize(-1, -1);
        Point size = new Point(Math.max(prefSize.x, SimpleInstallerMenu.getDefaultSize((Drawable)parent).x), Math.max(prefSize.y, bounds.height - 80) - 5);
        this.setBounds(menuStartLocation.x, menuStartLocation.y, size.x, size.y);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 10: 
            case 11: {
                this.adjustPosition();
                break;
            }
            case 3: 
            case 15: 
            case 16: {
                if (!this.closeMenu(event)) break;
                this.close();
            }
        }
    }

    private boolean closeMenu(Event event) {
        Display display = this.getDisplay();
        Control focusControl = display.getFocusControl();
        Control cursorControl = display.getCursorControl();
        if (cursorControl == null) {
            return true;
        }
        if (focusControl == this) {
            return false;
        }
        boolean menuButtonPressed = "menuButton".equals(AccessUtil.getKey((Widget)cursorControl));
        if (!menuButtonPressed && event.type == 16 && focusControl != null) {
            menuButtonPressed = "menuButton".equals(AccessUtil.getKey((Widget)focusControl));
        }
        if (menuButtonPressed) {
            return false;
        }
        return focusControl == null || !UIUtil.isParent((Composite)this, (Control)focusControl);
    }

    private static Point getDefaultSize(Drawable drawable) {
        if (defaultSize == null) {
            defaultSize = SimpleInstallerDialog.computeSize(drawable, InstallerMenuItem.FONT, 15, 24);
        }
        return defaultSize;
    }

    public static class InstallerMenuItem
    extends Composite {
        private static final Font FONT = SimpleInstallerDialog.getFont(4, "bold");
        private ImageHoverButton button;
        private Divider divider;
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).hint(-1, 36).create();

        public InstallerMenuItem(final SimpleInstallerMenu menu) {
            super((Composite)menu, 0);
            GridLayout layout = UIUtil.createGridLayout((int)1);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            this.setLayout((Layout)layout);
            this.setLayoutData(this.gridData);
            Composite content = new Composite((Composite)this, 0);
            content.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            this.createContent(content);
            this.divider = new Divider(this, 1);
            this.divider.setBackground(AbstractSimpleDialog.COLOR_WHITE);
            this.divider.setLayoutData(GridDataFactory.swtDefaults().align(4, 0x1000008).grab(true, false).create());
            this.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    menu.close();
                }
            });
        }

        public void createContent(Composite content) {
            GridLayout layout = UIUtil.createGridLayout((int)1);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            content.setLayout((Layout)layout);
            this.button = new ImageHoverButton(content, 8);
            this.button.setAlignment(16384);
            this.button.setForeground(AbstractSimpleDialog.COLOR_WHITE);
            this.button.setFont(FONT);
            this.button.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).create());
            this.button.setText("");
            Point defaultButtonSize = this.button.computeSize(-1, -1);
            this.gridData.heightHint = defaultButtonSize.y + 5;
        }

        public void setDefaultImage(Image defaultImage) {
            this.button.setDefaultImage(defaultImage);
        }

        public void setHoverImage(Image hoverImage) {
            this.button.setHoverImage(hoverImage);
        }

        public void addSelectionListener(SelectionListener listener) {
            this.button.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            this.button.removeSelectionListener(listener);
        }

        public String getText() {
            return this.button.getText();
        }

        public void setText(String text) {
            this.button.setText(text);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            Object data = this.getLayoutData();
            if (data instanceof GridData) {
                ((GridData)data).exclude = !visible;
                Composite parent = this.getParent();
                if (parent != null) {
                    parent.layout();
                }
            }
        }

        public boolean isdDividerVisible() {
            return !((GridData)this.divider.getLayoutData()).exclude;
        }

        public void setDividerVisible(boolean visible) {
            ((GridData)this.divider.getLayoutData()).exclude = !visible;
            this.layout();
        }

        private static final class Divider
        extends Composite
        implements PaintListener {
            private final int height;

            public Divider(Composite parent, int height) {
                super(parent, 0);
                this.height = height;
                this.addPaintListener(this);
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(wHint > 0 ? wHint : 0, this.height);
            }

            public void paintControl(PaintEvent e) {
                Rectangle clientArea = this.getClientArea();
                e.gc.fillRectangle(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            }
        }
    }

    public static class InstallerMenuItemWithToggle
    extends InstallerMenuItem {
        private ToggleSwitchButton toggleSwitch;

        public InstallerMenuItemWithToggle(SimpleInstallerMenu menu) {
            super(menu);
        }

        public void createContent(Composite content) {
            super.createContent(content);
            GridLayout layout = UIUtil.createGridLayout((int)2);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            content.setLayout((Layout)layout);
            this.toggleSwitch = new ToggleSwitchButton(content);
            this.toggleSwitch.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        }

        public ToggleSwitchButton getToggleSwitch() {
            return this.toggleSwitch;
        }
    }
}

