/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.oomph.setup.ResourceCopyTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.util.IOUtil;

public class ResourceCopyTaskImpl
extends SetupTaskImpl
implements ResourceCopyTask {
    protected static final boolean FORCE_EDEFAULT = false;
    protected boolean force = false;
    protected static final String SOURCE_URL_EDEFAULT = null;
    protected String sourceURL = SOURCE_URL_EDEFAULT;
    protected static final String TARGET_URL_EDEFAULT = null;
    protected String targetURL = TARGET_URL_EDEFAULT;

    protected ResourceCopyTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.RESOURCE_COPY_TASK;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean newForce) {
        boolean oldForce = this.force;
        this.force = newForce;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldForce, this.force));
        }
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String newSourceURL) {
        String oldSourceURL = this.sourceURL;
        this.sourceURL = newSourceURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldSourceURL, (Object)this.sourceURL));
        }
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public void setTargetURL(String newTargetURL) {
        String oldTargetURL = this.targetURL;
        this.targetURL = newTargetURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldTargetURL, (Object)this.targetURL));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.isForce();
            }
            case 11: {
                return this.getSourceURL();
            }
            case 12: {
                return this.getTargetURL();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setForce((Boolean)newValue);
                return;
            }
            case 11: {
                this.setSourceURL((String)newValue);
                return;
            }
            case 12: {
                this.setTargetURL((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setForce(false);
                return;
            }
            case 11: {
                this.setSourceURL(SOURCE_URL_EDEFAULT);
                return;
            }
            case 12: {
                this.setTargetURL(TARGET_URL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.force;
            }
            case 11: {
                return SOURCE_URL_EDEFAULT == null ? this.sourceURL != null : !SOURCE_URL_EDEFAULT.equals(this.sourceURL);
            }
            case 12: {
                return TARGET_URL_EDEFAULT == null ? this.targetURL != null : !TARGET_URL_EDEFAULT.equals(this.targetURL);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (force: ");
        result.append(this.force);
        result.append(", sourceURL: ");
        result.append(this.sourceURL);
        result.append(", targetURL: ");
        result.append(this.targetURL);
        result.append(')');
        return result.toString();
    }

    public int getProgressMonitorWork() {
        return 2;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        URI sourceURI = this.createResolvedURI(this.getSourceURL());
        URI targetURI = this.createResolvedURI(this.getTargetURL());
        if (sourceURI == null || targetURI == null) {
            return false;
        }
        URIConverter uriConverter = context.getURIConverter();
        if (targetURI.hasTrailingPathSeparator()) {
            if (sourceURI.hasTrailingPathSeparator()) {
                if (uriConverter.normalize(targetURI).isFile() && uriConverter.normalize(sourceURI).isFile()) {
                    return this.isForce() || !uriConverter.exists(targetURI, null);
                }
                return true;
            }
            return this.isForce() || !uriConverter.exists(targetURI.appendSegment(sourceURI.lastSegment()), null);
        }
        return this.isForce() || !uriConverter.exists(targetURI, null);
    }

    public void perform(SetupTaskContext context) throws Exception {
        URI sourceURI = this.createResolvedURI(this.getSourceURL());
        URI targetURI = this.createResolvedURI(this.getTargetURL());
        URIConverter uriConverter = context.getURIConverter();
        URI normalizedSourceURI = uriConverter.normalize(sourceURI);
        URI normalizedTargetURI = uriConverter.normalize(targetURI);
        if (targetURI.hasTrailingPathSeparator()) {
            if (sourceURI.hasTrailingPathSeparator()) {
                if (normalizedTargetURI.isFile() && normalizedSourceURI.isFile()) {
                    IOUtil.copyTree((File)new File(normalizedSourceURI.toFileString()), (File)new File(normalizedTargetURI.toFileString()));
                } else {
                    context.log("Unsupported copying folder " + normalizedSourceURI + " to " + normalizedTargetURI);
                }
            } else if (uriConverter.exists(sourceURI, null)) {
                URI targetResourceURI = targetURI.appendSegment(sourceURI.lastSegment());
                context.log("Copying resource " + normalizedSourceURI + " to " + uriConverter.normalize(targetResourceURI));
                InputStream input = null;
                OutputStream output = null;
                try {
                    input = uriConverter.createInputStream(sourceURI);
                    output = uriConverter.createOutputStream(targetResourceURI, null);
                    IOUtil.copy((InputStream)input, (OutputStream)output);
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent((Closeable)input);
                    IOUtil.closeSilent(output);
                    throw throwable;
                }
                IOUtil.closeSilent((Closeable)input);
                IOUtil.closeSilent((Closeable)output);
            }
        } else if (uriConverter.exists(sourceURI, null)) {
            context.log("Copying resource " + normalizedSourceURI + " to " + normalizedTargetURI);
            InputStream input = null;
            OutputStream output = null;
            try {
                input = uriConverter.createInputStream(sourceURI);
                output = uriConverter.createOutputStream(targetURI, null);
                IOUtil.copy((InputStream)input, (OutputStream)output);
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent((Closeable)input);
                IOUtil.closeSilent(output);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)input);
            IOUtil.closeSilent((Closeable)output);
        } else {
            context.log("Cannot copy non-existing " + normalizedSourceURI + " to " + normalizedTargetURI);
        }
    }
}

